/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.SDR.record;

import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.utility.SDR.record.CompactSensorRecord;
import Gbt.utility.SDR.record.DeviceRelativeEntityAssiciationRecord;
import Gbt.utility.SDR.record.EntityAssociationRecord;
import Gbt.utility.SDR.record.EventOnlyRecord;
import Gbt.utility.SDR.record.FruDeviceLocatorRecord;
import Gbt.utility.SDR.record.FullSensorRecord;
import Gbt.utility.SDR.record.GenericDeviceLocatorRecord;
import Gbt.utility.SDR.record.ManagementControllerConfirmationRecord;
import Gbt.utility.SDR.record.ManagementControllerDeviceLocatorRecord;
import Gbt.utility.SDR.record.OemRecord;
import Gbt.utility.SDR.record.SensorState;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.veraxsystems.vxipmi.common.TypeConverter;
import java.nio.charset.Charset;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY)
public abstract class SensorRecord
extends AbstractJSONPOJO {
    private static final byte FULL_SENSOR_RECORD = 1;
    private static final byte COMPACT_SENSOR_RECORD = 2;
    private static final byte EVENT_ONLY_RECORD = 3;
    private static final byte ENTITY_ASSOCIATION_RECORD = 8;
    private static final byte DEVICE_RELATIVE_ENTITY_ASSOCIATION_RECORD = 9;
    private static final byte GENERIC_DEVICE_LOCATOR_RECORD = 16;
    private static final byte FRU_DEVICE_LOCATOR_RECORD = 17;
    private static final byte MANAGEMENT_CONTROLLER_DEVICE_LOCATOR_RECORD = 18;
    private static final byte MANAGEMENT_CONTROLLER_CONFIRMATION_RECORD = 19;
    private static final byte BMC_MESSAGE_CHANNEL_INFO_RECORD = 20;
    private static final byte OEM_RECORD = -64;
    private int id;
    private int sdrVersion;
    private Byte recordType;
    private int recordLength;
    private SensorState sensorState;

    public static final SensorRecord populateSensorRecord(byte[] recordData) {
        if (recordData.length < 5) {
            return null;
        }
        SensorRecord sensorRecord = null;
        byte recType = recordData[3];
        switch (recType) {
            case 1: {
                sensorRecord = new FullSensorRecord();
                break;
            }
            case 20: {
                return sensorRecord;
            }
            case 2: {
                sensorRecord = new CompactSensorRecord();
                break;
            }
            case 9: {
                sensorRecord = new DeviceRelativeEntityAssiciationRecord();
                break;
            }
            case 8: {
                sensorRecord = new EntityAssociationRecord();
                break;
            }
            case 3: {
                sensorRecord = new EventOnlyRecord();
                break;
            }
            case 17: {
                sensorRecord = new FruDeviceLocatorRecord();
                break;
            }
            case 16: {
                sensorRecord = new GenericDeviceLocatorRecord();
                break;
            }
            case 19: {
                sensorRecord = new ManagementControllerConfirmationRecord();
                break;
            }
            case 18: {
                sensorRecord = new ManagementControllerDeviceLocatorRecord();
                break;
            }
            case -64: {
                sensorRecord = new OemRecord();
                break;
            }
            default: {
                return sensorRecord;
            }
        }
        byte[] buffer = new byte[]{recordData[0], recordData[1], 0, 0};
        sensorRecord.setId(TypeConverter.littleEndianByteArrayToInt(buffer));
        sensorRecord.setSdrVersion(TypeConverter.littleEndianBcdByteToInt(recordData[2]));
        sensorRecord.setRecordType(recordData[3]);
        sensorRecord.setRecordLength(TypeConverter.byteToInt(recordData[4]));
        sensorRecord.populateTypeSpecficValues(recordData, sensorRecord);
        return sensorRecord;
    }

    protected abstract void populateTypeSpecficValues(byte[] var1, SensorRecord var2);

    protected final String decodeName(byte codingType, byte[] name) {
        switch ((TypeConverter.byteToInt(codingType) & 0xC0) >> 6) {
            case 0: {
                return new String(name, Charset.forName("UTF-8"));
            }
            case 1: {
                return TypeConverter.decodeBcdPlus(name);
            }
            case 2: {
                return TypeConverter.decode6bitAscii(name);
            }
            case 3: {
                return new String(name, Charset.forName("ISO-8859-1"));
            }
        }
        return "Invalid coding type.";
    }

    @JsonProperty(value="Id")
    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @JsonProperty(value="SdrVersion")
    public int getSdrVersion() {
        return this.sdrVersion;
    }

    public void setSdrVersion(int sdrVersion) {
        this.sdrVersion = sdrVersion;
    }

    @JsonProperty(value="RecordType")
    public Byte getRecordType() {
        return this.recordType;
    }

    public void setRecordType(Byte recordType) {
        this.recordType = recordType;
    }

    @JsonProperty(value="RecordLength")
    public int getRecordLength() {
        return this.recordLength;
    }

    public void setRecordLength(int recordLength) {
        this.recordLength = recordLength;
    }

    @JsonProperty(value="SensorState")
    public SensorState getSensorState() {
        return this.sensorState;
    }

    public void setSensorState(SensorState sensorState) {
        this.sensorState = sensorState;
    }
}

