/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.SMBIOS;

import com.fasterxml.jackson.annotation.JsonValue;

public enum WakeUpType {
    Reserved(0, "Reserved"),
    Other(1, "Other"),
    Unknown(2, "Unknown"),
    APMTimer(3, "APM Timer"),
    ModemRing(4, "Modem Ring"),
    LANRemote(5, "LAN Remote"),
    PowerSwitch(6, "Power Switch"),
    PCI_PME(7, "PCI PME#"),
    ACPowerRestored(8, "AC Power Restored");

    private static final byte B0 = 0;
    private static final byte B1 = 1;
    private static final byte B2 = 2;
    private static final byte B3 = 3;
    private static final byte B4 = 4;
    private static final byte B5 = 5;
    private static final byte B6 = 6;
    private static final byte B7 = 7;
    private static final byte B8 = 8;
    private static final String ITEM_0 = "Reserved";
    private static final String ITEM_1 = "Other";
    private static final String ITEM_2 = "Unknown";
    private static final String ITEM_3 = "APM Timer";
    private static final String ITEM_4 = "Modem Ring";
    private static final String ITEM_5 = "LAN Remote";
    private static final String ITEM_6 = "Power Switch";
    private static final String ITEM_7 = "PCI PME#";
    private static final String ITEM_8 = "AC Power Restored";
    private final byte code;
    private final String item;

    private WakeUpType(byte code, String item) {
        this.code = code;
        this.item = item;
    }

    public byte getCode() {
        return this.code;
    }

    @JsonValue
    public String toString() {
        return this.item;
    }

    public static final WakeUpType parseByByte(byte code) {
        switch (code) {
            case 0: {
                return Reserved;
            }
            case 1: {
                return Other;
            }
            case 2: {
                return Unknown;
            }
            case 3: {
                return APMTimer;
            }
            case 4: {
                return ModemRing;
            }
            case 5: {
                return LANRemote;
            }
            case 6: {
                return PowerSwitch;
            }
            case 7: {
                return PCI_PME;
            }
            case 8: {
                return ACPowerRestored;
            }
        }
        return null;
    }
}

