/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.Update;

import Gbt.core.commands.AbstractCommand;
import Gbt.core.commands.AbstractCommandBuilder;
import Gbt.core.commands.GbtCommandBuilders;
import Gbt.core.engines.records.CommandTaskRecords;
import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.receivers.GbtIPMICommandReceiver;
import Gbt.core.receivers.GbtLocalCommandReceiver;
import Gbt.utility.API.GbtUtilityAPI2;
import Gbt.utility.Common.UncompressFile;
import Gbt.utility.FRU.record.BoardInfo;
import Gbt.utility.FRU.record.FruRecord;
import Gbt.utility.FRU.record.ProductInfo;
import Gbt.utility.Update.UpdateType;
import Gbt.utility.Update.fwInfo.CommonUpdateFWInfo;
import Gbt.utility.Update.parsers.BiosSuitableFwParser;
import Gbt.utility.Update.parsers.SuitableFwParser;
import Gbt.utility.bmcinfo.BMCInfoJSONData;
import Gbt.utility.bmcinfo.BMCVendor;
import com.veraxsystems.vxipmi.api.async.ConnectionHandle;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;

public final class PreUpdateCommand
extends AbstractCommand<Builder> {
    public static final String COMMAND_NAME = "preupdate";
    private final GbtIPMICommandReceiver ipmiReceiver;
    private final GbtLocalCommandReceiver localReceiver;

    protected PreUpdateCommand(Builder commandArgs) {
        super(commandArgs);
        this.commandID = ((Builder)this.commandArgs).bmcIP + "_" + COMMAND_NAME + "_" + ((Builder)this.commandArgs).updateType.toString();
        this.ipmiReceiver = GbtIPMICommandReceiver.getInstance();
        this.localReceiver = GbtLocalCommandReceiver.getInstance();
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String getDocumentsName() {
        return COMMAND_NAME;
    }

    @Override
    public boolean checkAll() {
        if (!((Builder)this.commandArgs).checkArgs()) {
            return false;
        }
        if (this.ipmiReceiver == null) {
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI receiver is null.");
            return false;
        }
        if (this.localReceiver == null) {
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Local command receiver is null.");
            return false;
        }
        return true;
    }

    @Override
    public boolean execute() {
        ConnectionHandle handle = null;
        BoardInfo boardInfo = null;
        ProductInfo productInfo = null;
        BMCInfoJSONData bmcInfo = null;
        SuitableFwParser parser = null;
        CommonUpdateFWInfo updatFWInfo = null;
        List<FruRecord> fruRecords = null;
        if (((Builder)this.commandArgs).isLocal) {
            bmcInfo = this.localReceiver.getBMCInfoByLocalCmd(this.getCommandName(), this.commandID);
            bmcInfo.setBmcVendor(BMCVendor.VERTIV);
            fruRecords = this.localReceiver.getFRURecordsByLocalCmd(bmcInfo, this.getCommandName(), this.commandID);
            if (fruRecords == null) {
                ((Builder)this.commandArgs).isContinue = false;
                this.commandResults.add(new NullJSONData().setError(true).setMessages("IPMI send message fail."));
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                return false;
            }
        } else {
            handle = this.ipmiReceiver.createIPMIConnection(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword, this.getCommandName(), this.commandID);
            if (handle == null) {
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, ((Builder)this.commandArgs).bmcIP + "] IPMI connection fail.");
                ((Builder)this.commandArgs).isContinue = false;
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                this.commandResults.add(new NullJSONData().setError(true).setMessages("IPMI connection fail."));
                return false;
            }
            CommandTaskRecords report = GbtUtilityAPI2.commonCommand(GbtCommandBuilders.mcinfo(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword));
            AbstractJSONPOJO data = report.getResultData().get(0);
            if (data instanceof NullJSONData) {
                NullJSONData temp = data.castConcreteJSON(NullJSONData.class);
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + temp.getMessages());
                this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                this.commandResults.add(new NullJSONData().setError(true).setMessages("IPMI send message fail."));
                return false;
            }
            bmcInfo = data.castConcreteJSON(BMCInfoJSONData.class);
        }
        switch (((Builder)this.commandArgs).updateType) {
            case CMC: 
            case BMC: 
            case CPLDBPB: {
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Start to execute preupdate " + ((Builder)this.commandArgs).updateType.toString() + ".");
                if (!this.uncompressFWPkgs()) {
                    this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                    ((Builder)this.commandArgs).isContinue = false;
                    this.commandResults.add(new NullJSONData().setError(true).setMessages("[" + ((Builder)this.commandArgs).bmcIP + "] Extract FW pkg fail."));
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                    return false;
                }
                if (((Builder)this.commandArgs).isLocal) {
                    boardInfo = this.ipmiReceiver.parserFRURecords(fruRecords, BoardInfo.class);
                    productInfo = this.ipmiReceiver.parserFRURecords(fruRecords, ProductInfo.class);
                } else {
                    fruRecords = this.ipmiReceiver.getFRU(handle, bmcInfo.isAST2400() || bmcInfo.isCMC() ? 0 : 1, 16, this.getCommandName(), this.commandID);
                    if (fruRecords == null) {
                        this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                        ((Builder)this.commandArgs).isContinue = false;
                        this.commandResults.add(new NullJSONData().setError(true).setMessages("IPMI send message fail."));
                        this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                        return false;
                    }
                    boardInfo = this.ipmiReceiver.parserFRURecords(fruRecords, BoardInfo.class);
                    productInfo = this.ipmiReceiver.parserFRURecords(fruRecords, ProductInfo.class);
                }
                if (boardInfo == null) {
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Board info is empty.");
                    this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                    return false;
                }
                if (productInfo == null) {
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Product info is empty.");
                    this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                    return false;
                }
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Board Product     : " + boardInfo.getBoardProductName());
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Product Name      : " + productInfo.getProductName());
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] BMC Product ID    : " + bmcInfo.getProductID());
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] BMC FW Revision   : " + bmcInfo.getFirmwareRevision());
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] BMC platform      : " + bmcInfo.getProductName().toString());
                break;
            }
            case BIOS: {
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Start to execute preupdate " + ((Builder)this.commandArgs).updateType.toString() + ".");
                if (!this.uncompressFWPkgs()) {
                    this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                    ((Builder)this.commandArgs).isContinue = false;
                    this.commandResults.add(new NullJSONData().setError(true).setMessages("[" + ((Builder)this.commandArgs).bmcIP + "] Extract FW pkg fail."));
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                    return false;
                }
                if (((Builder)this.commandArgs).isLocal) {
                    if (bmcInfo.isCMC()) {
                        this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + (Object)((Object)((Builder)this.commandArgs).updateType) + " update not support CMC target.");
                        this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                        this.commandResults.add(new NullJSONData().setError(true).setMessages("BIOS update not support CMC target."));
                        this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                        return false;
                    }
                    boardInfo = this.ipmiReceiver.parserFRURecords(fruRecords, BoardInfo.class);
                    productInfo = this.ipmiReceiver.parserFRURecords(fruRecords, ProductInfo.class);
                } else {
                    if (bmcInfo.isCMC()) {
                        this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + (Object)((Object)((Builder)this.commandArgs).updateType) + " update not support CMC target.");
                        this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                        this.commandResults.add(new NullJSONData().setError(true).setMessages("BIOS update not support CMC target."));
                        this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                        return false;
                    }
                    fruRecords = this.ipmiReceiver.getFRU(handle, bmcInfo.isAST2400() ? 0 : 1, 16, this.getCommandName(), this.commandID);
                    if (fruRecords == null) {
                        this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                        ((Builder)this.commandArgs).isContinue = false;
                        this.commandResults.add(new NullJSONData().setError(true).setMessages("IPMI send message fail."));
                        this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                        return false;
                    }
                    boardInfo = this.ipmiReceiver.parserFRURecords(fruRecords, BoardInfo.class);
                    productInfo = this.ipmiReceiver.parserFRURecords(fruRecords, ProductInfo.class);
                }
                if (boardInfo == null) {
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Board info is empty.");
                    this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                    return false;
                }
                if (productInfo == null) {
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Product info is empty.");
                    this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                    return false;
                }
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Board Product     : " + boardInfo.getBoardProductName());
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Product Name      : " + productInfo.getProductName());
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] BMC Product ID    : " + bmcInfo.getProductID());
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] BMC FW Revision   : " + bmcInfo.getFirmwareRevision());
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] BMC platform      : " + bmcInfo.getProductName().toString());
                break;
            }
            case CPLDMB: {
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Start to execute preupdate " + ((Builder)this.commandArgs).updateType.toString() + ".");
                if (!this.uncompressFWPkgs()) {
                    this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                    ((Builder)this.commandArgs).isContinue = false;
                    this.commandResults.add(new NullJSONData().setError(true).setMessages("[" + ((Builder)this.commandArgs).bmcIP + "] Extract FW pkg fail."));
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                    return false;
                }
                if (((Builder)this.commandArgs).isLocal) {
                    if (bmcInfo.isCMC()) {
                        this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + (Object)((Object)((Builder)this.commandArgs).updateType) + " update not support CMC target.");
                        this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                        this.commandResults.add(new NullJSONData().setError(true).setMessages("CPLD MB update not support CMC target."));
                        return false;
                    }
                    boardInfo = this.ipmiReceiver.parserFRURecords(fruRecords, BoardInfo.class);
                    productInfo = this.ipmiReceiver.parserFRURecords(fruRecords, ProductInfo.class);
                } else {
                    if (bmcInfo.isCMC()) {
                        this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + (Object)((Object)((Builder)this.commandArgs).updateType) + " update not support CMC target.");
                        this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                        this.commandResults.add(new NullJSONData().setError(true).setMessages("CPLD MB update not support CMC target."));
                        return false;
                    }
                    fruRecords = this.ipmiReceiver.getFRU(handle, bmcInfo.isAST2400() || bmcInfo.isCMC() ? 0 : 1, 16, this.getCommandName(), this.commandID);
                    if (fruRecords == null) {
                        this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                        ((Builder)this.commandArgs).isContinue = false;
                        this.commandResults.add(new NullJSONData().setError(true).setMessages("IPMI send message fail."));
                        this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                        return false;
                    }
                    boardInfo = this.ipmiReceiver.parserFRURecords(fruRecords, BoardInfo.class);
                    productInfo = this.ipmiReceiver.parserFRURecords(fruRecords, ProductInfo.class);
                }
                if (boardInfo == null) {
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Board info is empty.");
                    this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                    return false;
                }
                if (productInfo == null) {
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Product info is empty.");
                    this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                    return false;
                }
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Board Product     : " + boardInfo.getBoardProductName());
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Product Name      : " + productInfo.getProductName());
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] BMC Product ID    : " + bmcInfo.getProductID());
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] BMC FW Revision   : " + bmcInfo.getFirmwareRevision());
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] BMC platform      : " + bmcInfo.getProductName().toString());
                break;
            }
            case PSU: {
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Start to execute preupdate " + ((Builder)this.commandArgs).updateType.toString() + ".");
                if (((Builder)this.commandArgs).fwPkgs.size() > 1) {
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] PSU FW file is more then one.");
                    this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                    this.commandResults.add(new NullJSONData().setError(true).setMessages("PSU FW file is more then one."));
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                    return false;
                }
                if (!((File)((Builder)this.commandArgs).fwPkgs.get(0)).getName().endsWith(".hex")) {
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] PSU FW file is invalid.");
                    this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                    this.commandResults.add(new NullJSONData().setError(true).setMessages("PSU FW file is invalid."));
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                    return false;
                }
                if (((Builder)this.commandArgs).isLocal) {
                    boardInfo = this.ipmiReceiver.parserFRURecords(fruRecords, BoardInfo.class);
                    productInfo = this.ipmiReceiver.parserFRURecords(fruRecords, ProductInfo.class);
                } else {
                    fruRecords = this.ipmiReceiver.getFRU(handle, bmcInfo.isAST2400() || bmcInfo.isCMC() ? 0 : 1, 16, this.getCommandName(), this.commandID);
                    if (fruRecords == null) {
                        this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                        ((Builder)this.commandArgs).isContinue = false;
                        this.commandResults.add(new NullJSONData().setError(true).setMessages("IPMI send message fail."));
                        this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                        return false;
                    }
                    boardInfo = this.ipmiReceiver.parserFRURecords(fruRecords, BoardInfo.class);
                    productInfo = this.ipmiReceiver.parserFRURecords(fruRecords, ProductInfo.class);
                }
                if (boardInfo == null) {
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Board info is empty.");
                    this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                    return false;
                }
                if (productInfo == null) {
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Product info is empty.");
                    this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                    return false;
                }
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Board Product     : " + boardInfo.getBoardProductName());
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Product Name      : " + productInfo.getProductName());
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] BMC Product ID    : " + bmcInfo.getProductID());
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] BMC FW Revision   : " + bmcInfo.getFirmwareRevision());
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] BMC platform      : " + bmcInfo.getProductName().toString());
                break;
            }
            case SKU: {
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Start to execute preupdate " + ((Builder)this.commandArgs).updateType.toString() + ".");
                if (((Builder)this.commandArgs).createBIN && !this.createBIN(handle)) {
                    this.removeNewSKUFolder();
                    return false;
                }
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Start to execute preupdate SKU.");
                if (((Builder)this.commandArgs).fwPkgs.size() > 1) {
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] SKU file is more then one.");
                    this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                    this.commandResults.add(new NullJSONData().setError(true).setMessages("SKU file is more then one."));
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                    if (((Builder)this.commandArgs).createBIN) {
                        this.removeNewSKUFolder();
                    }
                    return false;
                }
                if (((File)((Builder)this.commandArgs).fwPkgs.get(0)).getName().toLowerCase().endsWith(".bin")) break;
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] SKU file is invalid.");
                this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                this.commandResults.add(new NullJSONData().setError(true).setMessages("SKU file is invalid."));
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                if (((Builder)this.commandArgs).createBIN) {
                    this.removeNewSKUFolder();
                }
                return false;
            }
            default: {
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Unknown update type.");
                this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                this.commandResults.add(new NullJSONData().setError(true).setMessages("Unknown update type."));
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                return false;
            }
        }
        parser = SuitableFwParser.getFwParser(((Builder)this.commandArgs).updateType, this.loggerWriter, this.getCommandName(), this.commandID, ((Builder)this.commandArgs).bmcIP);
        if (parser instanceof BiosSuitableFwParser) {
            ((BiosSuitableFwParser)parser).setSkipCheckBiosSubject(((Builder)this.commandArgs).skipCheckBiosSubject);
            ((BiosSuitableFwParser)parser).setIgnoreChecksum(((Builder)this.commandArgs).ignoreChecksum);
        }
        if ((updatFWInfo = parser.parseSuitableFw(((Builder)this.commandArgs).fwPkgs, boardInfo, productInfo, bmcInfo)) == null) {
            this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
            ((Builder)this.commandArgs).isContinue = false;
            this.commandResults.add(new NullJSONData().setError(true).setMessages("Cannot find any suitable " + ((Builder)this.commandArgs).updateType.toString() + " FW."));
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
            return false;
        }
        updatFWInfo.setWithoutAsk(((Builder)this.commandArgs).isContinue);
        this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, updatFWInfo.toString());
        this.commandResults.add(updatFWInfo);
        this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
        this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
        return true;
    }

    @Override
    public void cancelHook(Object obj) {
    }

    @Override
    public void close() throws Exception {
        ((Builder)this.commandArgs).close();
    }

    public boolean isContinue() {
        return ((Builder)this.commandArgs).isContinue;
    }

    public boolean isBackupimg() {
        return ((Builder)this.commandArgs).backupFirmware;
    }

    private boolean isIPMISendMessagesFail(AbstractJSONPOJO resp, ConnectionHandle handle) {
        NullJSONData temp;
        if (resp instanceof NullJSONData && (temp = resp.castConcreteJSON(NullJSONData.class)).isError()) {
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + temp.getMessages());
            this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
            return true;
        }
        return false;
    }

    private boolean uncompressFWPkgs() {
        boolean ok = true;
        for (File fwpkg : ((Builder)this.commandArgs).fwPkgs) {
            ok &= UncompressFile.deCompressedFile(fwpkg);
        }
        return ok;
    }

    private boolean createBIN(ConnectionHandle handle) {
        List<FruRecord> fruRecords = this.ipmiReceiver.getFRU(handle, 0, 16, this.getCommandName(), this.commandID);
        if (fruRecords == null) {
            this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
            ((Builder)this.commandArgs).isContinue = false;
            this.commandResults.add(new NullJSONData().setError(true).setMessages("IPMI send message fail."));
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
            return false;
        }
        BoardInfo boardInfo = null;
        ProductInfo productInfo = null;
        boardInfo = this.ipmiReceiver.parserFRURecords(fruRecords, BoardInfo.class);
        productInfo = this.ipmiReceiver.parserFRURecords(fruRecords, ProductInfo.class);
        File binFile = new File(((Builder)this.commandArgs).createBINPath);
        if (!binFile.exists()) {
            binFile.mkdir();
        }
        System.out.println("this.commandArgs.skuZipPath:" + ((Builder)this.commandArgs).skuZipPath);
        System.out.println("this.commandArgs.createBINPath:" + ((Builder)this.commandArgs).createBINPath);
        File source = new File(((Builder)this.commandArgs).skuZipPath);
        File dest = new File(((Builder)this.commandArgs).createBINPath);
        try {
            FileUtils.copyFileToDirectory((File)source, (File)dest);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String newZipPath = ((Builder)this.commandArgs).createBINPath + "/" + ((File)((Builder)this.commandArgs).fwPkgs.get(0)).getName();
        if (!UncompressFile.deCompressedFile(newZipPath)) {
            this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
            ((Builder)this.commandArgs).isContinue = false;
            this.commandResults.add(new NullJSONData().setError(true).setMessages("[" + ((Builder)this.commandArgs).bmcIP + "] Extract FW pkg fail."));
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
            return false;
        }
        String newBINPath = newZipPath.replace(".zip", "");
        System.out.println("MainMAC:" + ((Builder)this.commandArgs).NodeMAC);
        System.out.println("boardInfo.getBoardSerialNumber():" + boardInfo.getBoardSerialNumber());
        System.out.println("productInfo.getProductSerialNumber():" + productInfo.getProductSerialNumber());
        String parameters = "MainMAC=" + ((Builder)this.commandArgs).NodeMAC + " BSN=" + boardInfo.getBoardSerialNumber() + " PSN=" + productInfo.getProductSerialNumber();
        if (!this.localReceiver.executeBMCProg(parameters, newZipPath.replace(".zip", ""), this.getCommandName(), this.commandID)) {
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "Create sku.bin fail.");
            this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
            ((Builder)this.commandArgs).isContinue = false;
            this.commandResults.add(new NullJSONData().setError(true).setMessages("[" + ((Builder)this.commandArgs).bmcIP + "] Create sku.bin fail."));
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
            return false;
        }
        this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "Create sku.bin complete.");
        ((Builder)this.commandArgs).fwPkgs.clear();
        ((Builder)this.commandArgs).fwPkgs.add(new File(newBINPath + "/SKU.BIN"));
        return true;
    }

    private void removeNewSKUFolder() {
    }

    public static final class Builder
    extends AbstractCommandBuilder<Builder> {
        private String bmcIP;
        private String bmcUsername = "admin";
        private String bmcPassword = "password";
        private UpdateType updateType = UpdateType.UNKNOWN;
        private List<File> fwPkgs = new ArrayList<File>();
        private boolean isContinue = false;
        private boolean isLocal = false;
        private boolean skipCheckBiosSubject = false;
        private boolean ignoreChecksum = false;
        private boolean backupFirmware = false;
        private String NodeMAC;
        private boolean createBIN = false;
        private String skuZipPath;
        private String createBINPath;

        @Override
        public boolean checkArgs() {
            if (this.bmcIP == null) {
                this.loggerWriter.appendPath(PreUpdateCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, "0.0.0.0_preupdate", "BMC IP address is null.");
                return false;
            }
            if (this.updateType == UpdateType.UNKNOWN) {
                this.loggerWriter.appendPath(PreUpdateCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.bmcIP + "_" + PreUpdateCommand.COMMAND_NAME, "[" + this.bmcIP + "] Unknown update type.");
                return false;
            }
            if (this.fwPkgs.isEmpty()) {
                this.loggerWriter.appendPath(PreUpdateCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.bmcIP + "_" + PreUpdateCommand.COMMAND_NAME + "_" + this.updateType.toString(), "[" + this.bmcIP + "] Cannot find any firmware packages.");
                return false;
            }
            return true;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        public PreUpdateCommand build() {
            if (this.args != null && this.args.length > 0) {
                this.updateType = this.args.length > 1 ? UpdateType.parse(this.args[0], this.args[1]) : UpdateType.parse(this.args[0], null);
                this.commandLineParser(this.args);
            }
            return new PreUpdateCommand(this);
        }

        @Override
        public void close() throws Exception {
            this.args = null;
            this.bmcIP = null;
            this.bmcUsername = null;
            this.bmcPassword = null;
            this.fwPkgs.clear();
            this.fwPkgs = null;
            this.loggerWriter.close();
            this.isLocal = false;
            this.loggerWriter.close();
        }

        public Builder setBMCIP(String bmcIP) {
            this.bmcIP = bmcIP;
            return this.getThis();
        }

        public Builder setBMCUsername(String username) {
            this.bmcUsername = username;
            return this.getThis();
        }

        public Builder setBMCPassword(String password) {
            this.bmcPassword = password;
            return this.getThis();
        }

        public Builder setUpdateType(UpdateType updateType) {
            this.updateType = updateType;
            return this.getThis();
        }

        public Builder setFWPackage(String firmwarePath) {
            if (firmwarePath.toLowerCase().indexOf(".zip") > 0 || firmwarePath.toLowerCase().indexOf(".vme") > 0 || firmwarePath.toLowerCase().indexOf(".jbc") > 0 || firmwarePath.toLowerCase().indexOf(".hex") > 0 || firmwarePath.toLowerCase().indexOf(".rcu") > 0 || firmwarePath.toLowerCase().indexOf(".bin") > 0) {
                File fw;
                if (!firmwarePath.contains("/") && !firmwarePath.contains("\\")) {
                    firmwarePath = "./" + firmwarePath;
                }
                if ((fw = new File(firmwarePath)).exists()) {
                    this.fwPkgs.add(fw);
                }
            }
            return this.getThis();
        }

        public Builder setFWPackage(File firmwarePath) {
            if ((firmwarePath.getName().toLowerCase().indexOf(".zip") > 0 || firmwarePath.getName().toLowerCase().indexOf(".vme") > 0 || firmwarePath.getName().toLowerCase().indexOf(".jbc") > 0 || firmwarePath.getName().toLowerCase().indexOf(".hex") > 0 || firmwarePath.getName().toLowerCase().indexOf(".rcu") > 0 || firmwarePath.getName().toLowerCase().indexOf(".bin") > 0) && firmwarePath.exists()) {
                this.fwPkgs.add(firmwarePath);
            }
            return this.getThis();
        }

        public Builder setFWPackages(List<File> firmwarePaths) {
            this.fwPkgs = firmwarePaths;
            return this.getThis();
        }

        public Builder setAuto(boolean autoMode) {
            this.isContinue = autoMode;
            return this.getThis();
        }

        public Builder setLocal(boolean isLocal) {
            this.isLocal = isLocal;
            return this.getThis();
        }

        public Builder setSkipCheckBiosSubject(boolean skipCheckBiosSubject) {
            this.skipCheckBiosSubject = skipCheckBiosSubject;
            return this.getThis();
        }

        public Builder setNodeMAC(String NodeMAC) {
            this.NodeMAC = NodeMAC;
            return this.getThis();
        }

        public Builder setCreateBIN(boolean createBIN) {
            this.createBIN = createBIN;
            return this.getThis();
        }

        public Builder setSkuZipPath(String skuZipPath) {
            this.skuZipPath = skuZipPath;
            return this.getThis();
        }

        public Builder setCreateBINPath(String createBINPath) {
            this.createBINPath = createBINPath;
            return this.getThis();
        }

        public Builder setIgnoreChecksum(boolean ignoreChecksum) {
            this.ignoreChecksum = ignoreChecksum;
            return this.getThis();
        }

        private void setBackupFirmware(boolean backupFirmware) {
            this.backupFirmware = backupFirmware;
        }

        private void commandLineParser(String[] args) {
            int startPosition = 1;
            if (args[0].equals("cpld")) {
                startPosition = 2;
            }
            block14: for (int i = startPosition; i < args.length; ++i) {
                switch (args[i]) {
                    case "auto": {
                        this.setAuto(true);
                        continue block14;
                    }
                    case "local": {
                        this.setLocal(true);
                        continue block14;
                    }
                    case "skip": {
                        this.setSkipCheckBiosSubject(true);
                        continue block14;
                    }
                    case "ignore": {
                        this.setIgnoreChecksum(true);
                        continue block14;
                    }
                    case "backupimg": {
                        this.setBackupFirmware(true);
                    }
                    default: {
                        this.setFWPackage(args[i]);
                    }
                }
            }
        }
    }
}

