/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.Update.SKU;

import Gbt.core.commands.AbstractCommand;
import Gbt.core.commands.AbstractCommandBuilder;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.receivers.GbtIPMICommandReceiver;
import Gbt.core.receivers.GbtLocalCommandReceiver;
import Gbt.utility.Common.CommonFunction;
import Gbt.utility.Common.CopyFile;
import Gbt.utility.Common.GIGABYTEChecksum;
import Gbt.utility.Common.GbtCommonConverters;
import Gbt.utility.Common.UncompressFile;
import Gbt.utility.Update.SKU.SKUXmlJSONData;
import com.veraxsystems.vxipmi.api.async.ConnectionHandle;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.FileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class SKUMasterWriteReadCommand
extends AbstractCommand<Builder> {
    public static final String COMMAND_NAME = "sku";
    private static final byte busID = 15;
    private static final byte slaveAddress = -94;
    private final GbtIPMICommandReceiver ipmiReceiver;
    private final GbtLocalCommandReceiver localReceiver;
    private SKUXmlJSONData bmcSKUXmlInfo;
    private String workingDir;

    protected SKUMasterWriteReadCommand(Builder commandArgs) {
        super(commandArgs);
        this.commandID = ((Builder)this.commandArgs).bmcIP + "_" + COMMAND_NAME;
        this.workingDir = "./" + this.commandID;
        this.bmcSKUXmlInfo = new SKUXmlJSONData();
        this.ipmiReceiver = GbtIPMICommandReceiver.getInstance();
        this.localReceiver = GbtLocalCommandReceiver.getInstance();
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String getDocumentsName() {
        return COMMAND_NAME;
    }

    @Override
    public boolean checkAll() {
        if (!((Builder)this.commandArgs).checkArgs()) {
            return false;
        }
        return this.ipmiReceiver != null;
    }

    @Override
    public boolean execute() {
        ConnectionHandle handle = this.createIPMIConnection();
        if (handle == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Cannot create IPMI connection!");
            return false;
        }
        if (!this.updateSKUprocess(handle)) {
            return false;
        }
        this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Write SKU process is complete!");
        return true;
    }

    @Override
    public void close() throws Exception {
        ((Builder)this.commandArgs).close();
    }

    @Override
    public void cancelHook(Object obj) {
    }

    private final boolean updateSKUprocess(ConnectionHandle handle) {
        if (!this.masterReadSKUBIN(handle)) {
            return false;
        }
        if (!this.parsingElements()) {
            return false;
        }
        if (!this.handleSKUXml()) {
            return false;
        }
        if (!this.combineNewSKUXml()) {
            return false;
        }
        if (!this.createNewSKUBIN()) {
            return false;
        }
        if (!this.masterWriteSKUBIN(handle)) {
            return false;
        }
        if (!this.ipmiReceiver.resetBMCCold(handle, COMMAND_NAME, this.commandID)) {
            return false;
        }
        this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "Wait 90 seconds for BMC reset...");
        try {
            Thread.sleep(100000L);
        }
        catch (InterruptedException ie) {
            return false;
        }
        handle = this.createIPMIConnection();
        if (handle == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Cannot create IPMI connection!");
            return false;
        }
        return this.checkSKUResultProcess(handle);
    }

    private ConnectionHandle createIPMIConnection() {
        int retryCount = 2;
        ConnectionHandle handle = null;
        for (int i = 0; i < retryCount && (handle = this.ipmiReceiver.createIPMIConnection(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword, COMMAND_NAME, this.commandID)) == null; ++i) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI connection fail.(" + i + ")");
        }
        return handle;
    }

    private boolean masterReadSKUBIN(ConnectionHandle handle) {
        int endAddress = 1536;
        boolean findEndAddress = false;
        ((Builder)this.commandArgs).resultData = new ArrayList();
        for (int startAddress = 0; startAddress < endAddress; startAddress += ((Builder)this.commandArgs).readCount) {
            int tempEndAddress;
            byte[] bytes = ByteBuffer.allocate(4).putInt(startAddress).array();
            byte offsetMSB = bytes[2];
            byte offsetLSB = bytes[3];
            byte[] RequestData = new byte[]{15, -94, (byte)((Builder)this.commandArgs).readCount, offsetMSB, offsetLSB};
            byte[] response = this.ipmiReceiver.masterWriteReadCommand(handle, RequestData, COMMAND_NAME, this.commandID);
            if (response == null) {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "Master read command fail.");
                return false;
            }
            if (!findEndAddress && response[0] == 71 && response[1] == 73 && response[2] == 71 && response[3] == 65 && (tempEndAddress = GbtCommonConverters.ByteArraytoInt(new byte[]{response[9], response[10]})) > startAddress) {
                endAddress = tempEndAddress;
                findEndAddress = true;
            }
            this.addByteArrayToResultList(response, endAddress);
        }
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "Master read command complete.");
        return true;
    }

    private boolean parsingElements() {
        int maxElements = 7;
        int elementSize = 32;
        for (int i = 0; i <= maxElements; ++i) {
            int start = i * elementSize;
            String fileName = CommonFunction.getStringFromByteList(((Builder)this.commandArgs).resultData, start, start + 23).trim();
            int startAddress = CommonFunction.getIntegerFromByteList(((Builder)this.commandArgs).resultData, start + 24, start + 26);
            int size = CommonFunction.getIntegerFromByteList(((Builder)this.commandArgs).resultData, start + 27, start + 29);
            int checksum = CommonFunction.getIntegerFromByteList(((Builder)this.commandArgs).resultData, start + 30, start + 31);
            System.out.println("Start:" + start + " File:" + fileName + " startAddress:" + startAddress + " size:" + size + " checksum:" + checksum);
            if (!fileName.toLowerCase().contains(".zip") && !fileName.toLowerCase().contains(".gz")) continue;
            this.writeResultDataToFile(((Builder)this.commandArgs).resultData, startAddress, size, fileName);
        }
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "Parsing element complete.");
        return true;
    }

    private boolean handleSKUXml() {
        if (!((Builder)this.commandArgs).bmcSKUXml.exists()) {
            return false;
        }
        try {
            int i;
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(((Builder)this.commandArgs).bmcSKUXml);
            doc.getDocumentElement().normalize();
            NodeList nList = doc.getElementsByTagName("PROJECT");
            for (i = 0; i < nList.getLength(); ++i) {
                Node nNode = nList.item(i);
                System.out.println("\nCurrent Element :" + nNode.getNodeName());
                if (nNode.getNodeType() != 1) continue;
                Element eElement = (Element)nNode;
                String CSN = eElement.getElementsByTagName("ChassisSerialNumber").item(0).getTextContent();
                String BSN = eElement.getElementsByTagName("BoardSerialNumber").item(0).getTextContent();
                String PSN = eElement.getElementsByTagName("ProductSerialNumber").item(0).getTextContent();
                String PN = eElement.getElementsByTagName("ProductName").item(0).getTextContent();
                System.out.println("ChassisSerialNumber:" + CSN);
                System.out.println("BoardSerialNumber:" + BSN);
                System.out.println("ProductSerialNumber:" + PSN);
                System.out.println("ProductName:" + PN);
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.TRACE, this.commandID, "ChassisSerialNumber:" + CSN);
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.TRACE, this.commandID, "BoardSerialNumber:" + BSN);
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.TRACE, this.commandID, "ProductSerialNumber:" + PSN);
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.TRACE, this.commandID, "ProductName:" + PN);
                this.bmcSKUXmlInfo.setPROCSN(CSN).setPROBSN(BSN).setPROPSN(PSN).setPROPN(PN);
                break;
            }
            for (i = 1; i < 10 && (nList = doc.getElementsByTagName("Interface" + i)) != null && nList.getLength() != 0; ++i) {
                for (int j = 0; j < nList.getLength(); ++j) {
                    Node nNode = nList.item(j);
                    System.out.println("\nCurrent Element :" + nNode.getNodeName());
                    if (nNode.getNodeType() != 1) continue;
                    Element eElement = (Element)nNode;
                    String mode = eElement.getElementsByTagName("Mode").item(0).getTextContent();
                    String mac = eElement.getElementsByTagName("MacAddr0").item(0).getTextContent();
                    if (mode != null && mode.equalsIgnoreCase("Dedicated")) {
                        this.bmcSKUXmlInfo.setDedicatedMAC(mac);
                        continue;
                    }
                    if (mode == null || !mode.equalsIgnoreCase("Shared")) continue;
                    this.bmcSKUXmlInfo.setSharedMAC(mac);
                }
            }
            System.out.println("Dedicated MAC:" + this.bmcSKUXmlInfo.getDedicatedMAC());
            System.out.println("Shared MAC:" + this.bmcSKUXmlInfo.getSharedMAC());
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.TRACE, this.commandID, "Dedicated MAC:" + this.bmcSKUXmlInfo.getDedicatedMAC());
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.TRACE, this.commandID, "Shared MAC:" + this.bmcSKUXmlInfo.getSharedMAC());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "Read mysku.xml fail.");
            return false;
        }
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "Read mysku.xml complete.");
        return true;
    }

    private boolean combineNewSKUXml() {
        if (!((Builder)this.commandArgs).userSKUXml.exists()) {
            return false;
        }
        try {
            int i;
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(((Builder)this.commandArgs).userSKUXml);
            doc.getDocumentElement().normalize();
            NodeList nList = doc.getElementsByTagName("PROJECT");
            for (i = 0; i < nList.getLength(); ++i) {
                Node nNode = nList.item(i);
                System.out.println("\n[Combine]Current Element :" + nNode.getNodeName());
                if (nNode.getNodeType() != 1) continue;
                Element eElement = (Element)nNode;
                eElement.getElementsByTagName("ChassisSerialNumber").item(0).setTextContent(this.bmcSKUXmlInfo.getPROCSN());
                eElement.getElementsByTagName("BoardSerialNumber").item(0).setTextContent(this.bmcSKUXmlInfo.getPROBSN());
                eElement.getElementsByTagName("ProductSerialNumber").item(0).setTextContent(this.bmcSKUXmlInfo.getPROPSN());
                eElement.getElementsByTagName("ProductName").item(0).setTextContent(this.bmcSKUXmlInfo.getPROPN());
                break;
            }
            for (i = 1; i < 10 && (nList = doc.getElementsByTagName("Interface" + i)) != null && nList.getLength() != 0; ++i) {
                for (int j = 0; j < nList.getLength(); ++j) {
                    Node nNode = nList.item(j);
                    System.out.println("\nCurrent Element :" + nNode.getNodeName());
                    if (nNode.getNodeType() != 1) continue;
                    Element eElement = (Element)nNode;
                    String mode = eElement.getElementsByTagName("Mode").item(0).getTextContent();
                    if (mode != null && mode.equalsIgnoreCase("Dedicated")) {
                        eElement.getElementsByTagName("MacAddr0").item(0).setTextContent(this.bmcSKUXmlInfo.getDedicatedMAC());
                        continue;
                    }
                    if (mode == null || !mode.equalsIgnoreCase("Shared")) continue;
                    eElement.getElementsByTagName("MacAddr0").item(0).setTextContent(this.bmcSKUXmlInfo.getSharedMAC());
                }
            }
            ((Builder)this.commandArgs).combineSKUXml = new File(this.workingDir + "/SKU.xml");
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.transform(new DOMSource(doc), new StreamResult(new FileOutputStream(((Builder)this.commandArgs).combineSKUXml.getAbsolutePath())));
            if (!((Builder)this.commandArgs).combineSKUXml.exists()) {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "Write combine xml fail.");
                return false;
            }
            ((Builder)this.commandArgs).bmcSKUXml.delete();
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "Write combine xml success.");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "Write combine xml fail.");
            return false;
        }
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "Merge sku.xml complete.");
        return true;
    }

    private boolean createNewSKUBIN() {
        String parameters = ((Builder)this.commandArgs).userSKUXmlInfo.getBMCProgParameter();
        if (CommonFunction.isUnix()) {
            String utilPath = "./tools/bmcprog/LNX/bmcprog";
            CopyFile.copy(utilPath, this.workingDir + "/bmcprog");
        } else if (CommonFunction.isWindows()) {
            String utilPath = "./tools/bmcprog/WIN/bmcprog.exe";
            CopyFile.copy(utilPath, this.workingDir + "/bmcprog.exe");
        }
        if (this.localReceiver.executeBMCProg(parameters, this.workingDir, COMMAND_NAME, this.commandID)) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "Create sku.bin complete.");
            return true;
        }
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "Create sku.bin fail.");
        return false;
    }

    private boolean masterWriteSKUBIN(ConnectionHandle handle) {
        byte[] skuBinArray = this.readByteArrayFromFile(this.workingDir + "/SKU.BIN");
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "Read SKU.BIN complete, length:" + skuBinArray.length);
        int endAddress = skuBinArray.length;
        for (int startAddress = 0; startAddress < endAddress; startAddress += ((Builder)this.commandArgs).writeCount) {
            byte[] bytes = ByteBuffer.allocate(4).putInt(startAddress).array();
            byte offsetMSB = bytes[2];
            byte offsetLSB = bytes[3];
            byte[] baseRequestData = new byte[]{15, -94, 0, offsetMSB, offsetLSB};
            byte[] destination = new byte[baseRequestData.length + ((Builder)this.commandArgs).writeCount];
            System.arraycopy(baseRequestData, 0, destination, 0, baseRequestData.length);
            System.arraycopy(skuBinArray, startAddress, destination, baseRequestData.length, ((Builder)this.commandArgs).writeCount);
            this.ipmiReceiver.masterWriteReadCommand(handle, destination, COMMAND_NAME, this.commandID);
        }
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException ie) {
            return false;
        }
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "Master write command complete.");
        return true;
    }

    private final boolean checkSKUResultProcess(ConnectionHandle handle) {
        int writeSKUBINChecksum = GIGABYTEChecksum.getBMCChecksum(this.workingDir + "/SKU.BIN");
        this.masterReadSKUBIN(handle);
        File readSKUBIN = this.writeResultDataToFile(((Builder)this.commandArgs).resultData, 0, ((Builder)this.commandArgs).resultData.size(), "readSKU.bin");
        int readSKUBINChecksum = GIGABYTEChecksum.getBMCChecksum(readSKUBIN.getAbsolutePath());
        if (writeSKUBINChecksum == 0) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "Find SKU.bin fail.");
            return false;
        }
        if (readSKUBINChecksum == 0) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "Find readSKU.bin fail.");
            return false;
        }
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "Compare checksum of sku.bin:" + writeSKUBINChecksum + " / " + readSKUBINChecksum);
        if (writeSKUBINChecksum != readSKUBINChecksum) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "Checksum is not equal!");
            return false;
        }
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "Checksum is equal.");
        return true;
    }

    private File writeResultDataToFile(ArrayList<Byte> resultData, int start, int size, String fileName) {
        byte[] content = new byte[size];
        String binaryFile = this.workingDir + "/" + ((Builder)this.commandArgs).bmcIP + "_" + fileName;
        try {
            for (int i = 0; i < content.length; ++i) {
                content[i] = resultData.get(start + i);
            }
            FileUtils.writeByteArrayToFile((File)new File(binaryFile), (byte[])content);
            if (fileName.toLowerCase().contains(".zip")) {
                UncompressFile.deCompressedFile(binaryFile);
                ((Builder)this.commandArgs).bmcSKUXml = new File(this.workingDir + "/mysku.xml");
            } else if (fileName.toLowerCase().contains(".gz")) {
                ((Builder)this.commandArgs).bmcSKUXml = UncompressFile.deCompressGZFile(binaryFile, this.workingDir + "/mysku.xml");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        File resultFile = new File(binaryFile);
        if (resultFile.exists()) {
            return resultFile;
        }
        return null;
    }

    private byte[] readByteArrayFromFile(String path) {
        File targetFile = new File(path);
        byte[] result = null;
        try {
            if (targetFile.exists()) {
                result = FileUtils.readFileToByteArray((File)targetFile);
            }
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }

    private void addByteArrayToResultList(byte[] array, int endAddress) {
        int maxLength = endAddress - 1;
        int nowLength = ((Builder)this.commandArgs).resultData.size();
        for (byte b : array) {
            if (nowLength > maxLength) continue;
            ((Builder)this.commandArgs).resultData.add(b);
            ++nowLength;
        }
    }

    public static final class Builder
    extends AbstractCommandBuilder<Builder> {
        private String bmcIP;
        private String bmcUsername = "admin";
        private String bmcPassword = "password";
        private File userSKUXml;
        private File bmcSKUXml;
        private File combineSKUXml;
        private int readCount = 192;
        private int writeCount = 64;
        private ArrayList<Byte> resultData = new ArrayList();
        private SKUXmlJSONData userSKUXmlInfo = new SKUXmlJSONData();

        @Override
        public boolean checkArgs() {
            if (this.args != null && this.args.length > 0) {
                this.commandLineParser(this.args);
            }
            if (this.bmcIP == null) {
                return false;
            }
            if (this.userSKUXml == null) {
                return false;
            }
            return this.userSKUXml.exists();
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        public SKUMasterWriteReadCommand build() {
            return new SKUMasterWriteReadCommand(this);
        }

        @Override
        public void close() throws Exception {
            this.args = null;
            this.bmcIP = null;
            this.bmcUsername = null;
            this.bmcPassword = null;
            this.userSKUXml = null;
            this.bmcSKUXml = null;
            this.combineSKUXml = null;
            this.resultData = null;
            this.userSKUXmlInfo = null;
            this.loggerWriter.close();
        }

        public Builder setBMCIP(String bmcIP) {
            this.bmcIP = bmcIP;
            return this.getThis();
        }

        public Builder setBMCUsername(String username) {
            this.bmcUsername = username;
            return this.getThis();
        }

        public Builder setBMCPassword(String password) {
            this.bmcPassword = password;
            return this.getThis();
        }

        private void commandLineParser(String[] args) {
            SKUXmlJSONData skuXmlInfo = new SKUXmlJSONData();
            for (String arg : args) {
                if (arg.toLowerCase().contains(".xml")) {
                    this.userSKUXml = new File("./" + arg);
                    continue;
                }
                if (arg.contains("CSN=")) {
                    skuXmlInfo.setFRUCSN(arg.substring(arg.lastIndexOf("CSN=") + 4));
                    continue;
                }
                if (arg.contains("BSN=")) {
                    skuXmlInfo.setFRUBSN(arg.substring(arg.lastIndexOf("BSN=") + 4));
                    continue;
                }
                if (arg.contains("PSN=")) {
                    skuXmlInfo.setFRUPSN(arg.substring(arg.lastIndexOf("PSN=") + 4));
                    continue;
                }
                if (arg.contains("PN=")) {
                    skuXmlInfo.setFRUPN(arg.substring(arg.lastIndexOf("PN=") + 3));
                    continue;
                }
                if (!arg.contains("ASSET=")) continue;
                skuXmlInfo.setFRUASSET(arg.substring(arg.lastIndexOf("ASSET=") + 6));
            }
            this.userSKUXmlInfo = skuXmlInfo;
        }
    }
}

