/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.Update.fwInfo;

import Gbt.utility.Common.GbtCommonConverters;
import Gbt.utility.Update.fwInfo.CommonUpdateFWInfo;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY)
public final class BIOSUpdateFWInfo
extends CommonUpdateFWInfo {
    private String folderPath;
    private List<String> productNames;
    private String boardProduct;
    private String version;
    private Date releaseDate;
    private int checksumS;
    private int checksumL;

    public void setFWFolderPath(String folderPath) {
        this.folderPath = folderPath;
    }

    @JsonProperty(value="FW folder path")
    public String getFWFolderPath() {
        return this.folderPath;
    }

    public void setSupportedBoardProduct(String boardProduct) {
        this.boardProduct = boardProduct;
    }

    @JsonProperty(value="Support Board Product")
    public String getSupportedBoardProduct() {
        return this.boardProduct;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @JsonProperty(value="Version")
    public String getVersion() {
        return this.version;
    }

    public void setReleaseDate(String sourceDate) {
        this.releaseDate = GbtCommonConverters.stringToJavaDate(sourceDate);
    }

    @JsonProperty(value="Release Date")
    public Date getReleaseDate() {
        return this.releaseDate;
    }

    public void setShortChecksum(String checksumS) {
        this.checksumS = (int)(Long.decode(checksumS) & 0xFFFFL);
    }

    @JsonProperty(value="Short Checksum")
    public int getShortChecksum() {
        return this.checksumS;
    }

    public void setLongChecksum(String checksumL) {
        this.checksumL = (int)(Long.decode(checksumL) & 0xFFFFL);
    }

    @JsonProperty(value="Long Checksum")
    public int getLongChecksum() {
        return this.checksumL;
    }

    public void setSupportedProductName(String productName) {
        String[] elements;
        this.productNames = new ArrayList<String>();
        for (String element : elements = productName.split(",")) {
            if (element.length() <= 1) continue;
            this.productNames.add(element);
        }
    }

    @JsonProperty(value="Support Product")
    public List<String> getSupportedProductName() {
        return this.productNames;
    }
}

