/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.bmcinfo;

import Gbt.core.ipmi.GbtIPMIOptions;
import Gbt.core.ipmi.GbtIpmiCommandResponseData;
import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.utility.Common.GbtCommonConverters;
import Gbt.utility.bmcinfo.AdditionalDeviceSupport;
import Gbt.utility.bmcinfo.BMCInfoJSONData;
import Gbt.utility.bmcinfo.BMCPlatform;
import Gbt.utility.bmcinfo.GetBMCInfoCommand;
import java.math.BigInteger;

public enum BmcDeviceIpmiOptions implements GbtIPMIOptions<GetBMCInfoCommand.Builder>
{
    UNKNOWN(0, "Unknown", 0),
    GETDEVICEID(1, "Get device ID", 1),
    COLDRESET(2, "Cold reset", 2),
    WARMRESET(3, "Warm reset", 3);

    private static final String UNKNOWN_ITEM = "Unknown";
    private static final String GBT_MANUFACTURER_ITEM = "GIGABYTE(TM)";
    private static final String GET_DEVICE_ID_ITEM = "Get device ID";
    private static final String COLD_RESET_ITEM = "Cold reset";
    private static final String WARM_RESET_ITEM = "Warm reset";
    private static final byte NetFn = 6;
    private final int optionCode;
    private final String item;
    private final byte cmd;

    private BmcDeviceIpmiOptions(int optionCode, String item, byte cmd) {
        this.optionCode = optionCode;
        this.item = item;
        this.cmd = cmd;
    }

    @Override
    public int getOptionCode() {
        return this.optionCode;
    }

    @Override
    public String getItem() {
        return this.item;
    }

    @Override
    public byte getNetFn() {
        return 6;
    }

    @Override
    public byte getCommandCode() {
        return this.cmd;
    }

    @Override
    public byte[] rebuildRequestData(GetBMCInfoCommand.Builder commandArgs) {
        return null;
    }

    @Override
    public AbstractJSONPOJO parserResponseData(GbtIpmiCommandResponseData gbtResponseData) {
        switch (this) {
            case GETDEVICEID: {
                int i;
                BMCInfoJSONData mcinfo = new BMCInfoJSONData();
                byte[] response = gbtResponseData.getAllResponseData();
                byte deviceID = response[0];
                mcinfo.setDeviceID(deviceID);
                int deviceVer = response[1] & 0xF;
                mcinfo.setDeviceRevision(deviceVer);
                String fwRev1 = String.valueOf(response[2] & 0xFF);
                String fwRev2 = GbtCommonConverters.bytesToHex(new byte[]{(byte)(response[3] & 0xFF & 0xFF)});
                String fwRev = fwRev1 + "." + fwRev2;
                if (response.length > 14) {
                    byte[] auxInfo = new byte[]{response[11], response[12], response[13], response[14]};
                    BigInteger auxFwRev = GbtCommonConverters.bytesToDecReverse(auxInfo);
                    fwRev = fwRev + "." + String.format("%02d", auxFwRev);
                }
                mcinfo.setFirmwareRevision(fwRev);
                int IPMIMajorVer = response[4] & 0xF;
                int IPMIMinorVer = (response[4] & 0xFFFFFFF0) >> 4;
                String ipmiRev = IPMIMajorVer + "." + IPMIMinorVer;
                mcinfo.setIpmiVersion(ipmiRev);
                int mfgID = ((response[8] & 0xFF) << 16) + ((response[7] & 0xFF) << 8) + (response[6] & 0xFF);
                mcinfo.setManufacturerID(mfgID);
                byte[] manuName = new byte[]{response[7], response[6]};
                if (manuName[0] == 60 && manuName[1] == 10) {
                    mcinfo.setManufacturerName(GBT_MANUFACTURER_ITEM);
                } else {
                    mcinfo.setManufacturerName("Unknown (0x" + GbtCommonConverters.bytesToHex(manuName) + ")");
                }
                byte[] productID = new byte[]{response[10], response[9]};
                mcinfo.setProductID(GbtCommonConverters.bytesToHex(productID));
                mcinfo.setProductName(BMCPlatform.parserPlatformByID(productID));
                mcinfo.setDeviceAvailable((response[4] & 0x80) >> 7 == 0);
                mcinfo.setProvidesDeviceSDRs((response[1] & 0x80) >> 7 == 1);
                for (i = 0; i < 8; ++i) {
                    byte checkVar = (byte)(response[5] & 0xFFFFFFFF & 1 << i);
                    mcinfo.setAdditionalDeviceSupport(AdditionalDeviceSupport.parserByCode(checkVar));
                }
                for (i = 0; i < 4; ++i) {
                    mcinfo.setAuxFWRevInfo(GbtCommonConverters.bytesToHex(response[i + 11]));
                }
                return mcinfo;
            }
            case COLDRESET: {
                return new NullJSONData().setMessages(this.getItem() + " success, please wait BMC reset complete.").setError(false);
            }
            case WARMRESET: {
                return new NullJSONData().setMessages(this.getItem() + " success, please wait BMC reset complete.").setError(false);
            }
        }
        return new NullJSONData().setMessages("No corresponding data instance.").setError(true);
    }

    public static final BmcDeviceIpmiOptions parse(String option) {
        if (option == null) {
            return UNKNOWN;
        }
        switch (option.toLowerCase()) {
            case "mcinfo": {
                return GETDEVICEID;
            }
            case "cold": {
                return COLDRESET;
            }
            case "warm": {
                return WARMRESET;
            }
        }
        return UNKNOWN;
    }
}

