/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.firmwareBackup;

import Gbt.core.ipmi.GbtIPMIOptions;
import Gbt.core.ipmi.GbtIpmiCommandResponseData;
import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.utility.Update.MainUpdateCommand;
import Gbt.utility.firmwareBackup.FirmwareBackupStatus;
import java.math.BigInteger;

public enum FirmwareBackupStatusIpmiOptions implements GbtIPMIOptions<MainUpdateCommand.Builder>
{
    GET_STATUS(0, "Get firmware backup status");

    private static final String GET_STATUS_ITEM = "Get firmware backup status";
    private static final byte NetFn = 50;
    private final int optionCode;
    private final String item;
    private static final byte cmd = -120;

    private FirmwareBackupStatusIpmiOptions(int optionCode, String item) {
        this.optionCode = optionCode;
        this.item = item;
    }

    @Override
    public int getOptionCode() {
        return this.optionCode;
    }

    @Override
    public String getItem() {
        return this.item;
    }

    @Override
    public byte getNetFn() {
        return 50;
    }

    @Override
    public byte getCommandCode() {
        return -120;
    }

    @Override
    public byte[] rebuildRequestData(MainUpdateCommand.Builder commandArgs) {
        return new byte[0];
    }

    @Override
    public AbstractJSONPOJO parserResponseData(GbtIpmiCommandResponseData gbtResponseData) {
        byte statusByte = gbtResponseData.getAllResponseData()[0];
        byte progressByte = gbtResponseData.getAllResponseData()[1];
        FirmwareBackupStatus status = new FirmwareBackupStatus();
        switch (statusByte) {
            case 0: {
                status.setStatus("No action");
                status.setProgress(BigInteger.valueOf(0L));
                break;
            }
            case 1: {
                status.setStatus("Parameter checking");
                status.setProgress(BigInteger.valueOf(progressByte & 0xFF));
                break;
            }
            case 2: {
                status.setStatus("Parameter check ok");
                status.setProgress(BigInteger.valueOf(0L));
                break;
            }
            case 3: {
                status.setStatus("Parameter check fail");
                status.setProgress(BigInteger.valueOf(0L));
                status.setResult(false);
                break;
            }
            case 4: {
                status.setStatus("Image downloading");
                status.setProgress(BigInteger.valueOf(progressByte & 0xFF));
                break;
            }
            case 5: {
                status.setStatus("Image download ok");
                status.setProgress(BigInteger.valueOf(0L));
                break;
            }
            case 6: {
                status.setStatus("Image download fail");
                status.setProgress(BigInteger.valueOf(0L));
                status.setResult(false);
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                status.setStatus("Flash in progress");
                status.setProgress(BigInteger.valueOf(progressByte & 0xFF));
                break;
            }
            case 9: {
                status.setStatus("Flash ready and OK");
                status.setProgress(BigInteger.valueOf(0L));
                status.setResult(true);
                break;
            }
            case 10: {
                status.setStatus("Flash fail");
                status.setProgress(BigInteger.valueOf(0L));
                status.setResult(false);
            }
        }
        return status;
    }
}

