/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.maclist;

import Gbt.core.ipmi.GbtIPMIOptions;
import Gbt.core.ipmi.GbtIpmiCommandResponseData;
import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.utility.Common.CommonFunction;
import Gbt.utility.maclist.GetMACListCommand;
import Gbt.utility.maclist.LANMacData;

public enum GetLANMacIPMIOption implements GbtIPMIOptions<GetMACListCommand.Builder>
{
    AST2400Series(0, "Get AST2400 LAN Mac", 56, 48),
    AST2500Series(1, "Get AST2500 LAN Mac", 46, 52);

    private static final int AST2400_CODE = 0;
    private static final int AST2500_CODE = 1;
    private static final String AST2400_ITEM = "Get AST2400 LAN Mac";
    private static final String AST2500_ITEM = "Get AST2500 LAN Mac";
    private final int optionCode;
    private final String item;
    private final byte netFn;
    private final byte cmd;

    private GetLANMacIPMIOption(int optionCode, String item, byte netFn, byte cmd) {
        this.optionCode = optionCode;
        this.item = item;
        this.netFn = netFn;
        this.cmd = cmd;
    }

    @Override
    public int getOptionCode() {
        return this.optionCode;
    }

    @Override
    public String getItem() {
        return this.item;
    }

    @Override
    public byte getNetFn() {
        return this.netFn;
    }

    @Override
    public byte getCommandCode() {
        return this.cmd;
    }

    @Override
    public byte[] rebuildRequestData(GetMACListCommand.Builder commandArgs) {
        switch (this.optionCode) {
            case 0: {
                return new byte[]{2};
            }
            case 1: {
                if (commandArgs != null) {
                    return new byte[]{10, 60, 0, (byte)commandArgs.groupID};
                }
                return new byte[]{10, 60, 0, 0};
            }
        }
        return null;
    }

    @Override
    public AbstractJSONPOJO parserResponseData(GbtIpmiCommandResponseData gbtResponseData) {
        byte[] macByte = new byte[6];
        LANMacData lanMacData = new LANMacData();
        switch (this.optionCode) {
            case 0: {
                for (int i = 0; i < 5; ++i) {
                    for (int j = 0; j < macByte.length; ++j) {
                        macByte[j] = gbtResponseData.getResponseData(j + (i * 6 + 4));
                    }
                    if (i <= 0) continue;
                    lanMacData.setLANMacByID(CommonFunction.byteMACtoString(macByte), i);
                }
                return lanMacData;
            }
            case 1: {
                for (int i = 0; i < 4; ++i) {
                    for (int j = 0; j < macByte.length; ++j) {
                        macByte[j] = gbtResponseData.getResponseData(j + (i * 6 + 3));
                    }
                    lanMacData.setLANMacByID(CommonFunction.byteMACtoString(macByte), i + 1);
                }
                return lanMacData;
            }
        }
        return new NullJSONData().setError(true).setMessages("Unknown BMC series for get LAN MAC command.");
    }
}

