/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.redfish.services;

import Gbt.core.jsonapi.JacksonCommonUtil;
import Gbt.core.loggers.AbstractLoggerWriter;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.redfish.RedfishApiPayload;
import Gbt.core.redfish.RedfishApiService;
import Gbt.core.redfish.RedfishResourceTypes;
import Gbt.core.rest.RESTException;
import Gbt.core.rest.RESTHttpMethods;
import Gbt.core.rest.RESTRequest;
import Gbt.core.rest.RESTRequestImpl;
import Gbt.utility.Common.GbtCommonConverters;
import Gbt.utility.redfish.RestFullResponseData;
import Gbt.utility.redfish.factories.RedfishApiMenu;
import Gbt.utility.redfish.models.common.identifier.IndicatorLED;
import Gbt.utility.redfish.models.common.systems.SystemsResource;
import Gbt.utility.redfish.models.common.systems.SystemsResourceBoot;
import Gbt.utility.redfish.models.common.systems.SystemsResourceResetAction;
import Gbt.utility.redfish.options.SystemsApiOptions;
import com.fasterxml.jackson.databind.JsonNode;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.Response;

public final class SystemsApi
extends RedfishApiService<Payload> {
    protected SystemsApi(Payload servicePayload) {
        super(servicePayload);
    }

    @Override
    public String getServiceName() {
        return RedfishApiMenu.SYSTEMS.getApiName();
    }

    @Override
    protected boolean checkRawArgs() {
        String subOption = "";
        if (((Payload)this.servicePayload).getRestRawArgs().length == 0) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((Payload)this.servicePayload).getIpAddress() + "] The input arguments not enough.");
            return false;
        }
        ((Payload)this.servicePayload).setServiceOption(SystemsApiOptions.parse(((Payload)this.servicePayload).getRestRawArgs()[0]));
        switch ((SystemsApiOptions)((Payload)this.servicePayload).getServiceOption()) {
            case INFO: {
                if (((Payload)this.servicePayload).getRestRawArgs().length == 2) {
                    ((Payload)this.servicePayload).setSystemId(((Payload)this.servicePayload).getRestRawArgs()[1]);
                }
                return true;
            }
            case BOOT: {
                switch (((Payload)this.servicePayload).getRestRawArgs().length) {
                    case 2: {
                        subOption = ((Payload)this.servicePayload).getRestRawArgs()[1];
                        if (subOption.equalsIgnoreCase(BootSubService.LIST.name())) {
                            ((Payload)this.servicePayload).setBootSubService(BootSubService.LIST);
                            return true;
                        }
                        ((Payload)this.servicePayload).setUploadJsonFile(GbtCommonConverters.stringToJavaIoFile(((Payload)this.servicePayload).getRestRawArgs()[1]));
                        return this.uploadFileValidation(RedfishResourceTypes.ComputerSystem);
                    }
                    case 3: {
                        subOption = ((Payload)this.servicePayload).getRestRawArgs()[1];
                        if (subOption.equalsIgnoreCase(BootSubService.GET.name())) {
                            ((Payload)this.servicePayload).setBootOption(((Payload)this.servicePayload).getRestRawArgs()[2]);
                            ((Payload)this.servicePayload).setBootSubService(BootSubService.GET);
                            return true;
                        }
                        ((Payload)this.servicePayload).setSystemId(subOption);
                        if (((Payload)this.servicePayload).getRestRawArgs()[2].equalsIgnoreCase(BootSubService.LIST.name())) {
                            ((Payload)this.servicePayload).setBootSubService(BootSubService.LIST);
                            return true;
                        }
                        ((Payload)this.servicePayload).setUploadJsonFile(GbtCommonConverters.stringToJavaIoFile(((Payload)this.servicePayload).getRestRawArgs()[2]));
                        return this.uploadFileValidation(RedfishResourceTypes.ComputerSystem);
                    }
                    case 4: {
                        subOption = ((Payload)this.servicePayload).getRestRawArgs()[2];
                        if (subOption.equalsIgnoreCase(BootSubService.GET.name())) {
                            ((Payload)this.servicePayload).setSystemId(((Payload)this.servicePayload).getRestRawArgs()[1]);
                            ((Payload)this.servicePayload).setBootOption(((Payload)this.servicePayload).getRestRawArgs()[3]);
                            ((Payload)this.servicePayload).setBootSubService(BootSubService.GET);
                            return true;
                        }
                        return false;
                    }
                }
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((SystemsApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
                return false;
            }
            case RESET: {
                switch (((Payload)this.servicePayload).getRestRawArgs().length) {
                    case 2: {
                        ((Payload)this.servicePayload).setUploadJsonFile(GbtCommonConverters.stringToJavaIoFile(((Payload)this.servicePayload).getRestRawArgs()[1]));
                        return this.uploadFileValidation(RedfishResourceTypes.Ignore);
                    }
                    case 3: {
                        ((Payload)this.servicePayload).setSystemId(((Payload)this.servicePayload).getRestRawArgs()[1]);
                        ((Payload)this.servicePayload).setUploadJsonFile(GbtCommonConverters.stringToJavaIoFile(((Payload)this.servicePayload).getRestRawArgs()[2]));
                        return this.uploadFileValidation(RedfishResourceTypes.Ignore);
                    }
                }
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((SystemsApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
                return false;
            }
            case IDENTIFY: {
                switch (((Payload)this.servicePayload).getRestRawArgs().length) {
                    case 2: {
                        ((Payload)this.servicePayload).setUploadJsonFile(GbtCommonConverters.stringToJavaIoFile(((Payload)this.servicePayload).getRestRawArgs()[1]));
                        return this.uploadFileValidation(RedfishResourceTypes.ComputerSystem);
                    }
                    case 3: {
                        ((Payload)this.servicePayload).setSystemId(((Payload)this.servicePayload).getRestRawArgs()[1]);
                        ((Payload)this.servicePayload).setUploadJsonFile(GbtCommonConverters.stringToJavaIoFile(((Payload)this.servicePayload).getRestRawArgs()[2]));
                        return this.uploadFileValidation(RedfishResourceTypes.ComputerSystem);
                    }
                }
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((SystemsApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
                return false;
            }
        }
        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((SystemsApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
        return false;
    }

    @Override
    protected boolean checkPayLoad() {
        switch ((SystemsApiOptions)((Payload)this.servicePayload).getServiceOption()) {
            case INFO: {
                return true;
            }
            case BOOT: {
                if (((Payload)this.servicePayload).getUploadJsonFile() != null) {
                    return this.uploadFileValidation(RedfishResourceTypes.ComputerSystem);
                }
                if (((Payload)this.servicePayload).getSystemsResourceBoot() != null) {
                    SystemsResource systemsResource = new SystemsResource();
                    systemsResource.setBoot(((Payload)this.servicePayload).getSystemsResourceBoot());
                    return this.uploadDataValidation(RedfishResourceTypes.ComputerSystem, systemsResource);
                }
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((SystemsApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
                return false;
            }
            case RESET: {
                if (((Payload)this.servicePayload).getUploadJsonFile() != null) {
                    return this.uploadFileValidation(RedfishResourceTypes.Ignore);
                }
                if (((Payload)this.servicePayload).getResetAction() != null) {
                    return this.uploadDataValidation(RedfishResourceTypes.Ignore, ((Payload)this.servicePayload).getResetAction());
                }
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((SystemsApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
                return false;
            }
            case IDENTIFY: {
                if (((Payload)this.servicePayload).getUploadJsonFile() != null) {
                    return this.uploadFileValidation(RedfishResourceTypes.ComputerSystem);
                }
                if (((Payload)this.servicePayload).getIndicatorLED() != IndicatorLED.Unknown) {
                    SystemsResource systemsResource = new SystemsResource();
                    systemsResource.setIndicatorLED(((Payload)this.servicePayload).getIndicatorLED());
                    return this.uploadDataValidation(RedfishResourceTypes.ComputerSystem, systemsResource);
                }
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((SystemsApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
                return false;
            }
        }
        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((SystemsApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        Client client = null;
        try {
            client = this.restReceiver.createHttpsClient(((Payload)this.servicePayload).getUsername(), ((Payload)this.servicePayload).getPassword(), ((Payload)this.servicePayload).isDebug());
        }
        catch (RESTException re) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((Payload)this.servicePayload).getIpAddress() + "] Create HTTPS client fail.");
            return false;
        }
        if (((Payload)this.servicePayload).getSystemId() == null) {
            ((Payload)this.servicePayload).setSystemId("Self");
        }
        switch ((SystemsApiOptions)((Payload)this.servicePayload).getServiceOption()) {
            case INFO: {
                try {
                    RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHostname(((Payload)this.servicePayload).getIpAddress())).setProtocolHeader(((Payload)this.servicePayload).getProtocolHeader())).setPort(((Payload)this.servicePayload).getPort())).setHttpMethods(RESTHttpMethods.GET)).setContentType("application/json")).setServiceURI(((SystemsApiOptions)((Payload)this.servicePayload).getServiceOption()).getMainUri()).setServiceId(((Payload)this.servicePayload).getSystemId()).build();
                    Response response = this.restReceiver.syncInvoke(client, request, this.logDirPath, this.serviceLogsId);
                    RestFullResponseData desResp = this.restReceiver.deserializeAsCommonData(response);
                    this.responseData.add(desResp);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(desResp.isRedfishErrorResponse() ? GbtLogLevel.ERROR : GbtLogLevel.INFO, this.serviceLogsId, desResp.toString());
                    boolean bl = !desResp.isRedfishErrorResponse();
                    return bl;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getMessage());
                    if (re.getUnexpectedBody() != null) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getUnexpectedBody());
                    }
                    boolean response = false;
                    return response;
                }
                finally {
                    client.close();
                }
            }
            case BOOT: {
                try {
                    String bootOptionListUri;
                    if (((Payload)this.servicePayload).getBootSubService() == BootSubService.GET) {
                        bootOptionListUri = this.getBootOptionListUri(client);
                        if (bootOptionListUri == null) {
                            boolean response = false;
                            return response;
                        }
                        String bootOptionUri = this.getBootOptionMemberUri(client, bootOptionListUri);
                        if (bootOptionUri == null) {
                            boolean desResp = false;
                            return desResp;
                        }
                        RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHostname(((Payload)this.servicePayload).getIpAddress())).setProtocolHeader(((Payload)this.servicePayload).getProtocolHeader())).setPort(((Payload)this.servicePayload).getPort())).setHttpMethods(RESTHttpMethods.GET)).setServiceURI(bootOptionUri).setContentType("application/json")).build();
                        Response response = this.restReceiver.syncInvoke(client, request, this.logDirPath, this.serviceLogsId);
                        RestFullResponseData desResp = this.restReceiver.deserializeAsCommonData(response);
                        this.responseData.add(desResp);
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(desResp.isRedfishErrorResponse() ? GbtLogLevel.ERROR : GbtLogLevel.INFO, this.serviceLogsId, desResp.toString());
                        boolean bl = !desResp.isRedfishErrorResponse();
                        return bl;
                    }
                    if (((Payload)this.servicePayload).getBootSubService() == BootSubService.LIST) {
                        bootOptionListUri = this.getBootOptionListUri(client);
                        if (bootOptionListUri == null) {
                            boolean bootOptionUri = false;
                            return bootOptionUri;
                        }
                        RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHostname(((Payload)this.servicePayload).getIpAddress())).setProtocolHeader(((Payload)this.servicePayload).getProtocolHeader())).setPort(((Payload)this.servicePayload).getPort())).setHttpMethods(RESTHttpMethods.GET)).setServiceURI(bootOptionListUri).setContentType("application/json")).build();
                        Response response = this.restReceiver.syncInvoke(client, request, this.logDirPath, this.serviceLogsId);
                        RestFullResponseData desResp = this.restReceiver.deserializeAsCommonData(response);
                        if (desResp.isRedfishErrorResponse()) {
                            this.responseData.add(desResp);
                            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, desResp.toString());
                            boolean bl = false;
                            return bl;
                        }
                        this.responseData.add(desResp);
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, this.serviceLogsId, JacksonCommonUtil.getUtil().getPrettyPrintString(desResp.getMembersOdataId()));
                        boolean bl = true;
                        return bl;
                    }
                    String etag = this.getETag(((Payload)this.servicePayload).getProtocolHeader(), client, ((SystemsApiOptions)((Payload)this.servicePayload).getServiceOption()).getMainUri() + "/" + ((Payload)this.servicePayload).getSystemId());
                    RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHostname(((Payload)this.servicePayload).getIpAddress())).setProtocolHeader(((Payload)this.servicePayload).getProtocolHeader())).setPort(((Payload)this.servicePayload).getPort())).setHttpMethods(RESTHttpMethods.PATCH)).setContentType("application/json")).setRawJsonData(this.requestBody)).setServiceURI(((SystemsApiOptions)((Payload)this.servicePayload).getServiceOption()).getMainUri()).setHeaders("If-Match", etag)).setServiceId(((Payload)this.servicePayload).getSystemId()).build();
                    Response response = this.restReceiver.syncInvoke(client, request, this.logDirPath, this.serviceLogsId);
                    RestFullResponseData desResp = this.restReceiver.deserializeAsCommonData(response);
                    this.responseData.add(desResp);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(desResp.isRedfishErrorResponse() ? GbtLogLevel.ERROR : GbtLogLevel.INFO, this.serviceLogsId, desResp.toString());
                    boolean bl = !desResp.isRedfishErrorResponse();
                    return bl;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getMessage());
                    if (re.getUnexpectedBody() != null) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getUnexpectedBody());
                    }
                    boolean request = false;
                    return request;
                }
                finally {
                    client.close();
                }
            }
            case IDENTIFY: {
                try {
                    String etag = this.getETag(((Payload)this.servicePayload).getProtocolHeader(), client, ((SystemsApiOptions)((Payload)this.servicePayload).getServiceOption()).getMainUri() + "/" + ((Payload)this.servicePayload).getSystemId());
                    RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHostname(((Payload)this.servicePayload).getIpAddress())).setProtocolHeader(((Payload)this.servicePayload).getProtocolHeader())).setPort(((Payload)this.servicePayload).getPort())).setHttpMethods(RESTHttpMethods.PATCH)).setContentType("application/json")).setRawJsonData(this.requestBody)).setServiceURI(((SystemsApiOptions)((Payload)this.servicePayload).getServiceOption()).getMainUri()).setHeaders("If-Match", etag)).setServiceId(((Payload)this.servicePayload).getSystemId()).build();
                    Response response = this.restReceiver.syncInvoke(client, request, this.logDirPath, this.serviceLogsId);
                    RestFullResponseData desResp = this.restReceiver.deserializeAsCommonData(response);
                    this.responseData.add(desResp);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(desResp.isRedfishErrorResponse() ? GbtLogLevel.ERROR : GbtLogLevel.INFO, this.serviceLogsId, desResp.toString());
                    boolean bl = !desResp.isRedfishErrorResponse();
                    return bl;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getMessage());
                    if (re.getUnexpectedBody() != null) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getUnexpectedBody());
                    }
                    boolean request = false;
                    return request;
                }
                finally {
                    client.close();
                }
            }
            case RESET: {
                try {
                    RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHostname(((Payload)this.servicePayload).getIpAddress())).setProtocolHeader(((Payload)this.servicePayload).getProtocolHeader())).setPort(((Payload)this.servicePayload).getPort())).setHttpMethods(RESTHttpMethods.POST)).setContentType("application/json")).setRawJsonData(this.requestBody)).setServiceURI(((SystemsApiOptions)((Payload)this.servicePayload).getServiceOption()).getMainUri().replace("<id>", ((Payload)this.servicePayload).getSystemId())).build();
                    Response response = this.restReceiver.syncInvoke(client, request, this.logDirPath, this.serviceLogsId);
                    RestFullResponseData desResp = this.restReceiver.deserializeAsCommonData(response);
                    this.responseData.add(desResp);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(desResp.isRedfishErrorResponse() ? GbtLogLevel.ERROR : GbtLogLevel.INFO, this.serviceLogsId, desResp.toString());
                    boolean bl = !desResp.isRedfishErrorResponse();
                    return bl;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getMessage());
                    if (re.getUnexpectedBody() != null) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getUnexpectedBody());
                    }
                    boolean bl = false;
                    return bl;
                }
                finally {
                    client.close();
                }
            }
        }
        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((SystemsApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
        client.close();
        return false;
    }

    private String getBootOptionListUri(Client client) {
        try {
            RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHostname(((Payload)this.servicePayload).getIpAddress())).setProtocolHeader(((Payload)this.servicePayload).getProtocolHeader())).setPort(((Payload)this.servicePayload).getPort())).setHttpMethods(RESTHttpMethods.GET)).setServiceURI(((SystemsApiOptions)((Payload)this.servicePayload).getServiceOption()).getMainUri()).setServiceId(((Payload)this.servicePayload).getSystemId()).setContentType("application/json")).build();
            Response response = this.restReceiver.syncInvoke(client, request, this.logDirPath, this.serviceLogsId);
            RestFullResponseData desResp = this.restReceiver.deserializeAsCommonData(response);
            if (!desResp.isRedfishErrorResponse()) {
                JsonNode uri = desResp.getResponseBody().path("Boot").path("BootOptions").path("@odata.id");
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, this.serviceLogsId, "Find boot options uri:" + uri.asText());
                return uri.asText();
            }
            this.responseData.add(desResp);
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, desResp.toString());
            return null;
        }
        catch (RESTException re) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getMessage());
            if (re.getUnexpectedBody() != null) {
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getUnexpectedBody());
            }
            return null;
        }
    }

    private String getBootOptionMemberUri(Client client, String bootOptionListUri) {
        try {
            RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHostname(((Payload)this.servicePayload).getIpAddress())).setProtocolHeader(((Payload)this.servicePayload).getProtocolHeader())).setPort(((Payload)this.servicePayload).getPort())).setHttpMethods(RESTHttpMethods.GET)).setServiceURI(bootOptionListUri).setContentType("application/json")).build();
            Response response = this.restReceiver.syncInvoke(client, request, this.logDirPath, this.serviceLogsId);
            RestFullResponseData desResp = this.restReceiver.deserializeAsCommonData(response);
            if (!desResp.isRedfishErrorResponse()) {
                JsonNode bootOptions = desResp.getResponseBody().path("Members");
                if (bootOptions.isArray()) {
                    for (JsonNode node : bootOptions) {
                        String bootOptionUri = node.path("@odata.id").asText();
                        String bootOptionId = bootOptionUri.substring(bootOptionUri.lastIndexOf(47) + 1);
                        if (!((Payload)this.servicePayload).getBootOption().equals(bootOptionId)) continue;
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, this.serviceLogsId, "Find boot option uri:" + bootOptionUri);
                        return bootOptionUri;
                    }
                }
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "Cannot find any matched url!");
                return null;
            }
            this.responseData.add(desResp);
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, desResp.toString());
            return null;
        }
        catch (RESTException re) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getMessage());
            if (re.getUnexpectedBody() != null) {
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getUnexpectedBody());
            }
            return null;
        }
    }

    public static final class Payload
    extends RedfishApiPayload<Payload, SystemsApiOptions> {
        private String systemId;
        private SystemsResourceBoot systemsResourceBoot;
        private SystemsResourceResetAction resetAction;
        private IndicatorLED indicatorLED;
        private BootSubService bootSubService;
        private String bootOption;

        public Payload(String ipAddress, AbstractLoggerWriter loggerWriter) {
            super(ipAddress, loggerWriter);
            this.setServiceOption(SystemsApiOptions.UNKNOWN);
            this.indicatorLED = IndicatorLED.Unknown;
            this.bootSubService = BootSubService.UNKNOWN;
        }

        public Payload(String ipAddress, String username, String password, AbstractLoggerWriter loggerWriter) {
            super(ipAddress, username, password, loggerWriter);
            this.setServiceOption(SystemsApiOptions.UNKNOWN);
            this.indicatorLED = IndicatorLED.Unknown;
            this.bootSubService = BootSubService.UNKNOWN;
        }

        @Override
        protected Payload getThis() {
            return this;
        }

        public SystemsApi build() {
            return new SystemsApi(this);
        }

        public String getSystemId() {
            return this.systemId;
        }

        public Payload setSystemId(String systemId) {
            this.systemId = systemId;
            return this.getThis();
        }

        public SystemsResourceBoot getSystemsResourceBoot() {
            return this.systemsResourceBoot;
        }

        public Payload setSystemsResourceBoot(SystemsResourceBoot systemsResourceBoot) {
            this.systemsResourceBoot = systemsResourceBoot;
            return this.getThis();
        }

        public SystemsResourceResetAction getResetAction() {
            return this.resetAction;
        }

        public Payload setResetAction(SystemsResourceResetAction resetAction) {
            this.resetAction = resetAction;
            return this.getThis();
        }

        public IndicatorLED getIndicatorLED() {
            return this.indicatorLED;
        }

        public Payload setIndicatorLED(IndicatorLED indicatorLED) {
            this.indicatorLED = indicatorLED;
            return this.getThis();
        }

        public BootSubService getBootSubService() {
            return this.bootSubService;
        }

        public Payload setBootSubService(BootSubService bootSubService) {
            this.bootSubService = bootSubService;
            return this.getThis();
        }

        public String getBootOption() {
            return this.bootOption;
        }

        public Payload setBootOption(String bootOption) {
            this.bootOption = bootOption;
            return this.getThis();
        }
    }

    public static enum BootSubService {
        LIST,
        GET,
        UNKNOWN;

    }
}

