/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.redfish.services;

import Gbt.core.jsonapi.JacksonCommonUtil;
import Gbt.core.loggers.AbstractLoggerWriter;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.redfish.RedfishApiPayload;
import Gbt.core.redfish.RedfishApiService;
import Gbt.core.rest.RESTException;
import Gbt.core.rest.RESTHttpMethods;
import Gbt.core.rest.RESTRequest;
import Gbt.core.rest.RESTRequestImpl;
import Gbt.utility.redfish.RestFullResponseData;
import Gbt.utility.redfish.factories.RedfishApiMenu;
import Gbt.utility.redfish.options.ThermalApiOptions;
import com.fasterxml.jackson.databind.JsonNode;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.Response;

public final class ThermalApi
extends RedfishApiService<Payload> {
    protected ThermalApi(Payload servicePayload) {
        super(servicePayload);
    }

    @Override
    public String getServiceName() {
        return RedfishApiMenu.THERMAL.getApiName();
    }

    @Override
    protected boolean checkRawArgs() {
        if (((Payload)this.servicePayload).getRestRawArgs().length == 0) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((Payload)this.servicePayload).getIpAddress() + "] The input arguments not enough.");
            return false;
        }
        ((Payload)this.servicePayload).setServiceOption(ThermalApiOptions.parse(((Payload)this.servicePayload).getRestRawArgs()[0]));
        switch ((ThermalApiOptions)((Payload)this.servicePayload).getServiceOption()) {
            case FAN: {
                if (((Payload)this.servicePayload).getRestRawArgs().length == 2) {
                    ((Payload)this.servicePayload).setSystemId(((Payload)this.servicePayload).getRestRawArgs()[1]);
                }
                return true;
            }
            case TEMP: {
                if (((Payload)this.servicePayload).getRestRawArgs().length == 2) {
                    ((Payload)this.servicePayload).setSystemId(((Payload)this.servicePayload).getRestRawArgs()[1]);
                }
                return true;
            }
        }
        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((ThermalApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
        return false;
    }

    @Override
    protected boolean checkPayLoad() {
        switch ((ThermalApiOptions)((Payload)this.servicePayload).getServiceOption()) {
            case FAN: {
                return true;
            }
            case TEMP: {
                return true;
            }
        }
        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((ThermalApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        Client client = null;
        try {
            client = this.restReceiver.createHttpsClient(((Payload)this.servicePayload).getUsername(), ((Payload)this.servicePayload).getPassword(), ((Payload)this.servicePayload).isDebug());
        }
        catch (RESTException re) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((Payload)this.servicePayload).getIpAddress() + "] Create HTTPS client fail.");
            return false;
        }
        if (((Payload)this.servicePayload).getSystemId() == null) {
            ((Payload)this.servicePayload).setSystemId("Self");
        }
        switch ((ThermalApiOptions)((Payload)this.servicePayload).getServiceOption()) {
            case FAN: {
                try {
                    RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHostname(((Payload)this.servicePayload).getIpAddress())).setProtocolHeader(((Payload)this.servicePayload).getProtocolHeader())).setPort(((Payload)this.servicePayload).getPort())).setHttpMethods(RESTHttpMethods.GET)).setContentType("application/json")).setServiceURI(((ThermalApiOptions)((Payload)this.servicePayload).getServiceOption()).replaceSystemId(((Payload)this.servicePayload).getSystemId())).build();
                    Response response = this.restReceiver.syncInvoke(client, request, this.logDirPath, this.serviceLogsId);
                    RestFullResponseData desResp = this.restReceiver.deserializeAsCommonData(response);
                    if (desResp.isRedfishErrorResponse()) {
                        this.responseData.add(desResp);
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, desResp.toString());
                        boolean bl = false;
                        return bl;
                    }
                    JsonNode fans = desResp.getResponseBody().get("Fans");
                    if (fans == null) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, this.serviceLogsId, "[" + ((Payload)this.servicePayload).getIpAddress() + "] No fans node in thermal.");
                        boolean bl = false;
                        return bl;
                    }
                    if (!fans.isArray()) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, this.serviceLogsId, "[" + ((Payload)this.servicePayload).getIpAddress() + "] No fan sensors.");
                        boolean bl = true;
                        return bl;
                    }
                    this.responseData.add(desResp);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, this.serviceLogsId, JacksonCommonUtil.getUtil().getPrettyPrintString(fans));
                    boolean bl = true;
                    return bl;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getMessage());
                    if (re.getUnexpectedBody() != null) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getUnexpectedBody());
                    }
                    boolean response = false;
                    return response;
                }
                finally {
                    client.close();
                }
            }
            case TEMP: {
                try {
                    RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHostname(((Payload)this.servicePayload).getIpAddress())).setProtocolHeader(((Payload)this.servicePayload).getProtocolHeader())).setPort(((Payload)this.servicePayload).getPort())).setHttpMethods(RESTHttpMethods.GET)).setContentType("application/json")).setServiceURI(((ThermalApiOptions)((Payload)this.servicePayload).getServiceOption()).replaceSystemId(((Payload)this.servicePayload).getSystemId())).build();
                    Response response = this.restReceiver.syncInvoke(client, request, this.logDirPath, this.serviceLogsId);
                    RestFullResponseData desResp = this.restReceiver.deserializeAsCommonData(response);
                    if (desResp.isRedfishErrorResponse()) {
                        this.responseData.add(desResp);
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, desResp.toString());
                        boolean fans = false;
                        return fans;
                    }
                    JsonNode temperatures = desResp.getResponseBody().get("Temperatures");
                    if (temperatures == null) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, this.serviceLogsId, "[" + ((Payload)this.servicePayload).getIpAddress() + "] No temperatures node in thermal.");
                        boolean bl = false;
                        return bl;
                    }
                    if (!temperatures.isArray()) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, this.serviceLogsId, "[" + ((Payload)this.servicePayload).getIpAddress() + "] No temperatures sensors.");
                        boolean bl = true;
                        return bl;
                    }
                    this.responseData.add(desResp);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, this.serviceLogsId, JacksonCommonUtil.getUtil().getPrettyPrintString(temperatures));
                    boolean bl = true;
                    return bl;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getMessage());
                    if (re.getUnexpectedBody() != null) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getUnexpectedBody());
                    }
                    boolean bl = false;
                    return bl;
                }
                finally {
                    client.close();
                }
            }
        }
        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((ThermalApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
        client.close();
        return false;
    }

    public static final class Payload
    extends RedfishApiPayload<Payload, ThermalApiOptions> {
        private String systemId;

        public Payload(String ipAddress, AbstractLoggerWriter loggerWriter) {
            super(ipAddress, loggerWriter);
            this.setServiceOption(ThermalApiOptions.UNKNOWN);
        }

        public Payload(String ipAddress, String username, String password, AbstractLoggerWriter loggerWriter) {
            super(ipAddress, username, password, loggerWriter);
            this.setServiceOption(ThermalApiOptions.UNKNOWN);
        }

        @Override
        protected Payload getThis() {
            return this;
        }

        public ThermalApi build() {
            return new ThermalApi(this);
        }

        public String getSystemId() {
            return this.systemId;
        }

        public Payload setSystemId(String systemId) {
            this.systemId = systemId;
            return this.getThis();
        }
    }
}

