/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.redfish.services;

import Gbt.core.jsonapi.JacksonCommonUtil;
import Gbt.core.loggers.AbstractLoggerWriter;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.redfish.RedfishApiPayload;
import Gbt.core.redfish.RedfishApiService;
import Gbt.core.redfish.RedfishResourceTypes;
import Gbt.core.rest.RESTException;
import Gbt.core.rest.RESTHttpMethods;
import Gbt.core.rest.RESTRequest;
import Gbt.core.rest.RESTRequestImpl;
import Gbt.utility.Common.GbtCommonConverters;
import Gbt.utility.redfish.RestFullResponseData;
import Gbt.utility.redfish.factories.RedfishApiMenu;
import Gbt.utility.redfish.models.ami.update.UpdateProgressInfo;
import Gbt.utility.redfish.models.common.updateservice.SimpleUpdateActionInfo;
import Gbt.utility.redfish.options.UpdateServiceApiOptions;
import com.fasterxml.jackson.core.JsonProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.Response;

public final class UpdateServiceApi
extends RedfishApiService<Payload> {
    private static final int MAX_RETRY_COUNT = 30;

    protected UpdateServiceApi(Payload servicePayload) {
        super(servicePayload);
    }

    @Override
    public String getServiceName() {
        return RedfishApiMenu.UPDATESERVICE.getApiName();
    }

    @Override
    protected boolean checkRawArgs() {
        if (((Payload)this.servicePayload).getRestRawArgs().length == 0) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((Payload)this.servicePayload).getIpAddress() + "] The input arguments not enough.");
            return false;
        }
        ((Payload)this.servicePayload).setServiceOption(UpdateServiceApiOptions.parse(((Payload)this.servicePayload).getRestRawArgs()[0]));
        switch ((UpdateServiceApiOptions)((Payload)this.servicePayload).getServiceOption()) {
            case INFO: {
                return true;
            }
            case UPDATE: {
                if (((Payload)this.servicePayload).getRestRawArgs().length != 2) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((Payload)this.servicePayload).getIpAddress() + "] " + ((UpdateServiceApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
                    return false;
                }
                ((Payload)this.servicePayload).setUploadJsonFile(GbtCommonConverters.stringToJavaIoFile(((Payload)this.servicePayload).getRestRawArgs()[1]));
                return this.uploadFileValidation(RedfishResourceTypes.Ignore);
            }
            case PROGRESS: {
                return true;
            }
        }
        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((Payload)this.servicePayload).getIpAddress() + "] " + ((UpdateServiceApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
        return false;
    }

    @Override
    protected boolean checkPayLoad() {
        switch ((UpdateServiceApiOptions)((Payload)this.servicePayload).getServiceOption()) {
            case INFO: {
                return true;
            }
            case UPDATE: {
                if (((Payload)this.servicePayload).getUploadJsonFile() != null) {
                    return this.uploadFileValidation(RedfishResourceTypes.Ignore);
                }
                if (((Payload)this.servicePayload).simpleUpdateActionInfo != null) {
                    return this.uploadDataValidation(RedfishResourceTypes.Ignore, ((Payload)this.servicePayload).simpleUpdateActionInfo);
                }
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((Payload)this.servicePayload).getIpAddress() + "] " + ((UpdateServiceApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
                return false;
            }
            case PROGRESS: {
                return true;
            }
        }
        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((Payload)this.servicePayload).getIpAddress() + "] " + ((UpdateServiceApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        Client client = null;
        try {
            client = this.restReceiver.createHttpsClient(((Payload)this.servicePayload).getUsername(), ((Payload)this.servicePayload).getPassword(), ((Payload)this.servicePayload).isDebug());
        }
        catch (RESTException re) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((Payload)this.servicePayload).getIpAddress() + "] Create HTTPS client fail.");
            return false;
        }
        switch ((UpdateServiceApiOptions)((Payload)this.servicePayload).getServiceOption()) {
            case INFO: {
                try {
                    RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHostname(((Payload)this.servicePayload).getIpAddress())).setProtocolHeader(((Payload)this.servicePayload).getProtocolHeader())).setPort(((Payload)this.servicePayload).getPort())).setHttpMethods(RESTHttpMethods.GET)).setServiceURI(((UpdateServiceApiOptions)((Payload)this.servicePayload).getServiceOption()).getMainUri()).setContentType("application/json")).build();
                    Response response = this.restReceiver.syncInvoke(client, request, this.logDirPath, this.serviceLogsId);
                    RestFullResponseData desResp = this.restReceiver.deserializeAsCommonData(response);
                    this.responseData.add(desResp);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(desResp.isRedfishErrorResponse() ? GbtLogLevel.ERROR : GbtLogLevel.INFO, "[" + ((Payload)this.servicePayload).getIpAddress() + "] " + this.serviceLogsId, desResp.toString());
                    boolean bl = !desResp.isRedfishErrorResponse();
                    return bl;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((Payload)this.servicePayload).getIpAddress() + "] " + re.getMessage());
                    if (re.getUnexpectedBody() != null) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((Payload)this.servicePayload).getIpAddress() + "] " + re.getUnexpectedBody());
                    }
                    boolean response = false;
                    return response;
                }
                finally {
                    client.close();
                }
            }
            case UPDATE: {
                RESTRequestImpl up_request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHostname(((Payload)this.servicePayload).getIpAddress())).setProtocolHeader(((Payload)this.servicePayload).getProtocolHeader())).setPort(((Payload)this.servicePayload).getPort())).setHttpMethods(RESTHttpMethods.POST)).setServiceURI(((UpdateServiceApiOptions)((Payload)this.servicePayload).getServiceOption()).getMainUri()).setContentType("application/json")).setRawJsonData(this.requestBody)).build();
                RestFullResponseData up_desResp = null;
                try (Response up_response = null;){
                    up_response = this.restReceiver.syncInvoke(client, up_request, this.logDirPath, this.serviceLogsId);
                    up_desResp = this.restReceiver.deserializeAsCommonData(up_response);
                    this.responseData.add(up_desResp);
                    if (up_desResp.isRedfishErrorResponse()) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((Payload)this.servicePayload).getIpAddress() + "] Fail to start the simple update.");
                        client.close();
                        boolean bl = false;
                        return bl;
                    }
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, this.serviceLogsId, "[" + ((Payload)this.servicePayload).getIpAddress() + "] Start the simple update.");
                }
                int retry = 0;
                while (retry < 30) {
                    try {
                        up_request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHostname(((Payload)this.servicePayload).getIpAddress())).setProtocolHeader(((Payload)this.servicePayload).getProtocolHeader())).setPort(((Payload)this.servicePayload).getPort())).setHttpMethods(RESTHttpMethods.GET)).setServiceURI(UpdateServiceApiOptions.PROGRESS.getMainUri()).setContentType("application/json")).build();
                        up_response = this.restReceiver.syncInvoke(client, up_request, this.logDirPath, this.serviceLogsId);
                        up_desResp = this.restReceiver.deserializeAsCommonData(up_response);
                        Thread.sleep(3000L);
                    }
                    catch (RESTException re) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((Payload)this.servicePayload).getIpAddress() + "] " + re.getMessage());
                        ++retry;
                        continue;
                    }
                    catch (InterruptedException ie) {
                        client.close();
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((Payload)this.servicePayload).getIpAddress() + "] " + ie.getMessage());
                        boolean bl = false;
                        return bl;
                    }
                    finally {
                        if (up_response == null) continue;
                        up_response.close();
                        continue;
                    }
                    if (up_desResp.isRedfishErrorResponse()) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((Payload)this.servicePayload).getIpAddress() + "] " + up_desResp.toString());
                        this.responseData.add(up_desResp);
                        ++retry;
                        continue;
                    }
                    try {
                        UpdateProgressInfo updateProgressInfo = JacksonCommonUtil.getUtil().jsonNodeToPojo(up_desResp.getResponseBody().get("Oem").get("AMIUpdateService").get("UpdateInformation"), UpdateProgressInfo.class);
                        this.responseData.add(updateProgressInfo);
                        if (updateProgressInfo.getFlashPercentage().contains("100%") || updateProgressInfo.getUpdateStatus().contains("Completed")) {
                            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, this.serviceLogsId, "[" + ((Payload)this.servicePayload).getIpAddress() + "] Target : " + updateProgressInfo.getUpdateTarget() + ", " + updateProgressInfo.getUpdateStatus() + " " + updateProgressInfo.getFlashPercentage());
                            break;
                        }
                        if (updateProgressInfo.getUpdateStatus().equals("")) {
                            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, this.serviceLogsId, "[" + ((Payload)this.servicePayload).getIpAddress() + "] Wait for update progress refresh complete.");
                            Thread.sleep(1000L);
                            ++retry;
                            continue;
                        }
                        if (updateProgressInfo.getUpdateStatus().toLowerCase().contains("fail")) {
                            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((Payload)this.servicePayload).getIpAddress() + "] Target : " + updateProgressInfo.getUpdateTarget() + ", " + updateProgressInfo.getUpdateStatus() + " " + updateProgressInfo.getFlashPercentage());
                            client.close();
                            return false;
                        }
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, this.serviceLogsId, "[" + ((Payload)this.servicePayload).getIpAddress() + "] Target : " + updateProgressInfo.getUpdateTarget() + ", " + updateProgressInfo.getUpdateStatus() + " " + updateProgressInfo.getFlashPercentage());
                        retry = 0;
                    }
                    catch (JsonProcessingException je) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((Payload)this.servicePayload).getIpAddress() + "] " + je.getMessage());
                        ++retry;
                    }
                    catch (InterruptedException ie) {
                        client.close();
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((Payload)this.servicePayload).getIpAddress() + "] " + ie.getMessage());
                        return false;
                    }
                }
                client.close();
                return retry != 30;
            }
            case PROGRESS: {
                try {
                    RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHostname(((Payload)this.servicePayload).getIpAddress())).setProtocolHeader(((Payload)this.servicePayload).getProtocolHeader())).setPort(((Payload)this.servicePayload).getPort())).setHttpMethods(RESTHttpMethods.GET)).setServiceURI(((UpdateServiceApiOptions)((Payload)this.servicePayload).getServiceOption()).getMainUri()).setContentType("application/json")).build();
                    Response response = this.restReceiver.syncInvoke(client, request, this.logDirPath, this.serviceLogsId);
                    RestFullResponseData desResp = this.restReceiver.deserializeAsCommonData(response);
                    desResp.setResponseBody(desResp.getResponseBody().get("Oem"));
                    this.responseData.add(desResp);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(desResp.isRedfishErrorResponse() ? GbtLogLevel.ERROR : GbtLogLevel.INFO, this.serviceLogsId, desResp.toString());
                    boolean bl = !desResp.isRedfishErrorResponse();
                    return bl;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((Payload)this.servicePayload).getIpAddress() + "] " + re.getMessage());
                    if (re.getUnexpectedBody() != null) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((Payload)this.servicePayload).getIpAddress() + "] " + re.getUnexpectedBody());
                    }
                    boolean bl = false;
                    return bl;
                }
                finally {
                    client.close();
                }
            }
        }
        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((UpdateServiceApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
        client.close();
        return false;
    }

    public static final class Payload
    extends RedfishApiPayload<Payload, UpdateServiceApiOptions> {
        private SimpleUpdateActionInfo simpleUpdateActionInfo;

        public Payload(String ipAddress, AbstractLoggerWriter loggerWriter) {
            super(ipAddress, loggerWriter);
            this.setServiceOption(UpdateServiceApiOptions.UNKNOWN);
        }

        public Payload(String ipAddress, String username, String password, AbstractLoggerWriter loggerWriter) {
            super(ipAddress, username, password, loggerWriter);
            this.setServiceOption(UpdateServiceApiOptions.UNKNOWN);
        }

        @Override
        protected Payload getThis() {
            return this;
        }

        public UpdateServiceApi build() {
            return new UpdateServiceApi(this);
        }

        public Payload setSimpleUpdateActionInfo(SimpleUpdateActionInfo simpleUpdateActionInfo) {
            this.simpleUpdateActionInfo = simpleUpdateActionInfo;
            return this.getThis();
        }
    }
}

