/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.rest.services;

import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.jsonapi.JacksonCommonUtil;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.core.loggers.AbstractLoggerWriter;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.rest.RESTException;
import Gbt.core.rest.RESTHttpMethods;
import Gbt.core.rest.RESTRequest;
import Gbt.core.rest.RESTRequestImpl;
import Gbt.core.rest.RESTServices;
import Gbt.core.rest.RESTServicesOptions;
import Gbt.utility.rest.models.AMIRestIPv6;
import Gbt.utility.rest.options.IPv6ServiceOptions;
import java.io.File;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;

public final class IPv6Services
extends RESTServices {
    public static final String SERVICE_NAME = "ipv6";
    private static final String IPV6_RESOURCE_URI = "/api/settings/network";
    private AMIRestIPv6 restIPv6;

    public IPv6Services(AbstractLoggerWriter loggerWriter) {
        super(loggerWriter);
    }

    @Override
    public String getServiceName() {
        return SERVICE_NAME;
    }

    @Override
    public boolean readJsonFiles(List<File> dataFiles, RESTServicesOptions restServicesOptions) {
        switch (restServicesOptions.getOptionName()) {
            case "put": {
                try {
                    this.restIPv6 = (AMIRestIPv6)JacksonCommonUtil.getUtil().readJSONFile(dataFiles.get(0), IPv6ServiceOptions.SET_IPv6.getRequestPayloadType());
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public boolean readJsonData(AbstractJSONPOJO jsonData, RESTServicesOptions restServicesOptions) {
        return true;
    }

    @Override
    public boolean uploadFiles(List<File> uploadFiles, RESTServicesOptions restServicesOptions) {
        return true;
    }

    @Override
    public boolean execute(String ipAddress, RESTServicesOptions option) {
        String logName = ipAddress + "_" + this.logDirPath + "_" + this.getServiceName();
        switch (option.getOptionName()) {
            case "get": {
                RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHttpMethods(RESTHttpMethods.GET)).setHostname(ipAddress)).setPort(this.bmcPort)).setServiceURI(IPV6_RESOURCE_URI).setCookies(this.sessionData)).setContentType("application/json")).build();
                try {
                    Response response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
                    this.jsonResults.addAll((Collection)this.clientReceiver.deserialize(response, new GenericType<List<AMIRestIPv6>>(){}));
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Get IPv6 config success.");
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, logName, this.getJsonResultsPrettyPrintString());
                    return true;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Get IPv6 config fail.");
                    this.restExceptionMessages(re, ipAddress, logName);
                    this.jsonResults.add(new NullJSONData().setError(true).setMessages("Get IPv6 config fail."));
                    return false;
                }
            }
            case "put": {
                RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHttpMethods(RESTHttpMethods.PUT)).setHostname(ipAddress)).setPort(this.bmcPort)).setServiceURI(IPV6_RESOURCE_URI).setCookies(this.sessionData)).setRawJsonData(this.restIPv6)).setContentType("application/json")).build();
                try {
                    Response response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
                    this.restIPv6 = this.clientReceiver.deserialize(response, new GenericType<AMIRestIPv6>(){});
                    this.jsonResults.add(this.restIPv6);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Set IPv6 config success.");
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, logName, this.restIPv6.toString());
                    return true;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Set IPv6 config fail.");
                    this.restExceptionMessages(re, ipAddress, logName);
                    this.jsonResults.add(new NullJSONData().setError(true).setMessages("Set IPv6 config fail."));
                    return false;
                }
            }
        }
        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Unknown option of " + this.getServiceName() + " service.");
        this.jsonResults.add(new NullJSONData().setError(true).setMessages("Unknown option of " + this.getServiceName() + " service."));
        return false;
    }
}

