/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.rest.services;

import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.jsonapi.JacksonCommonUtil;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.core.loggers.AbstractLoggerWriter;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.rest.RESTException;
import Gbt.core.rest.RESTHttpMethods;
import Gbt.core.rest.RESTRequest;
import Gbt.core.rest.RESTRequestImpl;
import Gbt.core.rest.RESTServices;
import Gbt.core.rest.RESTServicesOptions;
import Gbt.utility.rest.models.ldap.AMIRestLdapSettings;
import java.io.File;
import java.math.BigInteger;
import java.util.List;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;

public final class LDAPGeneralService
extends RESTServices {
    public static final String SERVICE_NAME = "ldapgeneral";
    private static final String LDAP_GENERAL_URI = "/api/settings/ldap-settings";
    private static final BigInteger ENABLE_0 = new BigInteger("0");
    private static final BigInteger ENABLE_1 = new BigInteger("1");
    private static final BigInteger PORT_MAX = new BigInteger("65535");
    private static final BigInteger PORT_MIN = new BigInteger("1");
    private static final String BIND_DN_MATCH_STRING = "(((cn=)|(uid=)|(ou=)|(dc=)|(o=))[a-zA-Z][\\w\\-.]{1,63},?)+$";
    private static final String SEARCH_BASE = "(((cn=)|(uid=)|(ou=)|(dc=)|(o=))[a-zA-Z][\\w\\-.]{1,63},?)+$";
    private static final String IPV6 = "(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]+|::(ffff(:0{1,4})?:)?((25[0-5]|(2[0-4]|1?[0-9])?[0-9])\\.){3}(25[0-5]|(2[0-4]|1?[0-9])?[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1?[0-9])?[0-9])\\.){3}(25[0-5]|(2[0-4]|1?[0-9])?[0-9]))";
    private static final String IPV4 = "((25[0-5]|(2[0-4]|1?[0-9])?[0-9])\\.){3}(25[0-5]|(2[0-4]|1?[0-9])?[0-9])";
    private AMIRestLdapSettings uploadData;

    public LDAPGeneralService(AbstractLoggerWriter loggerWriter) {
        super(loggerWriter);
    }

    @Override
    public String getServiceName() {
        return SERVICE_NAME;
    }

    @Override
    public boolean readJsonData(AbstractJSONPOJO jsonData, RESTServicesOptions restServicesOptions) {
        return true;
    }

    @Override
    public boolean readJsonFiles(List<File> dataFiles, RESTServicesOptions servicesOptions) {
        switch (servicesOptions.getOptionName()) {
            case "put": {
                try {
                    this.uploadData = (AMIRestLdapSettings)JacksonCommonUtil.getUtil().readJSONFile(dataFiles.get(0), servicesOptions.getRequestPayloadType());
                }
                catch (Exception e) {
                    return false;
                }
                return this.parseJsonFile();
            }
        }
        return true;
    }

    @Override
    public boolean uploadFiles(List<File> uploadFiles, RESTServicesOptions restServicesOptions) {
        return true;
    }

    @Override
    public boolean execute(String ipAddress, RESTServicesOptions option) {
        String logName = ipAddress + "_" + this.logDirPath + "_" + this.getServiceName();
        switch (option.getOptionName()) {
            case "get": {
                RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHttpMethods(RESTHttpMethods.GET)).setHostname(ipAddress)).setPort(this.bmcPort)).setServiceURI(LDAP_GENERAL_URI).setCookies(this.sessionData)).setContentType("application/json")).build();
                try {
                    Response response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
                    this.uploadData = this.clientReceiver.deserialize(response, new GenericType<AMIRestLdapSettings>(){});
                    this.jsonResults.add(this.uploadData);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Get LDAP general data success.");
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, logName, this.uploadData.toString());
                    return true;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Get LDAP general data fail.");
                    this.restExceptionMessages(re, ipAddress, logName);
                    this.jsonResults.add(new NullJSONData().setError(true).setMessages("Get AD user service fail."));
                    return false;
                }
            }
            case "put": {
                RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHttpMethods(RESTHttpMethods.PUT)).setHostname(ipAddress)).setPort(this.bmcPort)).setServiceURI(LDAP_GENERAL_URI).setCookies(this.sessionData)).setRawJsonData(this.uploadData)).setContentType("application/json")).build();
                try {
                    Response response2 = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
                    this.uploadData = this.clientReceiver.deserialize(response2, new GenericType<AMIRestLdapSettings>(){});
                    this.jsonResults.add(this.uploadData);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Set LDAP general data success.");
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, logName, this.uploadData.toString());
                    return true;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Set LDAP general data fail.");
                    this.restExceptionMessages(re, ipAddress, logName);
                    this.jsonResults.add(new NullJSONData().setError(true).setMessages("Set LDAP general data fail."));
                    return false;
                }
            }
        }
        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Unknown option of " + this.getServiceName() + " service.");
        this.jsonResults.add(new NullJSONData().setError(true).setMessages("Unknown option of " + this.getServiceName() + " service."));
        return false;
    }

    private boolean parseJsonFile() {
        BigInteger enable = this.uploadData.getEnable();
        if (enable.compareTo(ENABLE_0) != 0 && enable.compareTo(ENABLE_1) != 0) {
            System.out.println("Invaid enable field");
            System.out.println(enable);
            return false;
        }
        if (enable.intValue() == 0) {
            return true;
        }
        if (enable.compareTo(ENABLE_1) == 0 && !this.uploadData.getBind_dn().matches("(((cn=)|(uid=)|(ou=)|(dc=)|(o=))[a-zA-Z][\\w\\-.]{1,63},?)+$")) {
            if (this.uploadData.getBind_dn().contains(" ")) {
                System.out.println("Invaid Bind DN field, there is space");
            }
            System.out.println("Invaid Bind DN field");
            return false;
        }
        if (enable.compareTo(ENABLE_1) == 0 && (this.uploadData.getPassword() == null || this.uploadData.getPassword() == null)) {
            System.out.println("Invaid password field");
            return false;
        }
        if (enable.compareTo(ENABLE_1) == 0 && (this.uploadData.getPort() == null || this.uploadData.getPort().compareTo(PORT_MIN) < 0 || this.uploadData.getPort().compareTo(PORT_MAX) > 0)) {
            System.out.println("Invaid port field");
            return false;
        }
        if (enable.compareTo(ENABLE_1) == 0 && !this.uploadData.getSearch_base().matches("(((cn=)|(uid=)|(ou=)|(dc=)|(o=))[a-zA-Z][\\w\\-.]{1,63},?)+$")) {
            if (this.uploadData.getSearch_base().contains(" ")) {
                System.out.println("Invaid Search base field, there is space");
            }
            System.out.println("Invaid Search base field");
            return false;
        }
        if (enable.compareTo(ENABLE_1) == 0 && !this.uploadData.getServer_address().matches(IPV4) && !this.uploadData.getServer_address().matches(IPV6)) {
            System.out.println("Invaid Server Address field");
            return false;
        }
        return true;
    }
}

