/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.sol;

import Gbt.core.loggers.AbstractLoggerWriter;
import Gbt.core.loggers.DefaultLoggerWriter;
import Gbt.core.loggers.GbtLogLevel;
import com.veraxsystems.vxipmi.api.sol.SolEventListener;
import com.veraxsystems.vxipmi.coding.payload.sol.SolOperation;
import com.veraxsystems.vxipmi.coding.payload.sol.SolStatus;
import java.util.Set;

public class SolDeactivateEventListener
implements SolEventListener {
    private boolean terminate = false;
    private String commandName;
    private String commandID;
    private String bmcIP;
    private AbstractLoggerWriter loggerWriter;

    public SolDeactivateEventListener(String commandName, String bmcIP) {
        this.commandName = commandName;
        this.bmcIP = bmcIP;
        this.commandID = this.bmcIP + "_" + commandName;
        this.loggerWriter = new DefaultLoggerWriter();
    }

    @Override
    public void processRequestEvent(Set<SolStatus> statuses) {
        if (statuses.contains((Object)SolStatus.SolDeactivated)) {
            this.terminate = true;
            this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + this.bmcIP + "] SOL deactivate detected!");
        }
    }

    @Override
    public void processResponseEvent(Set<SolStatus> statuses, byte[] correspondingRequestData, Set<SolOperation> correspondingRequestOperations) {
    }

    public boolean isTerminate() {
        return this.terminate;
    }
}

