/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.solconfig;

import com.fasterxml.jackson.annotation.JsonValue;

public enum SolVolatileBitRates {
    DEFAULT_BIT_RATE(0, "9600 bps"),
    _9600bps(6, "9600 bps"),
    _19200bps(7, "19.2 kbps"),
    _38400bps(8, "38.4 kbps"),
    _57600bps(9, "57.6 kbps"),
    _115200bps(10, "115.2 kbps");

    private static final byte DEFAULT_BIT_RATE_code = 0;
    private static final byte _9600_CODE = 6;
    private static final byte _19200_CODE = 7;
    private static final byte _38400_CODE = 8;
    private static final byte _57600_CODE = 9;
    private static final byte _115200_CODE = 10;
    private final byte code;
    private final String item;

    private SolVolatileBitRates(byte code, String item) {
        this.code = code;
        this.item = item;
    }

    public byte getCode() {
        return this.code;
    }

    @JsonValue
    public String toString() {
        return this.item;
    }

    public static final SolVolatileBitRates parseByInt(int rate) {
        switch (rate) {
            case 9600: {
                return _9600bps;
            }
            case 19200: {
                return _19200bps;
            }
            case 38400: {
                return _38400bps;
            }
            case 57600: {
                return _57600bps;
            }
            case 115200: {
                return _115200bps;
            }
        }
        return DEFAULT_BIT_RATE;
    }

    public static final SolVolatileBitRates parseByByte(byte rateCode) {
        switch (rateCode) {
            case 6: {
                return _9600bps;
            }
            case 7: {
                return _19200bps;
            }
            case 8: {
                return _38400bps;
            }
            case 9: {
                return _57600bps;
            }
            case 10: {
                return _115200bps;
            }
        }
        return DEFAULT_BIT_RATE;
    }
}

