/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.vxipmi.coding.commands.fru;

import com.veraxsystems.vxipmi.coding.commands.IpmiCommandCoder;
import com.veraxsystems.vxipmi.coding.commands.IpmiVersion;
import com.veraxsystems.vxipmi.coding.commands.ResponseData;
import com.veraxsystems.vxipmi.coding.commands.fru.BaseUnit;
import com.veraxsystems.vxipmi.coding.commands.fru.GetFruInventoryAreaInfoResponseData;
import com.veraxsystems.vxipmi.coding.payload.CompletionCode;
import com.veraxsystems.vxipmi.coding.payload.IpmiPayload;
import com.veraxsystems.vxipmi.coding.payload.lan.IPMIException;
import com.veraxsystems.vxipmi.coding.payload.lan.IpmiLanRequest;
import com.veraxsystems.vxipmi.coding.payload.lan.IpmiLanResponse;
import com.veraxsystems.vxipmi.coding.payload.lan.NetworkFunction;
import com.veraxsystems.vxipmi.coding.protocol.AuthenticationType;
import com.veraxsystems.vxipmi.coding.protocol.IpmiMessage;
import com.veraxsystems.vxipmi.coding.security.CipherSuite;
import com.veraxsystems.vxipmi.common.TypeConverter;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;

public class GetFruInventoryAreaInfo
extends IpmiCommandCoder {
    private int fruId;

    public GetFruInventoryAreaInfo(IpmiVersion version, CipherSuite cipherSuite, AuthenticationType authenticationType, int fruId) {
        super(version, cipherSuite, authenticationType);
        if (fruId > 255) {
            throw new IllegalArgumentException("FRU ID cannot exceed 255");
        }
        this.fruId = fruId;
    }

    @Override
    public byte getCommandCode() {
        return 16;
    }

    @Override
    public NetworkFunction getNetworkFunction() {
        return NetworkFunction.StorageRequest;
    }

    @Override
    protected IpmiPayload preparePayload(int sequenceNumber) {
        byte[] payload = new byte[]{TypeConverter.intToByte(this.fruId)};
        return new IpmiLanRequest(this.getNetworkFunction(), this.getCommandCode(), payload, TypeConverter.intToByte(sequenceNumber));
    }

    @Override
    public ResponseData getResponseData(IpmiMessage message) throws IllegalArgumentException, IPMIException, NoSuchAlgorithmException, InvalidKeyException {
        if (!this.isCommandResponse(message)) {
            throw new IllegalArgumentException("This is not a response for Get FRU Inventory Info command");
        }
        if (!(message.getPayload() instanceof IpmiLanResponse)) {
            throw new IllegalArgumentException("Invalid response payload");
        }
        if (((IpmiLanResponse)message.getPayload()).getCompletionCode() != CompletionCode.Ok) {
            throw new IPMIException(((IpmiLanResponse)message.getPayload()).getCompletionCode());
        }
        byte[] raw = message.getPayload().getIpmiCommandData();
        if (raw == null || raw.length != 3) {
            throw new IllegalArgumentException("Invalid response payload length");
        }
        GetFruInventoryAreaInfoResponseData responseData = new GetFruInventoryAreaInfoResponseData();
        byte[] buffer = new byte[]{raw[0], raw[1], 0, 0};
        responseData.setFruInventoryAreaSize(TypeConverter.littleEndianByteArrayToInt(buffer));
        responseData.setFruUnit(BaseUnit.parseInt(TypeConverter.byteToInt(raw[2]) & 1));
        return responseData;
    }
}

