/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.vxipmi.connection;

import com.veraxsystems.vxipmi.coding.PayloadCoder;
import com.veraxsystems.vxipmi.coding.commands.IpmiVersion;
import com.veraxsystems.vxipmi.coding.commands.PrivilegeLevel;
import com.veraxsystems.vxipmi.coding.commands.ResponseData;
import com.veraxsystems.vxipmi.coding.commands.session.GetChannelAuthenticationCapabilities;
import com.veraxsystems.vxipmi.coding.commands.session.GetChannelAuthenticationCapabilitiesResponseData;
import com.veraxsystems.vxipmi.coding.commands.session.GetChannelCipherSuitesResponseData;
import com.veraxsystems.vxipmi.coding.commands.session.OpenSessionResponseData;
import com.veraxsystems.vxipmi.coding.commands.session.Rakp1ResponseData;
import com.veraxsystems.vxipmi.coding.commands.session.Rakp3ResponseData;
import com.veraxsystems.vxipmi.coding.payload.IpmiPayload;
import com.veraxsystems.vxipmi.coding.protocol.Ipmiv20Message;
import com.veraxsystems.vxipmi.coding.protocol.PayloadType;
import com.veraxsystems.vxipmi.coding.security.CipherSuite;
import com.veraxsystems.vxipmi.common.PropertiesManager;
import com.veraxsystems.vxipmi.common.TypeConverter;
import com.veraxsystems.vxipmi.connection.ConnectionException;
import com.veraxsystems.vxipmi.connection.ConnectionListener;
import com.veraxsystems.vxipmi.connection.IpmiMessageHandler;
import com.veraxsystems.vxipmi.connection.MessageHandler;
import com.veraxsystems.vxipmi.connection.SessionManager;
import com.veraxsystems.vxipmi.connection.SolMessageHandler;
import com.veraxsystems.vxipmi.sm.MachineObserver;
import com.veraxsystems.vxipmi.sm.StateMachine;
import com.veraxsystems.vxipmi.sm.actions.ErrorAction;
import com.veraxsystems.vxipmi.sm.actions.GetSikAction;
import com.veraxsystems.vxipmi.sm.actions.MessageAction;
import com.veraxsystems.vxipmi.sm.actions.ResponseAction;
import com.veraxsystems.vxipmi.sm.actions.ResponseRmcpAction;
import com.veraxsystems.vxipmi.sm.actions.StateMachineAction;
import com.veraxsystems.vxipmi.sm.events.AuthenticationCapabilitiesReceived;
import com.veraxsystems.vxipmi.sm.events.Authorize;
import com.veraxsystems.vxipmi.sm.events.CloseSession;
import com.veraxsystems.vxipmi.sm.events.Default;
import com.veraxsystems.vxipmi.sm.events.DefaultAck;
import com.veraxsystems.vxipmi.sm.events.GetChannelCipherSuitesPending;
import com.veraxsystems.vxipmi.sm.events.OpenSessionAck;
import com.veraxsystems.vxipmi.sm.events.Rakp2Ack;
import com.veraxsystems.vxipmi.sm.events.SendRmcpPingMessage;
import com.veraxsystems.vxipmi.sm.events.StartSession;
import com.veraxsystems.vxipmi.sm.events.Timeout;
import com.veraxsystems.vxipmi.sm.states.Authcap;
import com.veraxsystems.vxipmi.sm.states.Ciphers;
import com.veraxsystems.vxipmi.sm.states.SessionValid;
import com.veraxsystems.vxipmi.sm.states.Uninitialized;
import com.veraxsystems.vxipmi.transport.Messenger;
import java.io.IOException;
import java.net.InetAddress;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import javax.crypto.NoSuchPaddingException;

public class Connection
extends TimerTask
implements MachineObserver {
    private static final int SESSION_SEQUENCE_NUMBER_UPPER_BOUND = 0x1FFFFFFF;
    private List<ConnectionListener> listeners;
    private StateMachine stateMachine;
    private boolean keepAlive;
    private int timeout = -1;
    private volatile StateMachineAction lastAction;
    private int sessionId;
    private int managedSystemSessionId;
    private byte[] sik;
    private int handle;
    private Map<PayloadType, MessageHandler> messageHandlers;
    private Timer timer;
    private AtomicInteger currentSessionSequenceNumber;

    public Connection(Messenger messenger, int handle) throws IOException {
        this.stateMachine = new StateMachine(messenger);
        this.handle = handle;
        this.listeners = new ArrayList<ConnectionListener>();
        this.timeout = Integer.parseInt(PropertiesManager.getInstance().getProperty("timeout"));
        this.messageHandlers = new EnumMap<PayloadType, MessageHandler>(PayloadType.class);
        this.currentSessionSequenceNumber = new AtomicInteger(0);
        this.keepAlive = false;
    }

    public void registerListener(ConnectionListener listener) {
        this.listeners.add(listener);
    }

    public void unregisterListener(ConnectionListener listener) {
        this.listeners.remove(listener);
    }

    public void connect(InetAddress address, int port, int pingPeriod) {
        this.connect(address, port, pingPeriod, false);
    }

    public void connect(InetAddress address, int port, int pingPeriod, boolean skipCiphers) {
        this.timer = new Timer("IPMI Connection Timer [" + address.getHostAddress() + "]");
        this.timer.schedule((TimerTask)this, pingPeriod, (long)pingPeriod);
        this.stateMachine.register(this);
        if (skipCiphers) {
            this.stateMachine.start(address, port);
            this.messageHandlers.put(PayloadType.Ipmi, new IpmiMessageHandler(this, this.timeout));
            this.messageHandlers.put(PayloadType.Sol, new SolMessageHandler(this, this.timeout));
            this.sessionId = SessionManager.generateSessionId();
            this.stateMachine.setCurrent(new Authcap());
        } else {
            this.stateMachine.start(address, port);
            this.messageHandlers.put(PayloadType.Ipmi, new IpmiMessageHandler(this, this.timeout));
            this.messageHandlers.put(PayloadType.Sol, new SolMessageHandler(this, this.timeout));
        }
    }

    public void disconnect() {
        this.timer.cancel();
        this.timer.purge();
        this.stateMachine.stop();
        for (MessageHandler messageHandler : this.messageHandlers.values()) {
            messageHandler.tearDown();
        }
    }

    public boolean isActive() {
        return this.stateMachine.isActive();
    }

    public List<CipherSuite> getAvailableCipherSuites(int tag) throws ConnectionException {
        if (this.stateMachine.getCurrent().getClass() != Uninitialized.class) {
            throw new ConnectionException(this.stateMachine.getCurrent());
        }
        boolean process = true;
        ArrayList<byte[]> rawCipherSuites = new ArrayList<byte[]>();
        while (process) {
            this.lastAction = null;
            this.stateMachine.doTransition(new GetChannelCipherSuitesPending(tag));
            this.waitForResponse();
            ResponseAction action = (ResponseAction)this.lastAction;
            if (!(action.getIpmiResponseData() instanceof GetChannelCipherSuitesResponseData)) {
                this.stateMachine.doTransition(new Timeout());
                throw new ConnectionException("Response data not matching Get Channel Cipher Suites command.");
            }
            GetChannelCipherSuitesResponseData responseData = (GetChannelCipherSuitesResponseData)action.getIpmiResponseData();
            rawCipherSuites.add(responseData.getCipherSuiteData());
            if (responseData.getCipherSuiteData().length >= 16) continue;
            process = false;
        }
        this.stateMachine.doTransition(new DefaultAck());
        int length = 0;
        for (byte[] partial : rawCipherSuites) {
            length += partial.length;
        }
        byte[] csRaw = new byte[length];
        int index = 0;
        for (byte[] partial : rawCipherSuites) {
            System.arraycopy(partial, 0, csRaw, index, partial.length);
            index += partial.length;
        }
        return CipherSuite.getCipherSuites(csRaw);
    }

    private void waitForResponse() throws ConnectionException {
        for (int time = 0; time < this.timeout && this.lastAction == null; ++time) {
            try {
                Thread.sleep(1L);
                continue;
            }
            catch (InterruptedException ie) {
                throw new ConnectionException("Interrupt to wait for response.");
            }
        }
        if (this.lastAction == null) {
            this.stateMachine.doTransition(new Timeout());
            throw new ConnectionException("Wait for response timed out.");
        }
        if (!(this.lastAction instanceof ResponseAction) && !(this.lastAction instanceof GetSikAction)) {
            if (this.lastAction instanceof ErrorAction) {
                throw new ConnectionException("Error action of response from StateMachine.", ((ErrorAction)this.lastAction).getException());
            }
            throw new ConnectionException("Invalid StateMachine of response : " + this.lastAction.getClass().getSimpleName());
        }
    }

    public GetChannelAuthenticationCapabilitiesResponseData getChannelAuthenticationCapabilities(int tag, CipherSuite cipherSuite, PrivilegeLevel requestedPrivilegeLevel) throws ConnectionException {
        if (this.stateMachine.getCurrent().getClass() != Ciphers.class) {
            throw new ConnectionException(this.stateMachine.getCurrent());
        }
        this.lastAction = null;
        this.stateMachine.doTransition(new Default(cipherSuite, tag, requestedPrivilegeLevel));
        this.waitForResponse();
        ResponseAction action = (ResponseAction)this.lastAction;
        if (!(action.getIpmiResponseData() instanceof GetChannelAuthenticationCapabilitiesResponseData)) {
            this.stateMachine.doTransition(new Timeout());
            throw new ConnectionException("Response data not matching Get Channel Authentication Capabilities command.");
        }
        GetChannelAuthenticationCapabilitiesResponseData responseData = (GetChannelAuthenticationCapabilitiesResponseData)action.getIpmiResponseData();
        this.sessionId = SessionManager.generateSessionId();
        this.stateMachine.doTransition(new AuthenticationCapabilitiesReceived(this.sessionId, requestedPrivilegeLevel));
        return responseData;
    }

    public int startSession(int tag, CipherSuite cipherSuite, PrivilegeLevel privilegeLevel, String username, String password, byte[] bmcKey) throws ConnectionException, NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException {
        if (this.stateMachine.getCurrent().getClass() != Authcap.class) {
            throw new ConnectionException(this.stateMachine.getCurrent());
        }
        this.lastAction = null;
        this.stateMachine.doTransition(new Authorize(cipherSuite, tag, privilegeLevel, this.sessionId));
        this.waitForResponse();
        ResponseAction action = (ResponseAction)this.lastAction;
        this.lastAction = null;
        if (!(action.getIpmiResponseData() instanceof OpenSessionResponseData)) {
            this.stateMachine.doTransition(new Timeout());
            throw new ConnectionException("Response data not matching OpenSession response data");
        }
        this.managedSystemSessionId = ((OpenSessionResponseData)action.getIpmiResponseData()).getManagedSystemSessionId();
        this.stateMachine.doTransition(new DefaultAck());
        this.stateMachine.doTransition(new OpenSessionAck(cipherSuite, privilegeLevel, tag, this.managedSystemSessionId, username, password, bmcKey));
        this.waitForResponse();
        action = (ResponseAction)this.lastAction;
        this.lastAction = null;
        if (!(action.getIpmiResponseData() instanceof Rakp1ResponseData)) {
            this.stateMachine.doTransition(new Timeout());
            throw new ConnectionException("Response data not matching RAKP Message 2: " + action.getIpmiResponseData().getClass().getSimpleName());
        }
        Rakp1ResponseData rakp1ResponseData = (Rakp1ResponseData)action.getIpmiResponseData();
        this.stateMachine.doTransition(new DefaultAck());
        this.stateMachine.doTransition(new Rakp2Ack(cipherSuite, tag, 0, this.managedSystemSessionId, rakp1ResponseData));
        this.waitForResponse();
        action = (ResponseAction)this.lastAction;
        if (this.sik == null) {
            throw new ConnectionException("Session Integrity Key is null");
        }
        cipherSuite.initializeAlgorithms(this.sik);
        this.lastAction = null;
        if (!(action.getIpmiResponseData() instanceof Rakp3ResponseData)) {
            this.stateMachine.doTransition(new Timeout());
            throw new ConnectionException("Response data not matching RAKP Message 4");
        }
        this.stateMachine.doTransition(new DefaultAck());
        this.stateMachine.doTransition(new StartSession(cipherSuite, this.sessionId));
        return this.sessionId;
    }

    public void closeSession() throws ConnectionException {
        if (this.stateMachine.getCurrent().getClass() != SessionValid.class) {
            throw new ConnectionException(this.stateMachine.getCurrent());
        }
        this.stateMachine.doTransition(new CloseSession(this.managedSystemSessionId, this.messageHandlers.get((Object)PayloadType.Ipmi).getSequenceNumber(), this.getNextSessionSequenceNumber()));
    }

    public int sendMessage(PayloadCoder payloadCoder, boolean isOneWay) throws ConnectionException {
        this.keepAlive = isOneWay;
        MessageHandler messageHandler = this.messageHandlers.get((Object)payloadCoder.getSupportedPayloadType());
        if (messageHandler == null) {
            messageHandler = this.messageHandlers.get((Object)PayloadType.Ipmi);
        }
        return messageHandler.sendMessage(payloadCoder, this.stateMachine, this.managedSystemSessionId, isOneWay);
    }

    public int retry(int tag, PayloadType messagePayloadType) throws ConnectionException {
        MessageHandler messageHandler = this.messageHandlers.containsKey((Object)messagePayloadType) ? this.messageHandlers.get((Object)messagePayloadType) : this.messageHandlers.get((Object)PayloadType.Ipmi);
        return messageHandler.retryMessage(tag, this.stateMachine, this.managedSystemSessionId);
    }

    public void notifyResponseListeners(int handle, int tag, ResponseData responseData, Exception exception) {
        for (ConnectionListener listener : this.listeners) {
            if (listener == null) continue;
            listener.processResponse(responseData, handle, tag, exception);
        }
    }

    public void notifyRequestListeners(int handle, IpmiPayload payload) {
        for (ConnectionListener listener : this.listeners) {
            if (listener == null) continue;
            listener.processRequest(handle, payload);
        }
    }

    @Override
    public void notify(StateMachineAction action) {
        if (action instanceof GetSikAction) {
            this.sik = ((GetSikAction)action).getSik();
        } else if (!(action instanceof MessageAction)) {
            this.lastAction = action;
            if (action instanceof ErrorAction) {
                this.lastAction = action;
            }
        } else {
            Ipmiv20Message message = ((MessageAction)action).getIpmiv20Message();
            MessageHandler messageHandler = this.messageHandlers.get((Object)message.getPayloadType());
            messageHandler.handleIncomingMessage(message);
        }
    }

    @Override
    public void run() {
        int result = -1;
        do {
            try {
                if (!this.isSessionValid()) break;
                result = this.sendMessage(new GetChannelAuthenticationCapabilities(IpmiVersion.V20, IpmiVersion.V20, ((SessionValid)this.stateMachine.getCurrent()).getCipherSuite(), PrivilegeLevel.Callback, TypeConverter.intToByte(14)), this.isKeepAlive());
            }
            catch (ConnectionException ce) {
                Thread.yield();
            }
        } while (result <= 0);
    }

    public boolean isSessionValid() {
        return this.stateMachine.getCurrent() instanceof SessionValid;
    }

    public int getNextSessionSequenceNumber() throws ConnectionException {
        int result = this.currentSessionSequenceNumber.incrementAndGet() % 0x1FFFFFFF;
        if (result == 0) {
            throw new ConnectionException("Session sequence number overload. Reset session.");
        }
        return result;
    }

    public int sendRmcpPingMessage() throws ConnectionException {
        this.lastAction = null;
        if (this.stateMachine.getCurrent().getClass() != Uninitialized.class) {
            throw new ConnectionException(this.stateMachine.getCurrent());
        }
        this.stateMachine.doTransition(new SendRmcpPingMessage());
        for (int time = 0; time < 1000 && this.lastAction == null; ++time) {
            try {
                Thread.sleep(1L);
                continue;
            }
            catch (InterruptedException ie) {
                throw new ConnectionException("Interrupt to wait for response.");
            }
        }
        ResponseRmcpAction action = (ResponseRmcpAction)this.lastAction;
        if (action == null) {
            throw new ConnectionException("RMCP ping fail.");
        }
        byte[] rmcp = action.getRmcpResponseData().getData();
        byte[] byteArray = new byte[]{rmcp[15], rmcp[14], 0, 0};
        return TypeConverter.byteArrayToInt(byteArray);
    }

    public int getHandle() {
        return this.handle;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
        for (MessageHandler messageHandler : this.messageHandlers.values()) {
            messageHandler.setTimeout(timeout);
        }
    }

    public InetAddress getRemoteMachineAddress() {
        return this.stateMachine.getRemoteMachineAddress();
    }

    public int getRemoteMachinePort() {
        return this.stateMachine.getRemoteMachinePort();
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }
}

