/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.vxipmi.sm;

import com.veraxsystems.vxipmi.coding.rmcp.RmcpDecoder;
import com.veraxsystems.vxipmi.connection.ConnectionException;
import com.veraxsystems.vxipmi.sm.MachineObserver;
import com.veraxsystems.vxipmi.sm.actions.StateMachineAction;
import com.veraxsystems.vxipmi.sm.events.StateMachineEvent;
import com.veraxsystems.vxipmi.sm.states.SessionValid;
import com.veraxsystems.vxipmi.sm.states.State;
import com.veraxsystems.vxipmi.sm.states.Uninitialized;
import com.veraxsystems.vxipmi.transport.Messenger;
import com.veraxsystems.vxipmi.transport.UdpListener;
import com.veraxsystems.vxipmi.transport.UdpMessage;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;

public final class StateMachine
implements UdpListener {
    private List<MachineObserver> observers;
    private State current;
    private Messenger messenger;
    private InetAddress remoteMachineAddress;
    private int remoteMachinePort;
    private boolean initialized;

    public StateMachine(Messenger messenger) {
        this.messenger = messenger;
        this.observers = new ArrayList<MachineObserver>();
        this.initialized = false;
    }

    public State getCurrent() {
        return this.current;
    }

    public void setCurrent(State current) {
        this.current = current;
        current.onEnter(this);
    }

    public void sendMessage(byte[] message) throws IOException {
        UdpMessage udpMessage = new UdpMessage();
        udpMessage.setAddress(this.getRemoteMachineAddress());
        udpMessage.setPort(this.getRemoteMachinePort());
        udpMessage.setMessage(message);
        this.messenger.send(udpMessage);
    }

    public InetAddress getRemoteMachineAddress() {
        return this.remoteMachineAddress;
    }

    public int getRemoteMachinePort() {
        return this.remoteMachinePort;
    }

    public void doExternalAction(StateMachineAction action) {
        for (MachineObserver observer : this.observers) {
            if (observer == null) continue;
            observer.notify(action);
        }
    }

    public void start(InetAddress address, int port) {
        this.messenger.register(this);
        this.remoteMachineAddress = address;
        this.remoteMachinePort = port;
        this.setCurrent(new Uninitialized());
        this.initialized = true;
    }

    public void stop() {
        this.messenger.unregister(this);
        this.initialized = false;
    }

    public boolean isActive() {
        return this.initialized;
    }

    public void doTransition(StateMachineEvent event) throws ConnectionException {
        if (!this.initialized) {
            throw new ConnectionException("State machine not started.");
        }
        this.current.doTransition(this, event);
    }

    @Override
    public void notifyMessage(UdpMessage message) {
        if (message.getAddress().equals(this.getRemoteMachineAddress()) && message.getPort() == this.getRemoteMachinePort() && message.getMessage().length > 4 && this.current != null) {
            this.current.doAction(this, RmcpDecoder.decode(message.getMessage()));
        }
    }

    public void register(MachineObserver observer) {
        this.observers.add(observer);
    }

    public boolean isSessionChallenging() {
        return !this.initialized || this.getCurrent().getClass() == SessionValid.class;
    }
}

