/*
 * Decompiled with CFR 0.152.
 */
package org.seamless.util.logging;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingUtil {
    public static final String DEFAULT_CONFIG = "default-logging.properties";

    public static void loadDefaultConfiguration() throws Exception {
        LoggingUtil.loadDefaultConfiguration(null);
    }

    public static void loadDefaultConfiguration(InputStream is) throws Exception {
        if (System.getProperty("java.util.logging.config.file") != null) {
            return;
        }
        if (is == null) {
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream(DEFAULT_CONFIG);
        }
        if (is == null) {
            return;
        }
        ArrayList<String> handlerNames = new ArrayList<String>();
        LogManager.getLogManager().readConfiguration(LoggingUtil.spliceHandlers(is, handlerNames));
        Handler[] handlers = LoggingUtil.instantiateHandlers(handlerNames);
        LoggingUtil.resetRootHandler(handlers);
    }

    public static Handler[] instantiateHandlers(List<String> handlerNames) throws Exception {
        ArrayList<Handler> list = new ArrayList<Handler>();
        for (String handlerName : handlerNames) {
            list.add((Handler)Thread.currentThread().getContextClassLoader().loadClass(handlerName).newInstance());
        }
        return list.toArray(new Handler[list.size()]);
    }

    public static InputStream spliceHandlers(InputStream is, List<String> handlers) throws IOException {
        Properties props = new Properties();
        props.load(is);
        StringBuilder sb = new StringBuilder();
        ArrayList<String> handlersProperties = new ArrayList<String>();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            if (entry.getKey().equals("handlers")) {
                handlersProperties.add(entry.getValue().toString());
                continue;
            }
            sb.append(entry.getKey()).append("=").append(entry.getValue()).append("\n");
        }
        for (String handlersProperty : handlersProperties) {
            String[] handlerClasses;
            for (String handlerClass : handlerClasses = handlersProperty.trim().split(" ")) {
                handlers.add(handlerClass.trim());
            }
        }
        return new ByteArrayInputStream(sb.toString().getBytes("ISO-8859-1"));
    }

    public static void resetRootHandler(Handler ... h) {
        Handler[] handlers;
        Logger rootLogger = LogManager.getLogManager().getLogger("");
        for (Handler handler : handlers = rootLogger.getHandlers()) {
            rootLogger.removeHandler(handler);
        }
        for (Handler handler : h) {
            if (handler == null) continue;
            LogManager.getLogManager().getLogger("").addHandler(handler);
        }
    }
}

