/*
 * Decompiled with CFR 0.152.
 */
package Gbt.core.commands;

import Gbt.core.commands.AbstractCommand;
import Gbt.core.commands.AbstractCommandBuilder;
import Gbt.core.commands.CommandInvoker;
import Gbt.core.commands.CommandTask;
import Gbt.core.engines.DefaultTaskManager;
import Gbt.core.engines.EngineThreadPoolFactory;
import Gbt.core.engines.EngineThreadPoolTypes;
import Gbt.core.engines.records.CommandTaskRecords;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class ConcurrentInvoker
implements CommandInvoker {
    private static final String INVOKE_POOL_NAME = "Concurrent Invoker";
    private int invokeCount = 0;
    private int successCount = 0;
    private List<CommandTaskRecords> commandTaskRecords = new ArrayList<CommandTaskRecords>();

    @Override
    public void invoke(AbstractCommandBuilder ... builders) {
        this.invoke(Arrays.asList(builders));
    }

    @Override
    public void invoke(List<AbstractCommandBuilder> builderList) {
        ArrayList commandList = new ArrayList();
        for (AbstractCommandBuilder abstractCommandBuilder : builderList) {
            commandList.add(abstractCommandBuilder.build());
        }
        this.successCount = 0;
        this.commandTaskRecords.clear();
        this.invokeCount = commandList.size();
        int checkCount = 0;
        for (AbstractCommand abstractCommand : commandList) {
            if (!abstractCommand.checkAll()) {
                try {
                    abstractCommand.close();
                    continue;
                }
                catch (Exception exception) {
                    break;
                }
            }
            ++checkCount;
        }
        if (checkCount != this.invokeCount) {
            return;
        }
        DefaultTaskManager defaultTaskManager = new DefaultTaskManager(((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName(INVOKE_POOL_NAME)).setThreadNumber(this.invokeCount)).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build());
        for (AbstractCommand abstractCommand : commandList) {
            defaultTaskManager.addEngineTask(new CommandTask(abstractCommand));
        }
        if (!defaultTaskManager.executeTasks()) {
            for (String string : defaultTaskManager.getAllResults().keySet()) {
                this.commandTaskRecords.add((CommandTaskRecords)defaultTaskManager.getSingleResult(string));
            }
            try {
                defaultTaskManager.close();
                commandList.clear();
                commandList = null;
            }
            catch (Exception exception) {
                Object var4_8 = null;
            }
            return;
        }
        for (String string : defaultTaskManager.getAllResults().keySet()) {
            CommandTaskRecords records = (CommandTaskRecords)defaultTaskManager.getAllResults().get(string);
            this.commandTaskRecords.add(records);
            if (!records.getStates().isPass()) continue;
            ++this.successCount;
        }
        try {
            defaultTaskManager.close();
            commandList.clear();
            commandList = null;
        }
        catch (Exception exception) {
            Object var4_9 = null;
        }
    }

    @Override
    public int getTotalCount() {
        return this.invokeCount;
    }

    @Override
    public int getSuccessCount() {
        return this.successCount;
    }

    @Override
    public List<CommandTaskRecords> getCommandTaskRecords() {
        return this.commandTaskRecords;
    }
}

