/*
 * Decompiled with CFR 0.152.
 */
package Gbt.core.engines;

import Gbt.core.engines.AbstractEngineThreadFactory;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;

public final class EngineThreadPoolFactory
extends AbstractEngineThreadFactory {
    private EngineThreadPoolFactory(FactoryBuilder builder) {
        super(builder);
    }

    @Override
    public ExecutorService createThreadPool() {
        switch (this.poolType.getCode()) {
            case 0: {
                return Executors.newSingleThreadExecutor(this);
            }
            case 1: {
                return Executors.newCachedThreadPool(this);
            }
            case 2: {
                return Executors.newFixedThreadPool(this.threadNumbers, this);
            }
        }
        return Executors.newCachedThreadPool(this);
    }

    @Override
    public ScheduledExecutorService createScheduledThreadPool() {
        return Executors.newScheduledThreadPool(this.threadNumbers, this);
    }

    public static final class FactoryBuilder
    extends AbstractEngineThreadFactory.ThreadFactoryBuilder<FactoryBuilder> {
        public FactoryBuilder() {
            this.poolName = "EnginePool";
        }

        @Override
        protected FactoryBuilder getThis() {
            return this;
        }

        @Override
        public EngineThreadPoolFactory build() {
            return new EngineThreadPoolFactory(this);
        }
    }
}

