/*
 * Decompiled with CFR 0.152.
 */
package Gbt.core.ipmi;

import Gbt.core.ipmi.GbtIpmiCommandResponseData;
import com.veraxsystems.vxipmi.coding.commands.IpmiCommandCoder;
import com.veraxsystems.vxipmi.coding.commands.IpmiVersion;
import com.veraxsystems.vxipmi.coding.payload.CompletionCode;
import com.veraxsystems.vxipmi.coding.payload.lan.IPMIException;
import com.veraxsystems.vxipmi.coding.payload.lan.IpmiLanMessage;
import com.veraxsystems.vxipmi.coding.payload.lan.IpmiLanRequest;
import com.veraxsystems.vxipmi.coding.payload.lan.IpmiLanResponse;
import com.veraxsystems.vxipmi.coding.payload.lan.NetworkFunction;
import com.veraxsystems.vxipmi.coding.protocol.AuthenticationType;
import com.veraxsystems.vxipmi.coding.protocol.IpmiMessage;
import com.veraxsystems.vxipmi.coding.security.CipherSuite;
import com.veraxsystems.vxipmi.common.TypeConverter;

public class GbtIpmiCommandCoder
extends IpmiCommandCoder {
    private byte NetFn;
    private byte CommandCode;
    private byte[] RequestData;

    public GbtIpmiCommandCoder(CipherSuite cipherSuite, byte NetFn, byte CommandCode, byte[] RequestData) {
        super(IpmiVersion.V20, cipherSuite, AuthenticationType.RMCPPlus);
        this.NetFn = NetFn;
        this.CommandCode = CommandCode;
        this.RequestData = RequestData;
    }

    @Override
    protected IpmiLanMessage preparePayload(int sequenceNumber) {
        if (this.NetFn == 6 && this.CommandCode == 52) {
            byte originalByte = this.RequestData[5];
            this.RequestData[5] = (byte)((sequenceNumber & 0xFFFFFFFF) << 2);
            int n = this.RequestData.length - 1;
            this.RequestData[n] = (byte)(this.RequestData[n] - (this.RequestData[5] - originalByte));
        }
        return new IpmiLanRequest(this.getNetworkFunction(), this.CommandCode, this.RequestData, TypeConverter.intToByte(sequenceNumber));
    }

    @Override
    public byte getCommandCode() {
        return this.CommandCode;
    }

    @Override
    public NetworkFunction getNetworkFunction() {
        return NetworkFunction.parseInt(this.NetFn);
    }

    @Override
    public GbtIpmiCommandResponseData getResponseData(IpmiMessage message) throws IllegalArgumentException, IPMIException {
        if (!(message.getPayload() instanceof IpmiLanResponse)) {
            throw new IllegalArgumentException("Invalid response payload");
        }
        CompletionCode completionCode = ((IpmiLanResponse)message.getPayload()).getCompletionCode();
        switch (completionCode) {
            case Ok: {
                return new GbtIpmiCommandResponseData(message.getPayload().getIpmiCommandData()).setCompletionCode(((IpmiLanResponse)message.getPayload()).getCompletionCode());
            }
            case DataNotPresent: {
                return new GbtIpmiCommandResponseData(message.getPayload().getIpmiCommandData()).setCompletionCode(((IpmiLanResponse)message.getPayload()).getCompletionCode());
            }
        }
        throw new IPMIException(((IpmiLanResponse)message.getPayload()).getCompletionCode());
    }
}

