/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.API;

import Gbt.core.commands.AbstractCommand;
import Gbt.core.commands.AbstractCommandBuilder;
import Gbt.core.commands.ConcurrentInvoker;
import Gbt.core.engines.records.CommandTaskRecords;
import Gbt.core.engines.records.EngineRecordStates;
import Gbt.core.ipmi.GbtIPMIConnector;
import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.core.loggers.AbstractLoggerWriter;
import Gbt.core.receivers.GbtIPMICommandReceiver;
import Gbt.utility.Common.GbtCommonConverters;
import Gbt.utility.MSR.MsrIpmiOptions;
import Gbt.utility.MSR.NodeManagementData;
import Gbt.utility.Update.MainUpdateCommand;
import Gbt.utility.Update.PreUpdateCommand;
import Gbt.utility.bmcinfo.BMCVendor;
import Gbt.utility.rmc.RMCRole;
import Gbt.utility.scan.ScanCommand;
import Gbt.utility.scan.ScanResultsData;
import com.veraxsystems.vxipmi.api.async.ConnectionHandle;
import com.veraxsystems.vxipmi.coding.commands.chassis.GetChassisStatusResponseData;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public final class GbtUtilityAPI2 {
    private GbtUtilityAPI2() {
    }

    public static final List<String> scan(String startIP, String endIP) {
        ScanCommand command = new ScanCommand.Builder().setStartIP(startIP).setEndIP(endIP).isPingOnly(true).build();
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return null;
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return null;
        }
        try {
            command.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            return null;
        }
        ArrayList<String> ipList = new ArrayList<String>();
        for (AbstractJSONPOJO result : command.getCommandResults()) {
            ipList.add(result.castConcreteJSON(ScanResultsData.class).getBmcIpAddress());
        }
        return ipList;
    }

    public static final CommandTaskRecords commonCommand(AbstractCommandBuilder builder) {
        ConcurrentInvoker invoker = new ConcurrentInvoker();
        invoker.invoke(builder);
        return invoker.getCommandTaskRecords().get(0);
    }

    public static final List<CommandTaskRecords> commonCommands(List<AbstractCommandBuilder> builderList) {
        ConcurrentInvoker invoker = new ConcurrentInvoker();
        invoker.invoke(builderList);
        return invoker.getCommandTaskRecords();
    }

    public static final boolean releaseConnections() {
        try {
            GbtIPMICommandReceiver.getInstance().close();
            GbtIPMICommandReceiver.getInstance().closeReceivers();
            GbtIPMIConnector.disconnect();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static final CommandTaskRecords preUpdateCommand(PreUpdateCommand.Builder builder, AbstractLoggerWriter loggerwriter) {
        PreUpdateCommand preUpdateCommand = ((PreUpdateCommand.Builder)builder.setLoggerWriter(loggerwriter)).setAuto(true).build();
        CommandTaskRecords record = new CommandTaskRecords(preUpdateCommand);
        if (!((AbstractCommand)preUpdateCommand).checkAll()) {
            try {
                preUpdateCommand.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        if (!((AbstractCommand)preUpdateCommand).execute()) {
            try {
                preUpdateCommand.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        try {
            preUpdateCommand.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            return record.setStates(EngineRecordStates.Fail);
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final CommandTaskRecords mainUpdateCommand(MainUpdateCommand.Builder builder, AbstractLoggerWriter loggerwriter) {
        MainUpdateCommand updateCommand = ((MainUpdateCommand.Builder)builder.setLoggerWriter(loggerwriter)).build();
        CommandTaskRecords record = new CommandTaskRecords(updateCommand);
        if (!((AbstractCommand)updateCommand).checkAll()) {
            try {
                updateCommand.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        if (!((AbstractCommand)updateCommand).execute()) {
            try {
                updateCommand.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        try {
            updateCommand.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            return record.setStates(EngineRecordStates.Fail);
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final Boolean checkNMSupport(String bmcIP, String userName, String password) {
        NullJSONData temp;
        String commandName = "checkNMSupport";
        String commandID = bmcIP + "_" + commandName;
        GbtIPMICommandReceiver ipmiReceiver = GbtIPMICommandReceiver.getInstance();
        ConnectionHandle handle = ipmiReceiver.createIPMIConnection(bmcIP, userName, password, commandName, commandID);
        if (handle == null) {
            return null;
        }
        AbstractJSONPOJO resp = ipmiReceiver.sendIPMIRawCommand(handle, MsrIpmiOptions.GET_NODE_MANAGEMENT_DATA, null, commandName, commandID);
        if (resp instanceof NullJSONData && (temp = resp.castConcreteJSON(NullJSONData.class)).isError()) {
            ipmiReceiver.closeIPMIConnection(handle, commandName, commandID);
            return null;
        }
        if (!resp.castConcreteJSON(NodeManagementData.class).getNMSupport().booleanValue()) {
            ipmiReceiver.closeIPMIConnection(handle, commandName, commandID);
            return Boolean.FALSE;
        }
        ipmiReceiver.closeIPMIConnection(handle, commandName, commandID);
        return Boolean.TRUE;
    }

    public static final Boolean checkPowerStatus(String bmcIP, String userName, String password) {
        String commandName = "checkPowerStatus";
        String commandID = bmcIP + "_" + commandName;
        GbtIPMICommandReceiver ipmiReceiver = GbtIPMICommandReceiver.getInstance();
        ConnectionHandle handle = ipmiReceiver.createIPMIConnection(bmcIP, userName, password, commandName, commandID);
        if (handle == null) {
            return null;
        }
        GetChassisStatusResponseData status = ipmiReceiver.getChassisPowerStates(handle, commandName, commandID);
        if (!status.isPowerOn()) {
            ipmiReceiver.closeIPMIConnection(handle, commandName, commandID);
            return Boolean.FALSE;
        }
        ipmiReceiver.closeIPMIConnection(handle, commandName, commandID);
        return Boolean.TRUE;
    }

    public static final Boolean getPEFGlobalAlert(String bmcIP, String userName, String password) {
        String commandName = "getPEFGlobalAlert";
        String commandID = bmcIP + "_" + commandName;
        GbtIPMICommandReceiver ipmiReceiver = GbtIPMICommandReceiver.getInstance();
        ConnectionHandle handle = ipmiReceiver.createIPMIConnection(bmcIP, userName, password, commandName, commandID);
        if (handle == null) {
            return null;
        }
        Boolean result = ipmiReceiver.getGlobalAlertEnable(handle, commandName, commandID);
        ipmiReceiver.closeIPMIConnection(handle, commandName, commandID);
        return result;
    }

    public static final boolean setPEFGlobalAlert(String bmcIP, String userName, String password, boolean enable) {
        String commandName = "setPEFGlobalAlert";
        String commandID = bmcIP + "_" + commandName;
        GbtIPMICommandReceiver ipmiReceiver = GbtIPMICommandReceiver.getInstance();
        ConnectionHandle handle = ipmiReceiver.createIPMIConnection(bmcIP, userName, password, commandName, commandID);
        if (handle == null) {
            return false;
        }
        boolean result = ipmiReceiver.setGlobalAlertEnable(handle, enable, commandName, commandID);
        ipmiReceiver.closeIPMIConnection(handle, commandName, commandID);
        return result;
    }

    public static final CommandTaskRecords scanAPI(String userName, String password, String startIP, String endIP, boolean isPingOnly) {
        ScanCommand scan = new ScanCommand.Builder().setUsername(userName).setPassword(password).setStartIP(startIP).setEndIP(endIP).isPingOnly(isPingOnly).setScanType(ScanCommand.ScanType.RMCP).build();
        CommandTaskRecords record = new CommandTaskRecords(scan);
        if (!scan.checkAll()) {
            try {
                scan.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        if (!scan.execute()) {
            try {
                scan.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        try {
            scan.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return record.setStates(EngineRecordStates.Fail);
    }

    public static final BMCVendor getBMCVendor(String bmcIP, String userName, String password) {
        String commandName = "getBMCVendor";
        String commandID = bmcIP + "_" + commandName;
        GbtIPMICommandReceiver ipmiReceiver = GbtIPMICommandReceiver.getInstance();
        ConnectionHandle handle = ipmiReceiver.createIPMIConnection(bmcIP, userName, password, commandName, commandID);
        if (handle == null) {
            return null;
        }
        BMCVendor vendor = ipmiReceiver.getBmcVendor(handle, commandName, commandID);
        ipmiReceiver.closeIPMIConnection(handle, commandName, commandID);
        return vendor;
    }

    public static final RMCRole getRMCRole(String bmcIP, String userName, String password) {
        String commandName = "getRMCRole";
        String commandID = bmcIP + "_" + commandName;
        GbtIPMICommandReceiver ipmiReceiver = GbtIPMICommandReceiver.getInstance();
        ConnectionHandle handle = ipmiReceiver.createIPMIConnection(bmcIP, userName, password, commandName, commandID);
        if (handle == null) {
            return null;
        }
        RMCRole rmcRole = ipmiReceiver.getRMCRoleCommand(handle, commandName, commandID);
        ipmiReceiver.closeIPMIConnection(handle, commandName, commandID);
        return rmcRole;
    }

    public static final String[] getOR20IPMBIP(String rmcIP, String userName, String password, RMCRole rmcRole) {
        String commandName = "getOR20IPMBIP";
        String commandID = rmcIP + "_" + commandName;
        GbtIPMICommandReceiver ipmiReceiver = GbtIPMICommandReceiver.getInstance();
        ConnectionHandle handle = ipmiReceiver.createIPMIConnection(rmcIP, userName, password, commandName, commandID);
        if (handle == null) {
            return null;
        }
        byte[] info = ipmiReceiver.OR20IPMBIPGetCommand(rmcRole, rmcIP, (byte)6, handle, commandName, commandID);
        String another_IPV4 = "0.0.0.0";
        String another_IPV6 = "::";
        if (info.length > 1) {
            another_IPV4 = (info[3] & 0xFF) + "." + (info[4] & 0xFF) + "." + (info[5] & 0xFF) + "." + (info[6] & 0xFF);
            if (info.length > 21) {
                byte[] ipv6info = new byte[16];
                for (int i = 0; i < ipv6info.length; ++i) {
                    ipv6info[i] = info[i + 21];
                }
                another_IPV6 = GbtCommonConverters.bytesToIPv6Address(ipv6info);
            }
        }
        if (!another_IPV6.equals("::")) {
            BigInteger binteger = GbtCommonConverters.ipToBigInteger(another_IPV6);
            another_IPV6 = GbtCommonConverters.BigIntegerToIp(binteger);
        }
        String[] OR20IPArray = new String[]{another_IPV4, another_IPV6};
        ipmiReceiver.closeIPMIConnection(handle, commandName, commandID);
        return OR20IPArray;
    }

    public static final String getGSMAgentIP(String bmcIP, String userName, String password) {
        String agentIP = "";
        String commandName = "getGSMAgentIP";
        String commandID = bmcIP + "_" + commandName;
        GbtIPMICommandReceiver ipmiReceiver = GbtIPMICommandReceiver.getInstance();
        ConnectionHandle handle = ipmiReceiver.createIPMIConnection(bmcIP, userName, password, commandName, commandID);
        if (handle == null) {
            return null;
        }
        byte[] resp = ipmiReceiver.GSMAgentIPGetCommand(handle, commandName, commandID);
        if (resp != null) {
            for (int i = 3; i < 6; ++i) {
                agentIP = agentIP + (resp[i] & 0xFF) + ".";
            }
            agentIP = agentIP + (resp[6] & 0xFF);
        }
        ipmiReceiver.closeIPMIConnection(handle, commandName, commandID);
        return agentIP;
    }
}

