/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.MultiNode;

import Gbt.core.commands.AbstractCommand;
import Gbt.core.commands.AbstractCommandBuilder;
import Gbt.core.commands.GbtCommandBuilders;
import Gbt.core.engines.records.CommandTaskRecords;
import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.jsonapi.JacksonCommonUtil;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.receivers.GbtIPMICommandReceiver;
import Gbt.utility.API.GbtUtilityAPI2;
import Gbt.utility.Common.CommonFunction;
import Gbt.utility.Common.GbtCommonConverters;
import Gbt.utility.MultiNode.MultiNodeData;
import Gbt.utility.MultiNode.openrack.GRackNodeStruct;
import Gbt.utility.MultiNode.openrack.GRackParser;
import Gbt.utility.MultiNode.openrack.NAT64;
import Gbt.utility.MultiNode.openrack.SlotInfo;
import Gbt.utility.MultiNode.openrack.rackStruct;
import Gbt.utility.MultiNode.rmcpPing;
import Gbt.utility.bmcinfo.BMCInfoJSONData;
import Gbt.utility.maclist.LANMacData;
import com.veraxsystems.vxipmi.api.async.ConnectionHandle;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;

public final class GetMultiNodeCommand
extends AbstractCommand<Builder> {
    public static final String COMMAND_NAME = "multinode";
    private static final int DisconnectionCount = 2;
    private static final String DEFALUT_IP = "0.0.0.0";
    private static final short BIGGEST_CB_ID = 7;
    private final GbtIPMICommandReceiver ipmiReceiver;
    private rackStruct rack;
    private ArrayList<GRackNodeStruct> list;

    protected GetMultiNodeCommand(Builder commandArgs) {
        super(commandArgs);
        this.commandID = ((Builder)this.commandArgs).bmcIP + "_" + COMMAND_NAME;
        this.ipmiReceiver = GbtIPMICommandReceiver.getInstance();
    }

    @Override
    public void close() throws Exception {
        ((Builder)this.commandArgs).close();
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String getDocumentsName() {
        return COMMAND_NAME;
    }

    @Override
    public boolean checkAll() {
        if (!((Builder)this.commandArgs).checkArgs()) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Command arguments check fail.");
            return false;
        }
        if (this.ipmiReceiver == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI receiver is null.");
            return false;
        }
        return true;
    }

    @Override
    public boolean execute() {
        ConnectionHandle handle = this.ipmiReceiver.createIPMIConnection(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword, COMMAND_NAME, this.commandID);
        if (handle == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI connection fail.");
            return false;
        }
        CommandTaskRecords report = GbtUtilityAPI2.commonCommand(GbtCommandBuilders.mcinfo(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword));
        AbstractJSONPOJO data = report.getResultData().get(0);
        if (data instanceof NullJSONData) {
            NullJSONData temp = data.castConcreteJSON(NullJSONData.class);
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + temp.getMessages());
            this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
            return false;
        }
        BMCInfoJSONData bmcInfo = data.castConcreteJSON(BMCInfoJSONData.class);
        if (!bmcInfo.isCMC()) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] multinode command no supported BMC.");
            this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
            return false;
        }
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Start to get all node information by " + (Object)((Object)bmcInfo.getProductName()) + ".");
        this.rack = new rackStruct();
        this.rack.rackVersion = "2.5";
        this.rack.rackType = "full";
        this.rack.init();
        this.rack.RMC_AM_IP = ((Builder)this.commandArgs).bmcIP;
        this.rack.RMC_BS_IP = ((Builder)this.commandArgs).bmcIP;
        String exeIP = DEFALUT_IP;
        if (this.rack.rackVersion.equals("2.0") || this.rack.rackVersion.equals("2.5")) {
            rmcpPing rpingA = null;
            rmcpPing rpingB = null;
            if (!this.rack.RMC_AM_IP.equals(DEFALUT_IP)) {
                rpingA = new rmcpPing(this.rack.RMC_AM_IP);
                rpingA.run();
            }
            if (!this.rack.RMC_BS_IP.equals(DEFALUT_IP)) {
                rpingB = new rmcpPing(this.rack.RMC_BS_IP);
                rpingB.run();
            }
            if (rpingA != null && rpingA.isgotIP()) {
                exeIP = this.rack.RMC_AM_IP;
            } else if (rpingB != null && rpingB.isgotIP()) {
                exeIP = this.rack.RMC_BS_IP;
            }
            if (exeIP.equals(DEFALUT_IP)) {
                this.rack.presence = true;
                if (true) {
                    if (this.rack.presenceCount == 2) {
                        this.rack.presence = false;
                        this.rack.presenceCount = 0;
                        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] disconnected.");
                    } else {
                        ++this.rack.presenceCount;
                    }
                }
            } else {
                if (!this.rack.presence) {
                    this.rack.presence = true;
                    this.rack.presenceCount = 0;
                    this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] reconnected.");
                } else {
                    this.rack.presenceCount = 0;
                }
                this.getRackEXNodeInfo(handle, exeIP);
            }
        } else if (this.rack.rackVersion.contains("Standard with CMC")) {
            exeIP = this.rack.RMC_AM_IP;
            this.getRackEXNodeInfo(handle, exeIP);
        }
        for (SlotInfo slotInfo : this.rack.slotInfo) {
            if (slotInfo.position.equals("")) continue;
            MultiNodeData multiNodeData = new MultiNodeData();
            multiNodeData.setPosition(slotInfo.position);
            multiNodeData.setBmcMAC(slotInfo.BMCMAC);
            multiNodeData.setBmcIP(slotInfo.BMCIP);
            LANMacData lanMacData = new LANMacData();
            for (int i = 0; i < slotInfo.nodeMAC.length; ++i) {
                lanMacData.setLANMacByID(slotInfo.nodeMAC[i], i + 1);
            }
            multiNodeData.setLanMacData(lanMacData);
            this.commandResults.add(multiNodeData);
        }
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, JacksonCommonUtil.getUtil().getPrettyPrintString(this.commandResults));
        this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
        return true;
    }

    @Override
    public void cancelHook(Object obj) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getRackEXNodeInfo(ConnectionHandle handle, String rmcIP) {
        this.GRackMgrGetNodeData(handle, rmcIP);
        rackStruct rackStruct2 = this.rack;
        synchronized (rackStruct2) {
            NAT64 nat64 = null;
            if (this.rack.NAT64Method) {
                nat64 = new NAT64(this.rack.RMC_AM_IP);
            }
            for (GRackNodeStruct node : this.list) {
                if (node.getId() <= 7 && node.getType() == 3) {
                    if (!node.getIpaddr().equals(DEFALUT_IP)) {
                        if (this.rack.NAT64Method) {
                            this.rack.CB_IP64[node.getSlotArrayIndex()] = nat64.MixedNAT64Prefix(node.getIpaddr());
                        }
                        this.rack.CB_IP[node.getSlotArrayIndex()] = node.getIpaddr();
                    }
                    if (node.getIpv6addr().equals("::")) continue;
                    this.rack.CB_IPv6[node.getSlotArrayIndex()] = node.getIpv6addr();
                    continue;
                }
                if (this.rack.NAT64Method) {
                    this.rack.Slot_IP64[node.getSlotArrayIndex()] = nat64.MixedNAT64Prefix(node.getIpaddr());
                }
                this.rack.Slot_IP[node.getSlotArrayIndex()] = node.getIpaddr();
                this.rack.slotInfo[node.getSlotArrayIndex()].BMCVersion = node.getFwversString();
                this.rack.slotInfo[node.getSlotArrayIndex()].BIOSVersion = node.getBiosversString();
                this.rack.slotInfo[node.getSlotArrayIndex()].BMCIP = node.getIpaddr();
                this.rack.slotInfo[node.getSlotArrayIndex()].BMCMAC = node.getMacaddr().replace(":", "").toLowerCase();
                this.rack.slotInfo[node.getSlotArrayIndex()].nodeMAC[0] = node.getLan1macaddr().replace(":", "").toLowerCase();
                this.rack.slotInfo[node.getSlotArrayIndex()].nodeMAC[1] = node.getLan2macaddr().replace(":", "").toLowerCase();
                this.rack.slotInfo[node.getSlotArrayIndex()].nodeMAC[2] = node.getLan3macaddr().replace(":", "").toLowerCase();
                this.rack.slotInfo[node.getSlotArrayIndex()].nodeMAC[3] = node.getLan4macaddr().replace(":", "").toLowerCase();
                switch (this.rack.rackVersion) {
                    case "2.0": {
                        this.rack.slotInfo[node.getSlotArrayIndex()].position = GbtCommonConverters.OR20IDtoPosition(node.getId());
                        break;
                    }
                    case "2.5": {
                        this.rack.slotInfo[node.getSlotArrayIndex()].position = GbtCommonConverters.OR25IDtoPosition(node.getId());
                        break;
                    }
                    case "OCP": {
                        this.rack.slotInfo[node.getSlotArrayIndex()].position = GbtCommonConverters.OCPIDtoPosition(node.getId());
                        break;
                    }
                    default: {
                        this.rack.slotInfo[node.getSlotArrayIndex()].position = GbtCommonConverters.OR20IDtoPosition(node.getId());
                    }
                }
                if (!node.getIpv6addr().equals("::")) {
                    this.rack.slotInfo[node.getSlotArrayIndex()].BMCIPv6 = node.getIpv6addr();
                }
                if (node.getIpv6addr().equals("::")) continue;
                this.rack.Slot_IPv6[node.getSlotArrayIndex()] = node.getIpv6addr();
            }
        }
    }

    private boolean GRackMgrGetNodeData(ConnectionHandle handle, String rmcIP) {
        File localfileName = new File("./" + ((Builder)this.commandArgs).bmcIP + "_grack.vol");
        if (this.rmcPublishWrite(handle, true)) {
            CommonFunction.downloadFileFromTFTP(rmcIP, localfileName.getName(), "RackNodeInfo.vol");
            if (!this.rmcPublishWrite(handle, false)) {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, ((Builder)this.commandArgs).bmcIP + " set publish done failed!");
            }
            try {
                GRackParser parser = new GRackParser(localfileName);
                parser.setRackVersion("2.0");
                parser.parser();
                this.list = parser.getnodeDataList();
                localfileName.deleteOnExit();
                return true;
            }
            catch (FileNotFoundException fe) {
                this.list = new ArrayList();
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, ((Builder)this.commandArgs).bmcIP + " File not found.");
                return false;
            }
        }
        this.list = new ArrayList();
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, ((Builder)this.commandArgs).bmcIP + " set publish done failed!");
        return true;
    }

    private boolean rmcPublishWrite(ConnectionHandle handle, boolean write) {
        return this.ipmiReceiver.rmcPublishWrite(handle, new byte[]{10, 60, 0, 67, (byte)(write ? 1 : 0)}, COMMAND_NAME, this.commandID);
    }

    public static final class Builder
    extends AbstractCommandBuilder<Builder> {
        private String bmcIP;
        private String bmcUsername = "admin";
        private String bmcPassword = "password";

        @Override
        public boolean checkArgs() {
            if (this.bmcIP == null) {
                return false;
            }
            return this.args == null || this.args.length == 0;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        public GetMultiNodeCommand build() {
            return new GetMultiNodeCommand(this);
        }

        public Builder setBMCIP(String bmcIP) {
            this.bmcIP = bmcIP;
            return this.getThis();
        }

        public Builder setBMCUsername(String username) {
            this.bmcUsername = username;
            return this.getThis();
        }

        public Builder setBMCPassword(String password) {
            this.bmcPassword = password;
            return this.getThis();
        }

        @Override
        public void close() throws Exception {
            this.args = null;
            this.bmcIP = null;
            this.loggerWriter.close();
        }
    }
}

