/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.MultiNode.openrack;

import Gbt.utility.MultiNode.openrack.GRackNodeStruct;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;

public class GRackParser {
    private DataInputStream dis;
    private ArrayList<GRackNodeStruct> nodeDataList;
    private String rackVersion = "2.0";

    public GRackParser(File s_FilePath) throws FileNotFoundException {
        this.dis = new DataInputStream(new FileInputStream(s_FilePath));
        this.nodeDataList = new ArrayList();
    }

    public void setRackVersion(String rackVersion) {
        this.rackVersion = rackVersion;
    }

    public void parser() {
        try {
            while (this.dis.available() > 0) {
                GRackNodeStruct nodeInfo = new GRackNodeStruct();
                if (this.rackVersion.equals("2.0")) {
                    nodeInfo.set20Id(this.dis.readShort());
                } else if (this.rackVersion.equals("2.5")) {
                    nodeInfo.set25Id(this.dis.readShort());
                } else {
                    nodeInfo.set20Id(this.dis.readShort());
                }
                nodeInfo.setFwvers(this.dis.readShort());
                byte[] biosvers = new byte[4];
                this.dis.read(biosvers, 0, biosvers.length);
                nodeInfo.setBiosvers(biosvers);
                nodeInfo.setType(this.dis.readByte());
                nodeInfo.setSlave_addr(this.dis.readByte());
                nodeInfo.setProduct_id(this.dis.readShort());
                nodeInfo.setIpaddr(this.dis.readInt());
                byte[] ipv6addr = new byte[16];
                this.dis.read(ipv6addr, 0, ipv6addr.length);
                nodeInfo.setIpv6addr(ipv6addr);
                nodeInfo.setNr_children(this.dis.readByte());
                nodeInfo.setFloor(this.dis.readByte());
                nodeInfo.setTimeout_interval(this.dis.readByte());
                byte[] macaddr = new byte[6];
                this.dis.read(macaddr, 0, macaddr.length);
                nodeInfo.setMacaddr(macaddr);
                byte[] lan1macaddr = new byte[6];
                this.dis.read(lan1macaddr, 0, lan1macaddr.length);
                nodeInfo.setLan1macaddr(lan1macaddr);
                byte[] lan2macaddr = new byte[6];
                this.dis.read(lan2macaddr, 0, lan2macaddr.length);
                nodeInfo.setLan2macaddr(lan2macaddr);
                byte[] lan3macaddr = new byte[6];
                this.dis.read(lan3macaddr, 0, lan3macaddr.length);
                nodeInfo.setLan3macaddr(lan3macaddr);
                byte[] lan4macaddr = new byte[6];
                this.dis.read(lan4macaddr, 0, lan4macaddr.length);
                nodeInfo.setLan4macaddr(lan4macaddr);
                nodeInfo.setI2c_mux_port(this.dis.readByte());
                nodeInfo.setNext_brdcmd(this.dis.readByte());
                nodeInfo.setStatus(this.dis.readLong());
                byte[] temperatures = new byte[8];
                this.dis.read(temperatures, 0, temperatures.length);
                nodeInfo.setTemperatures(temperatures);
                byte[] fan_reading = new byte[16];
                this.dis.read(fan_reading, 0, fan_reading.length);
                nodeInfo.setFan_reading(fan_reading);
                byte[] fan_pwm = new byte[8];
                this.dis.read(fan_pwm, 0, fan_pwm.length);
                nodeInfo.setFan_pwm(fan_pwm);
                nodeInfo.setFanLastID(this.dis.readByte());
                byte[] cpu_performance = new byte[2];
                this.dis.read(cpu_performance, 0, cpu_performance.length);
                nodeInfo.setCpu_performance(cpu_performance);
                byte[] power_consumption = new byte[8];
                this.dis.read(power_consumption, 0, power_consumption.length);
                nodeInfo.setPower_consumption(power_consumption);
                nodeInfo.setCpu_watt(this.dis.readByte());
                byte[] padding4 = new byte[9];
                this.dis.read(padding4, 0, padding4.length);
                nodeInfo.setPadding4(padding4);
                this.nodeDataList.add(nodeInfo);
            }
        }
        catch (Exception e) {
            System.out.println("[GRackParser] Exception: " + e);
        }
    }

    public ArrayList<GRackNodeStruct> getnodeDataList() {
        return this.nodeDataList;
    }
}

