/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.PEF;

import Gbt.core.commands.AbstractCommand;
import Gbt.core.commands.AbstractCommandBuilder;
import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.receivers.GbtIPMICommandReceiver;
import Gbt.utility.PEF.PEFEntry;
import Gbt.utility.PEF.PEFIpmiOptions;
import Gbt.utility.PEF.PefActions;
import Gbt.utility.bmcinfo.BMCVendor;
import com.veraxsystems.vxipmi.api.async.ConnectionHandle;
import java.util.ArrayList;
import java.util.List;

public final class PEFCommand
extends AbstractCommand<Builder> {
    public static final String COMMAND_NAME = "pef";
    private static final int FilterTotalNumber = 64;
    private final GbtIPMICommandReceiver ipmiReceiver;

    protected PEFCommand(Builder commandArgs) {
        super(commandArgs);
        this.commandID = ((Builder)this.commandArgs).bmcIP + "_" + COMMAND_NAME;
        this.ipmiReceiver = GbtIPMICommandReceiver.getInstance();
    }

    @Override
    public void close() throws Exception {
        ((Builder)this.commandArgs).close();
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String getDocumentsName() {
        return COMMAND_NAME;
    }

    @Override
    public boolean checkAll() {
        if (!((Builder)this.commandArgs).checkArgs()) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Check arguments fail.");
            return false;
        }
        if (this.ipmiReceiver == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI ipmiReceiver is null.");
            return false;
        }
        return true;
    }

    @Override
    public boolean execute() {
        boolean result = false;
        ConnectionHandle handle = this.ipmiReceiver.createIPMIConnection(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword, COMMAND_NAME, this.commandID);
        if (handle == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI connection fail.");
            return false;
        }
        BMCVendor bmcVendor = this.ipmiReceiver.getBmcVendor(handle, this.getCommandName(), this.commandID);
        switch (bmcVendor) {
            case VERTIV: {
                break;
            }
            case AMI: 
            case OPENBMC: {
                this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Not support on " + bmcVendor.toString() + " FW.");
                return false;
            }
            default: {
                this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Fail to get BMC vendor.");
                return false;
            }
        }
        switch (((Builder)this.commandArgs).option) {
            case GET: {
                result = this.getPEFEntries(handle);
                break;
            }
            case SET: {
                if (((Builder)this.commandArgs).pefTable == null && !this.getPEFEntries(handle)) break;
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                result = this.setPEFEntries(handle);
                if (!result) {
                    this.commandResults.add(new NullJSONData().setError(true).setMessages("Set PEF fail."));
                    break;
                }
                this.commandResults.add(new NullJSONData().setError(false).setMessages("Set PEF success."));
                break;
            }
            default: {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Unsupported option.");
            }
        }
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] PEF command complete.");
        this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
        if (result && ((Builder)this.commandArgs).option == PEFIpmiOptions.GET) {
            for (PEFEntry entry : ((Builder)this.commandArgs).pefTable) {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.TRACE, this.commandID, entry.toString());
            }
        }
        return result;
    }

    private boolean getPEFEntries(ConnectionHandle handle) {
        AbstractJSONPOJO data = null;
        ((Builder)this.commandArgs).pefTable = new ArrayList();
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Starting to get PEF table.");
        for (int i = 0; i < 64; ++i) {
            PEFEntry info;
            ((Builder)this.commandArgs).setFilterNumber(i + 1);
            data = this.ipmiReceiver.sendIPMIRawCommand(handle, PEFIpmiOptions.GET, this.commandArgs, COMMAND_NAME, this.commandID);
            if (data instanceof NullJSONData) {
                NullJSONData temp = data.castConcreteJSON(NullJSONData.class);
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + temp.getMessages());
                this.commandResults.add(temp);
                if (!temp.isError()) continue;
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Get PEF table fail!");
                return false;
            }
            if (!(data instanceof PEFEntry) || !(info = data.castConcreteJSON(PEFEntry.class)).getEnable_filter()) continue;
            this.commandResults.add(info);
            ((Builder)this.commandArgs).pefTable.add(info);
        }
        return true;
    }

    private boolean setPEFEntries(ConnectionHandle handle) {
        AbstractJSONPOJO data = null;
        for (PEFEntry entry : ((Builder)this.commandArgs).pefTable) {
            ((Builder)this.commandArgs).setPEFEntry(entry);
            data = this.ipmiReceiver.sendIPMIRawCommand(handle, PEFIpmiOptions.SET, this.commandArgs, COMMAND_NAME, this.commandID);
            if (!(data instanceof NullJSONData)) continue;
            NullJSONData temp = data.castConcreteJSON(NullJSONData.class);
            this.commandResults.add(temp);
            if (!temp.isError()) continue;
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Set PEF table fail! [" + temp.getMessages() + "]");
            return false;
        }
        return true;
    }

    @Override
    public void cancelHook(Object obj) {
    }

    public static final class Builder
    extends AbstractCommandBuilder<Builder> {
        private String bmcIP;
        private String bmcUsername = "admin";
        private String bmcPassword = "password";
        private PEFIpmiOptions option = null;
        private PefActions pefActions = null;
        private int filterNum = 0;
        private List<PEFEntry> pefTable = null;
        private PEFEntry pefEntry;
        private Boolean enable = null;

        @Override
        public boolean checkArgs() {
            if (this.bmcIP == null) {
                return false;
            }
            if (this.args != null) {
                if (this.args.length == 1 && this.args[0].equalsIgnoreCase("get")) {
                    this.option = PEFIpmiOptions.GET;
                } else if (this.args.length == 3 && this.args[0].equalsIgnoreCase("set")) {
                    this.option = PEFIpmiOptions.SET;
                    this.pefActions = PefActions.parse(this.args[1]);
                    this.enable = this.args[1].equalsIgnoreCase("enable");
                }
                if (this.option == null) {
                    return false;
                }
                if (this.option == PEFIpmiOptions.SET && this.enable == null && this.pefTable == null) {
                    return false;
                }
            }
            return true;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        public PEFCommand build() {
            return new PEFCommand(this);
        }

        public Builder setBMCIP(String bmcIP) {
            this.bmcIP = bmcIP;
            return this.getThis();
        }

        public Builder setBMCUsername(String username) {
            this.bmcUsername = username;
            return this.getThis();
        }

        public Builder setBMCPassword(String password) {
            this.bmcPassword = password;
            return this.getThis();
        }

        public Builder setCommandOption(PEFIpmiOptions option) {
            this.option = option;
            return this.getThis();
        }

        public Builder setPefActions(PefActions pefActions) {
            this.pefActions = pefActions;
            return this.getThis();
        }

        protected PefActions getPefActions() {
            return this.pefActions;
        }

        public Builder setPEFTable(List<PEFEntry> pefTable) {
            this.pefTable = pefTable;
            return this.getThis();
        }

        private void setPEFEntry(PEFEntry entry) {
            this.pefEntry = entry;
        }

        protected PEFEntry getPEFEntry() {
            return this.pefEntry;
        }

        public Builder setEnable(boolean enable) {
            this.enable = enable;
            return this.getThis();
        }

        protected Boolean getEnable() {
            return this.enable;
        }

        private void setFilterNumber(int filterNum) {
            this.filterNum = filterNum;
        }

        protected int getFilterNumber() {
            return this.filterNum;
        }

        @Override
        public void close() throws Exception {
            this.args = null;
            this.bmcIP = null;
            this.bmcUsername = null;
            this.bmcPassword = null;
            this.pefActions = null;
            this.enable = false;
            this.loggerWriter.close();
        }
    }
}

