/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.RAW;

import Gbt.core.commands.AbstractCommand;
import Gbt.core.commands.AbstractCommandBuilder;
import Gbt.core.ipmi.GbtIpmiCommandResponseData;
import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.receivers.GbtIPMICommandReceiver;
import Gbt.utility.Common.GbtCommonConverters;
import Gbt.utility.RAW.CommonIPMIOptions;
import com.veraxsystems.vxipmi.api.async.ConnectionHandle;

public final class IPMIRawCommand
extends AbstractCommand<Builder> {
    public static final String COMMAND_NAME = "raw";
    private final GbtIPMICommandReceiver ipmiReceiver;

    protected IPMIRawCommand(Builder commandArgs) {
        super(commandArgs);
        this.commandID = ((Builder)this.commandArgs).bmcIP + "_" + COMMAND_NAME;
        this.ipmiReceiver = GbtIPMICommandReceiver.getInstance();
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String getDocumentsName() {
        return COMMAND_NAME;
    }

    @Override
    public boolean checkAll() {
        if (!((Builder)this.commandArgs).checkArgs()) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Check arguments fail.");
            return false;
        }
        if (this.ipmiReceiver == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI receiver is null.");
            return false;
        }
        return true;
    }

    @Override
    public boolean execute() {
        ConnectionHandle handle = this.ipmiReceiver.createIPMIConnection(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword, COMMAND_NAME, this.commandID);
        if (handle == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, ((Builder)this.commandArgs).bmcIP + " IPMI connection fail.");
            return false;
        }
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Start to execute IPMI raw command.");
        AbstractJSONPOJO resp = this.ipmiReceiver.sendIPMIRawCommand(handle, CommonIPMIOptions.RawCommand, this.commandArgs, COMMAND_NAME, this.commandID);
        if (resp instanceof NullJSONData) {
            NullJSONData temp = resp.castConcreteJSON(NullJSONData.class);
            if (temp.isError()) {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + temp.getMessages());
                this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                return false;
            }
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + temp.getMessages());
            this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
            return true;
        }
        this.commandResults.add(resp);
        StringBuilder stringBuilder = new StringBuilder();
        for (byte rawByte : resp.castConcreteJSON(GbtIpmiCommandResponseData.class).getAllResponseData()) {
            stringBuilder.append(GbtCommonConverters.bytesToHex(rawByte)).append(" ");
        }
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + stringBuilder.toString());
        stringBuilder.setLength(0);
        this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
        return true;
    }

    @Override
    public void cancelHook(Object obj) {
    }

    @Override
    public void close() throws Exception {
        ((Builder)this.commandArgs).close();
    }

    public static final class Builder
    extends AbstractCommandBuilder<Builder> {
        private String bmcIP;
        private String bmcUsername = "admin";
        private String bmcPassword = "password";
        protected byte[] rawData;

        @Override
        public boolean checkArgs() {
            if (this.bmcIP == null) {
                return false;
            }
            if (this.args != null) {
                if (this.args.length == 0) {
                    return false;
                }
                this.rawData = new byte[this.args.length];
                for (int i = 0; i < this.args.length; ++i) {
                    this.rawData[i] = GbtCommonConverters.stringToByte(this.args[i]);
                }
            }
            return this.rawData != null;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        public IPMIRawCommand build() {
            return new IPMIRawCommand(this);
        }

        @Override
        public void close() throws Exception {
            this.args = null;
            this.bmcIP = null;
            this.bmcUsername = null;
            this.bmcPassword = null;
            this.loggerWriter.close();
        }

        public Builder setBMCIP(String bmcIP) {
            this.bmcIP = bmcIP;
            return this.getThis();
        }

        public Builder setBMCUsername(String username) {
            this.bmcUsername = username;
            return this.getThis();
        }

        public Builder setBMCPassword(String password) {
            this.bmcPassword = password;
            return this.getThis();
        }

        public Builder setRawData(byte[] rawData) {
            this.rawData = rawData;
            return this.getThis();
        }

        public byte getNetFn() {
            return this.rawData[0];
        }

        public byte getCmd() {
            return this.rawData[1];
        }
    }
}

