/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.SDR;

import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.utility.SDR.record.FullSensorRecord;
import Gbt.utility.SDR.record.ReadingType;
import Gbt.utility.SDR.record.SensorState;
import Gbt.utility.SDR.record.SensorType;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.veraxsystems.vxipmi.common.TypeConverter;
import java.util.ArrayList;
import java.util.List;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY)
public final class SdrSensorReadingData
extends AbstractJSONPOJO {
    private byte sensorReading;
    private boolean sensorStateValid;
    private SensorState sensorState;
    private boolean[] statesAsserted;

    @JsonIgnore
    public double getDoubleSensorReading(FullSensorRecord sensorRecord) {
        sensorRecord.setSensorReading(sensorRecord.calcFormula(TypeConverter.byteToInt(this.sensorReading)));
        return sensorRecord.getSensorReading();
    }

    @JsonIgnore
    public double getPlainSensorReading() {
        return TypeConverter.byteToInt(this.sensorReading);
    }

    @JsonIgnore
    public List<ReadingType> getReadingTypes(SensorType sensorType, int sensorEventReadingType) {
        ArrayList<ReadingType> list = new ArrayList<ReadingType>();
        for (int i = 0; i < this.statesAsserted.length; ++i) {
            if (!this.statesAsserted[i]) continue;
            list.add(ReadingType.parseInt(sensorType, sensorEventReadingType, i));
        }
        return list;
    }

    @JsonProperty(value="SensorReading")
    public byte getSensorReading() {
        return this.sensorReading;
    }

    public SdrSensorReadingData setSensorReading(byte sensorReading) {
        this.sensorReading = sensorReading;
        return this;
    }

    @JsonProperty(value="IsSensorStateValid")
    public boolean isSensorStateValid() {
        return this.sensorStateValid;
    }

    public SdrSensorReadingData setSensorStateValid(boolean sensorStateValid) {
        this.sensorStateValid = sensorStateValid;
        return this;
    }

    @JsonProperty(value="SensorState")
    public SensorState getSensorState() {
        return this.sensorState;
    }

    public SdrSensorReadingData setSensorState(SensorState sensorState) {
        this.sensorState = sensorState;
        return this;
    }

    @JsonProperty(value="StatesAsserted")
    public boolean[] getStatesAsserted() {
        return this.statesAsserted;
    }

    public SdrSensorReadingData setStatesAsserted(boolean[] statesAsserted) {
        this.statesAsserted = statesAsserted;
        return this;
    }
}

