/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.SMBIOS;

import com.fasterxml.jackson.annotation.JsonValue;

public enum BaseBoardTypes {
    UNKNOWN(1, "Unknown"),
    OTHER(2, "Other"),
    SERVERBLADE(3, "Server Blade"),
    CONNECTIVITYSWITCH(4, "Connectivity Switch"),
    SYSTEMMANAGEMENT(5, "System Management Module"),
    PROCESSOR(6, "Processor Module"),
    IO(7, "I/O Module"),
    MEMORY(8, "Memory Module"),
    DAUGHTER(9, "Daughter board"),
    MOTHERBOARD(10, "Motherboard (includes processor, memory, and I/O)"),
    PROCESSORMEMORYMODULE(11, "Processor/Memory Module"),
    PROCESSORIOMODULE(12, "Processor I/O Module"),
    INTERCONNECTBOARD(13, "Interconnect board");

    private static final byte CODE_1 = 1;
    private static final byte CODE_2 = 2;
    private static final byte CODE_3 = 3;
    private static final byte CODE_4 = 4;
    private static final byte CODE_5 = 5;
    private static final byte CODE_6 = 6;
    private static final byte CODE_7 = 7;
    private static final byte CODE_8 = 8;
    private static final byte CODE_9 = 9;
    private static final byte CODE_10 = 10;
    private static final byte CODE_11 = 11;
    private static final byte CODE_12 = 12;
    private static final byte CODE_13 = 13;
    private final byte code;
    private final String item;

    private BaseBoardTypes(byte code, String item) {
        this.code = code;
        this.item = item;
    }

    public byte getCode() {
        return this.code;
    }

    @JsonValue
    public String toString() {
        return this.item;
    }

    public static final BaseBoardTypes parse(byte code) {
        switch (code) {
            case 1: {
                return UNKNOWN;
            }
            case 2: {
                return OTHER;
            }
            case 3: {
                return SERVERBLADE;
            }
            case 4: {
                return CONNECTIVITYSWITCH;
            }
            case 5: {
                return SYSTEMMANAGEMENT;
            }
            case 6: {
                return PROCESSOR;
            }
            case 7: {
                return IO;
            }
            case 8: {
                return MEMORY;
            }
            case 9: {
                return DAUGHTER;
            }
            case 10: {
                return MOTHERBOARD;
            }
            case 11: {
                return PROCESSORMEMORYMODULE;
            }
            case 12: {
                return PROCESSORIOMODULE;
            }
            case 13: {
                return INTERCONNECTBOARD;
            }
        }
        return UNKNOWN;
    }
}

