/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.Update;

import Gbt.core.ipmi.GbtIPMIOptions;
import Gbt.core.ipmi.GbtIpmiCommandResponseData;
import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.utility.Common.CommonFunction;
import Gbt.utility.Common.GbtCommonConverters;
import Gbt.utility.Update.MainUpdateCommand;
import Gbt.utility.Update.UpdateStatusJSONData;
import Gbt.utility.Update.fwInfo.BMCUpdateFWInfo;
import Gbt.utility.Update.fwInfo.CPLDUpdateFWInfo;
import Gbt.utility.Update.fwInfo.PSUUpdateFWInfo;
import Gbt.utility.Update.fwInfo.SKUUpdateFWInfo;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

public enum UpdateIPMIOptions implements GbtIPMIOptions<MainUpdateCommand.Builder>
{
    GetUpdateStatus(0, "Get update status", 63),
    BMCUpdatePhaseTransfer(1, "Send BMC update control command phase : transfer FW image.", 62),
    BMCUpdatePhaseProcess(2, "Send BMC update control command phase : update progress.", 62),
    BMCUpdatePhaseStatus(3, "Send BMC update control command phase : status monitor.", 62),
    BIOSUpdatePhaseTransfer(4, "Send BIOS update control command phase : transfer FW image.", 62),
    BIOSUpdatePhaseProcess(5, "Send BIOS update control command phase : update progress.", 62),
    BIOSUpdatePhaseStatus(6, "Send BIOS update control command phase : status monitor.", 62),
    CPLDBPBUpdatePhaseTransfer(7, "Send CPLD BPB update control command phase : transfer FW image.", 62),
    CPLDBPBUpdatePhaseProcess(8, "Send CPLD BPB update control command phase : update progress.", 62),
    CPLDBPBUpdatePhaseStatus(9, "Send CPLD BPB update control command phase : status monitor.", 62),
    CPLDMBUpdatePhaseTransfer(10, "Send CPLD MB update control command phase : transfer FW image.", 62),
    CPLDMBUpdatePhaseProcess(11, "Send CPLD MB update control command phase : update progress.", 62),
    CPLDMBUpdatePhaseStatus(12, "Send CPLD MB update control command phase : status monitor.", 62),
    PSUUpdatePhaseTransfer(13, "Send PSU update control command phase : transfer FW image.", 62),
    PSUUpdatePhaseProcess(14, "Send PSU update control command phase : update progress.", 62),
    PSUUpdatePhaseStatus(15, "Send PSU update control command phase : status monitor.", 62),
    PreserveBMCConfig(19, "Send preserve BMC configuration.", 62),
    SKUUpdatePhaseTransfer(16, "Send SKU update control command phase : transfer FW image.", 62),
    SKUUpdatePhaseProcess(17, "Send SKU update control command phase : update progress.", 62),
    SKUUpdatePhaseStatus(18, "Send SKU update control command phase : status monitor.", 62),
    ClearBMCConfig(20, "Send clear BMC configuration.", 62),
    SetTFTPPort(21, "Set TFTP port of update.", 32),
    GetTFTPPort(22, "Get TFTP port of update : ", 33);

    private static final int UPDATE_STATUSGET_CODE = 0;
    private static final int BMC_UPDATE_PHASE_T_CODE = 1;
    private static final int BMC_UPDATE_PHASE_P_CODE = 2;
    private static final int BMC_UPDATE_PHASE_S_CODE = 3;
    private static final int BIOS_UPDATE_PHASE_T_CODE = 4;
    private static final int BIOS_UPDATE_PHASE_P_CODE = 5;
    private static final int BIOS_UPDATE_PHASE_S_CODE = 6;
    private static final int CPLDBPB_UPDATE_PHASE_T_CODE = 7;
    private static final int CPLDBPB_UPDATE_PHASE_P_CODE = 8;
    private static final int CPLDBPB_UPDATE_PHASE_S_CODE = 9;
    private static final int CPLDMB_UPDATE_PHASE_T_CODE = 10;
    private static final int CPLDMB_UPDATE_PHASE_P_CODE = 11;
    private static final int CPLDMB_UPDATE_PHASE_S_CODE = 12;
    private static final int PSU_UPDATE_PHASE_T_CODE = 13;
    private static final int PSU_UPDATE_PHASE_P_CODE = 14;
    private static final int PSU_UPDATE_PHASE_S_CODE = 15;
    private static final int SKU_UPDATE_PHASE_T_CODE = 16;
    private static final int SKU_UPDATE_PHASE_P_CODE = 17;
    private static final int SKU_UPDATE_PHASE_S_CODE = 18;
    private static final int PRESERVE_BMC_CONFIG_CODE = 19;
    private static final int CLEAR_BMC_CONFIG_CODE = 20;
    private static final int SET_TFTP_PORT_CODE = 21;
    private static final int GET_TFTP_PORT_CODE = 22;
    private static final String UPDATE_STATUSGET_ITEM = "Get update status";
    private static final String BMC_UPDATE_PHASE_T_ITEM = "Send BMC update control command phase : transfer FW image.";
    private static final String BMC_UPDATE_PHASE_P_ITEM = "Send BMC update control command phase : update progress.";
    private static final String BMC_UPDATE_PHASE_S_ITEM = "Send BMC update control command phase : status monitor.";
    private static final String BIOS_UPDATE_PHASE_T_ITEM = "Send BIOS update control command phase : transfer FW image.";
    private static final String BIOS_UPDATE_PHASE_P_ITEM = "Send BIOS update control command phase : update progress.";
    private static final String BIOS_UPDATE_PHASE_S_ITEM = "Send BIOS update control command phase : status monitor.";
    private static final String CPLDBPB_UPDATE_PHASE_T_ITEM = "Send CPLD BPB update control command phase : transfer FW image.";
    private static final String CPLDBPB_UPDATE_PHASE_P_ITEM = "Send CPLD BPB update control command phase : update progress.";
    private static final String CPLDBPB_UPDATE_PHASE_S_ITEM = "Send CPLD BPB update control command phase : status monitor.";
    private static final String CPLDMB_UPDATE_PHASE_T_ITEM = "Send CPLD MB update control command phase : transfer FW image.";
    private static final String CPLDMB_UPDATE_PHASE_P_ITEM = "Send CPLD MB update control command phase : update progress.";
    private static final String CPLDMB_UPDATE_PHASE_S_ITEM = "Send CPLD MB update control command phase : status monitor.";
    private static final String PSU_UPDATE_PHASE_T_ITEM = "Send PSU update control command phase : transfer FW image.";
    private static final String PSU_UPDATE_PHASE_P_ITEM = "Send PSU update control command phase : update progress.";
    private static final String PSU_UPDATE_PHASE_S_ITEM = "Send PSU update control command phase : status monitor.";
    private static final String SKU_UPDATE_PHASE_T_ITEM = "Send SKU update control command phase : transfer FW image.";
    private static final String SKU_UPDATE_PHASE_P_ITEM = "Send SKU update control command phase : update progress.";
    private static final String SKU_UPDATE_PHASE_S_ITEM = "Send SKU update control command phase : status monitor.";
    private static final String PRESERVE_BMC_CONFIG_ITEM = "Send preserve BMC configuration.";
    private static final String CLEAR_BMC_CONFIG_ITEM = "Send clear BMC configuration.";
    private static final String SET_TFTP_PORT_ITEM = "Set TFTP port of update.";
    private static final String GET_TFTP_PORT_ITEM = "Get TFTP port of update : ";
    private static final byte[] ACT_REPORT;
    private static final byte[] ACT_START;
    private static final byte[] ACT_PRESERVE;
    private static final byte[] ACT_CLEAR;
    private static final byte PHASE_T = 1;
    private static final byte PHASE_P = 10;
    private static final byte PHASE_S = 12;
    private static final byte[] FILESIZE;
    private static final byte[] CHECKSUM;
    private static final byte[] IPMI_VER;
    private final int optionCode;
    private final String item;
    private static final byte netFn = 46;
    private final byte cmd;

    private UpdateIPMIOptions(int optionCode, String item, byte cmd) {
        this.optionCode = optionCode;
        this.item = item;
        this.cmd = cmd;
    }

    @Override
    public int getOptionCode() {
        return this.optionCode;
    }

    @Override
    public String getItem() {
        return this.item;
    }

    @Override
    public byte getNetFn() {
        return 46;
    }

    @Override
    public byte getCommandCode() {
        return this.cmd;
    }

    @Override
    public byte[] rebuildRequestData(MainUpdateCommand.Builder commandArgs) {
        switch (this) {
            case GetUpdateStatus: {
                return ACT_REPORT;
            }
            case BMCUpdatePhaseTransfer: {
                return this.updateControlCmdRequestDataBuilder(ACT_START, (byte)1, commandArgs.updateType.getTypeCode(), this.parserProductID(commandArgs.preupdateFWInfo), commandArgs.fwImage, commandArgs.tftpIP);
            }
            case BMCUpdatePhaseProcess: {
                return this.updateControlCmdRequestDataBuilder(ACT_START, (byte)10, commandArgs.updateType.getTypeCode(), this.parserProductID(commandArgs.preupdateFWInfo), commandArgs.fwImage, commandArgs.tftpIP);
            }
            case BMCUpdatePhaseStatus: {
                return this.updateControlCmdRequestDataBuilder(ACT_START, (byte)12, commandArgs.updateType.getTypeCode(), this.parserProductID(commandArgs.preupdateFWInfo), commandArgs.fwImage, commandArgs.tftpIP);
            }
            case BIOSUpdatePhaseTransfer: {
                return this.updateControlCmdRequestDataBuilder(ACT_START, (byte)1, commandArgs.updateType.getTypeCode(), this.parserProductID(commandArgs.preupdateFWInfo), commandArgs.fwImage, commandArgs.tftpIP);
            }
            case BIOSUpdatePhaseProcess: {
                return this.updateControlCmdRequestDataBuilder(ACT_START, (byte)10, commandArgs.updateType.getTypeCode(), this.parserProductID(commandArgs.preupdateFWInfo), commandArgs.fwImage, commandArgs.tftpIP);
            }
            case BIOSUpdatePhaseStatus: {
                return this.updateControlCmdRequestDataBuilder(ACT_START, (byte)12, commandArgs.updateType.getTypeCode(), this.parserProductID(commandArgs.preupdateFWInfo), commandArgs.fwImage, commandArgs.tftpIP);
            }
            case CPLDBPBUpdatePhaseTransfer: {
                return this.updateControlCmdRequestDataBuilder(ACT_START, (byte)1, commandArgs.updateType.getTypeCode(), this.parserProductID(commandArgs.preupdateFWInfo), commandArgs.fwImage, commandArgs.tftpIP);
            }
            case CPLDBPBUpdatePhaseProcess: {
                return this.updateControlCmdRequestDataBuilder(ACT_START, (byte)10, commandArgs.updateType.getTypeCode(), this.parserProductID(commandArgs.preupdateFWInfo), commandArgs.fwImage, commandArgs.tftpIP);
            }
            case CPLDBPBUpdatePhaseStatus: {
                return this.updateControlCmdRequestDataBuilder(ACT_START, (byte)12, commandArgs.updateType.getTypeCode(), this.parserProductID(commandArgs.preupdateFWInfo), commandArgs.fwImage, commandArgs.tftpIP);
            }
            case CPLDMBUpdatePhaseTransfer: {
                return this.updateControlCmdRequestDataBuilder(ACT_START, (byte)1, commandArgs.updateType.getTypeCode(), this.parserProductID(commandArgs.preupdateFWInfo), commandArgs.fwImage, commandArgs.tftpIP);
            }
            case CPLDMBUpdatePhaseProcess: {
                return this.updateControlCmdRequestDataBuilder(ACT_START, (byte)10, commandArgs.updateType.getTypeCode(), this.parserProductID(commandArgs.preupdateFWInfo), commandArgs.fwImage, commandArgs.tftpIP);
            }
            case CPLDMBUpdatePhaseStatus: {
                return this.updateControlCmdRequestDataBuilder(ACT_START, (byte)12, commandArgs.updateType.getTypeCode(), this.parserProductID(commandArgs.preupdateFWInfo), commandArgs.fwImage, commandArgs.tftpIP);
            }
            case PSUUpdatePhaseTransfer: {
                return this.updateControlCmdRequestDataBuilder(ACT_START, (byte)1, commandArgs.updateType.getTypeCode(), this.parserProductID(commandArgs.preupdateFWInfo), commandArgs.fwImage, commandArgs.tftpIP);
            }
            case PSUUpdatePhaseProcess: {
                return this.updateControlCmdRequestDataBuilder(ACT_START, (byte)10, commandArgs.updateType.getTypeCode(), this.parserProductID(commandArgs.preupdateFWInfo), commandArgs.fwImage, commandArgs.tftpIP);
            }
            case PSUUpdatePhaseStatus: {
                return this.updateControlCmdRequestDataBuilder(ACT_START, (byte)12, commandArgs.updateType.getTypeCode(), this.parserProductID(commandArgs.preupdateFWInfo), commandArgs.fwImage, commandArgs.tftpIP);
            }
            case SKUUpdatePhaseTransfer: {
                return this.updateControlCmdRequestDataBuilder(ACT_START, (byte)1, commandArgs.updateType.getTypeCode(), this.parserProductID(commandArgs.preupdateFWInfo), commandArgs.fwImage, commandArgs.tftpIP);
            }
            case SKUUpdatePhaseProcess: {
                return this.updateControlCmdRequestDataBuilder(ACT_START, (byte)10, commandArgs.updateType.getTypeCode(), this.parserProductID(commandArgs.preupdateFWInfo), commandArgs.fwImage, commandArgs.tftpIP);
            }
            case SKUUpdatePhaseStatus: {
                return this.updateControlCmdRequestDataBuilder(ACT_START, (byte)12, commandArgs.updateType.getTypeCode(), this.parserProductID(commandArgs.preupdateFWInfo), commandArgs.fwImage, commandArgs.tftpIP);
            }
            case PreserveBMCConfig: {
                return this.updateControlCmdRequestDataBuilder(ACT_PRESERVE, (byte)12, commandArgs.updateType.getTypeCode(), this.parserProductID(commandArgs.preupdateFWInfo), commandArgs.fwImage, commandArgs.tftpIP);
            }
            case ClearBMCConfig: {
                return this.updateControlCmdRequestDataBuilder(ACT_CLEAR, (byte)12, commandArgs.updateType.getTypeCode(), this.parserProductID(commandArgs.preupdateFWInfo), commandArgs.fwImage, commandArgs.tftpIP);
            }
            case SetTFTPPort: {
                return this.tftpPortCmdRequestDataBuilder(commandArgs.tftpPort);
            }
            case GetTFTPPort: {
                return this.tftpPortCmdRequestDataBuilder(null);
            }
        }
        return null;
    }

    @Override
    public AbstractJSONPOJO parserResponseData(GbtIpmiCommandResponseData gbtResponseData) {
        byte[] rawData = gbtResponseData.getAllResponseData();
        switch (this) {
            case GetUpdateStatus: {
                byte cache = 0;
                cache = rawData[rawData.length - 1];
                return new UpdateStatusJSONData().parserUpdateStatus(cache);
            }
            case BMCUpdatePhaseTransfer: {
                return new UpdateStatusJSONData().setUpdateMessages(this.getItem());
            }
            case BMCUpdatePhaseProcess: {
                return new UpdateStatusJSONData().setUpdateMessages(this.getItem());
            }
            case BMCUpdatePhaseStatus: {
                return new UpdateStatusJSONData().setStartTag(true).setUpdateMessages(this.getItem());
            }
            case BIOSUpdatePhaseTransfer: {
                return new UpdateStatusJSONData().setUpdateMessages(this.getItem());
            }
            case BIOSUpdatePhaseProcess: {
                return new UpdateStatusJSONData().setUpdateMessages(this.getItem());
            }
            case BIOSUpdatePhaseStatus: {
                return new UpdateStatusJSONData().setStartTag(true).setUpdateMessages(this.getItem());
            }
            case CPLDBPBUpdatePhaseTransfer: {
                return new UpdateStatusJSONData().setUpdateMessages(this.getItem());
            }
            case CPLDBPBUpdatePhaseProcess: {
                return new UpdateStatusJSONData().setUpdateMessages(this.getItem());
            }
            case CPLDBPBUpdatePhaseStatus: {
                return new UpdateStatusJSONData().setStartTag(true).setUpdateMessages(this.getItem());
            }
            case CPLDMBUpdatePhaseTransfer: {
                return new UpdateStatusJSONData().setUpdateMessages(this.getItem());
            }
            case CPLDMBUpdatePhaseProcess: {
                return new UpdateStatusJSONData().setUpdateMessages(this.getItem());
            }
            case CPLDMBUpdatePhaseStatus: {
                return new UpdateStatusJSONData().setStartTag(true).setUpdateMessages(this.getItem());
            }
            case PSUUpdatePhaseTransfer: {
                return new UpdateStatusJSONData().setUpdateMessages(this.getItem());
            }
            case PSUUpdatePhaseProcess: {
                return new UpdateStatusJSONData().setUpdateMessages(this.getItem());
            }
            case PSUUpdatePhaseStatus: {
                return new UpdateStatusJSONData().setStartTag(true).setUpdateMessages(this.getItem());
            }
            case SKUUpdatePhaseTransfer: {
                return new UpdateStatusJSONData().setUpdateMessages(this.getItem());
            }
            case SKUUpdatePhaseProcess: {
                return new UpdateStatusJSONData().setUpdateMessages(this.getItem());
            }
            case SKUUpdatePhaseStatus: {
                return new UpdateStatusJSONData().setStartTag(true).setUpdateMessages(this.getItem());
            }
            case PreserveBMCConfig: {
                return new UpdateStatusJSONData().setUpdateMessages(this.getItem());
            }
            case ClearBMCConfig: {
                return new UpdateStatusJSONData().setUpdateMessages(this.getItem());
            }
            case SetTFTPPort: {
                return new UpdateStatusJSONData().setUpdateMessages(this.getItem());
            }
            case GetTFTPPort: {
                return new UpdateStatusJSONData().setUpdateMessages(this.getItem() + this.parseGettingtftpPortResponse(rawData));
            }
        }
        return new NullJSONData().setError(true).setMessages("Unknown update command option.");
    }

    private final byte[] parserProductID(AbstractJSONPOJO preupdateFWInfo) {
        byte[] productID = new byte[]{4, 0};
        if (preupdateFWInfo instanceof BMCUpdateFWInfo) {
            String ID = preupdateFWInfo.castConcreteJSON(BMCUpdateFWInfo.class).getTargetBMCProductID();
            byte[] buffer = GbtCommonConverters.hexStringToByteArray(ID);
            if (buffer[0] == -1) {
                productID = GbtCommonConverters.invertByteArray(buffer);
            }
        } else if (preupdateFWInfo instanceof CPLDUpdateFWInfo) {
            String ID = preupdateFWInfo.castConcreteJSON(CPLDUpdateFWInfo.class).getBmcProductID();
            byte[] buffer = GbtCommonConverters.hexStringToByteArray(ID);
            if (buffer[0] == -1) {
                productID = GbtCommonConverters.invertByteArray(buffer);
            }
        } else if (preupdateFWInfo instanceof PSUUpdateFWInfo) {
            String ID = preupdateFWInfo.castConcreteJSON(PSUUpdateFWInfo.class).getBmcProductID();
            byte[] buffer = GbtCommonConverters.hexStringToByteArray(ID);
            if (buffer[0] == -1) {
                productID = GbtCommonConverters.invertByteArray(buffer);
            }
        } else if (preupdateFWInfo instanceof SKUUpdateFWInfo) {
            String ID = preupdateFWInfo.castConcreteJSON(SKUUpdateFWInfo.class).getTargetBMCProductID();
            byte[] buffer = GbtCommonConverters.hexStringToByteArray(ID);
            if (buffer[0] == -1) {
                productID = GbtCommonConverters.invertByteArray(buffer);
            }
            return productID;
        }
        return productID;
    }

    private final byte[] updateControlCmdRequestDataBuilder(byte[] action, byte phase, byte updateType, byte[] productID, File imageName, String tftpIP) {
        ByteArrayOutputStream outputArray = new ByteArrayOutputStream();
        byte[] fileName = new byte[16];
        byte[] tftpIPBytes = new byte[17];
        byte[] imageNameBytes = imageName.getName().getBytes(StandardCharsets.US_ASCII);
        System.arraycopy(imageNameBytes, 0, fileName, 0, imageNameBytes.length);
        if (CommonFunction.isIPv6(tftpIP)) {
            byte[] temp = GbtCommonConverters.ipv6ToBytesWithIDCode(tftpIP);
            System.arraycopy(temp, 0, tftpIPBytes, 0, temp.length);
        } else if (CommonFunction.isIPv4(tftpIP)) {
            byte[] temp = GbtCommonConverters.ipv4ToBytesWithIDCode(tftpIP);
            System.arraycopy(temp, 0, tftpIPBytes, 0, temp.length);
        }
        outputArray.write(action, 0, action.length);
        outputArray.write(phase);
        outputArray.write(productID, 0, productID.length);
        outputArray.write(IPMI_VER, 0, IPMI_VER.length);
        outputArray.write(fileName, 0, fileName.length);
        outputArray.write(FILESIZE, 0, FILESIZE.length);
        outputArray.write(CHECKSUM, 0, CHECKSUM.length);
        outputArray.write(tftpIPBytes, 0, tftpIPBytes.length);
        outputArray.write(updateType);
        return outputArray.toByteArray();
    }

    private final byte[] tftpPortCmdRequestDataBuilder(Integer port) {
        byte[] outputArray = new byte[6];
        outputArray[0] = 10;
        outputArray[1] = 60;
        outputArray[2] = 0;
        outputArray[3] = 41;
        if (port != null) {
            byte[] portArray = GbtCommonConverters.intToByteArray(port);
            outputArray[4] = portArray[3];
            outputArray[5] = portArray[2];
        } else {
            outputArray[4] = 0;
            outputArray[5] = 0;
        }
        return outputArray;
    }

    private int parseGettingtftpPortResponse(byte[] resp) {
        byte[] arr = new byte[]{0, 0, resp[4], resp[3]};
        ByteBuffer wrapped = ByteBuffer.wrap(arr);
        int port = wrapped.getInt();
        return port;
    }

    static {
        ACT_REPORT = new byte[]{10, 60, 0, 3, 1};
        ACT_START = new byte[]{10, 60, 0, 0, 1};
        ACT_PRESERVE = new byte[]{10, 60, 0, 1, 1, 1};
        ACT_CLEAR = new byte[]{10, 60, 0, 1, 0, 1};
        FILESIZE = new byte[]{0, 0, 0, 0};
        CHECKSUM = new byte[]{0, 0, 0, 0};
        IPMI_VER = new byte[]{2, 0};
    }
}

