/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.Update.parsers;

import Gbt.core.loggers.AbstractLoggerWriter;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.utility.FRU.record.BoardInfo;
import Gbt.utility.FRU.record.ProductInfo;
import Gbt.utility.Update.UpdateType;
import Gbt.utility.Update.fwInfo.CommonUpdateFWInfo;
import Gbt.utility.Update.parsers.BiosSuitableFwParser;
import Gbt.utility.Update.parsers.BmcSuitableFwParser;
import Gbt.utility.Update.parsers.CpldSuitableFwParser;
import Gbt.utility.Update.parsers.PsuSuitableFwParser;
import Gbt.utility.Update.parsers.SkuSuitableFwParser;
import Gbt.utility.bmcinfo.BMCInfoJSONData;
import java.io.File;
import java.util.List;

public abstract class SuitableFwParser {
    protected final AbstractLoggerWriter loggerWriter;
    protected final String commandName;
    protected final String commandId;
    protected final String bmcIpAddress;

    public SuitableFwParser(AbstractLoggerWriter loggerWriter, String commandName, String commandId, String bmcIpAddress) {
        this.loggerWriter = loggerWriter;
        this.commandName = commandName;
        this.commandId = commandId;
        this.bmcIpAddress = bmcIpAddress;
    }

    public abstract CommonUpdateFWInfo parseSuitableFw(List<File> var1, BoardInfo var2, ProductInfo var3, BMCInfoJSONData var4);

    public static final SuitableFwParser getFwParser(UpdateType updateType, AbstractLoggerWriter loggerWriter, String commandName, String commandId, String bmcIpAddress) {
        switch (updateType) {
            case CMC: 
            case BMC: {
                return new BmcSuitableFwParser(loggerWriter, commandName, commandId, bmcIpAddress);
            }
            case BIOS: {
                return new BiosSuitableFwParser(loggerWriter, commandName, commandId, bmcIpAddress);
            }
            case CPLDBPB: {
                return new CpldSuitableFwParser(loggerWriter, commandName, commandId, bmcIpAddress, updateType);
            }
            case CPLDMB: {
                return new CpldSuitableFwParser(loggerWriter, commandName, commandId, bmcIpAddress, updateType);
            }
            case PSU: {
                return new PsuSuitableFwParser(loggerWriter, commandName, commandId, bmcIpAddress);
            }
            case SKU: {
                return new SkuSuitableFwParser(loggerWriter, commandName, commandId, bmcIpAddress);
            }
        }
        loggerWriter.appendPath(commandName).writeLogs(GbtLogLevel.ERROR, commandId, "[" + bmcIpAddress + "] Unknown update type.");
        return null;
    }
}

