/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.postcode;

import Gbt.core.commands.AbstractCommand;
import Gbt.core.commands.AbstractCommandBuilder;
import Gbt.core.ipmi.GbtIpmiCommandResponseData;
import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.receivers.GbtIPMICommandReceiver;
import Gbt.utility.Common.GbtCommonConverters;
import Gbt.utility.bmcinfo.BMCVendor;
import Gbt.utility.postcode.PostCodeData;
import Gbt.utility.postcode.PostCodeIpmiOptions;
import Gbt.utility.postcode.PostCodeOptions;
import com.google.common.primitives.Bytes;
import com.veraxsystems.vxipmi.api.async.ConnectionHandle;
import java.math.BigDecimal;
import java.util.ArrayList;
import org.apache.commons.lang.ArrayUtils;

public final class PostCodeCommand
extends AbstractCommand<Builder> {
    public static final String COMMAND_NAME = "postcode";
    private final GbtIPMICommandReceiver ipmiReceiver;

    protected PostCodeCommand(Builder commandArgs) {
        super(commandArgs);
        this.commandID = ((Builder)this.commandArgs).bmcIP + "_" + COMMAND_NAME;
        this.ipmiReceiver = GbtIPMICommandReceiver.getInstance();
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String getDocumentsName() {
        return COMMAND_NAME;
    }

    @Override
    public boolean checkAll() {
        if (!((Builder)this.commandArgs).checkArgs()) {
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Check arguments fail.");
            return false;
        }
        if (this.ipmiReceiver == null) {
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI ipmiReceiver is null.");
            return false;
        }
        return true;
    }

    @Override
    public boolean execute() {
        ConnectionHandle handle = this.ipmiReceiver.createIPMIConnection(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword, this.getCommandName(), this.commandID);
        if (handle == null) {
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI connection fail.");
            return false;
        }
        BMCVendor bmcVendor = this.ipmiReceiver.getBmcVendor(handle, this.getCommandName(), this.commandID);
        switch (bmcVendor) {
            case VERTIV: 
            case OPENBMC: {
                this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Not support on " + bmcVendor.toString() + " FW.");
                return false;
            }
            case AMI: {
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Start to get " + ((Builder)this.commandArgs).postCodeOptions.toString() + " BIOS post code.");
                break;
            }
            default: {
                this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Fail to get BMC vendor.");
                return false;
            }
        }
        PostCodeData postCodeData = new PostCodeData();
        AbstractJSONPOJO resp = null;
        ArrayList responseBuffer = new ArrayList();
        switch (((Builder)this.commandArgs).postCodeOptions) {
            case Current: {
                NullJSONData temp;
                NullJSONData temp2;
                resp = this.ipmiReceiver.sendIPMIRawCommand(handle, PostCodeIpmiOptions.GET_CURRENT_LENGTH, this.commandArgs, this.getCommandName(), this.commandID);
                if (resp instanceof NullJSONData && (temp2 = resp.castConcreteJSON(NullJSONData.class)).isError()) {
                    this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                    this.commandResults.add(temp2);
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + temp2.getMessages());
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + PostCodeIpmiOptions.GET_CURRENT_LENGTH.getItem() + " fail.");
                    return false;
                }
                int currentLength = resp.castConcreteJSON(GbtIpmiCommandResponseData.class).getResponseData(0) & 0xFF;
                postCodeData.setLength(new BigDecimal(currentLength));
                if (currentLength == 0) {
                    this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                    this.commandResults.add(postCodeData);
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] No current post code.");
                    return true;
                }
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Post code length : " + currentLength);
                resp = this.ipmiReceiver.sendIPMIRawCommand(handle, PostCodeIpmiOptions.GET_FIRST_CURRENT_DATA, this.commandArgs, this.getCommandName(), this.commandID);
                if (resp instanceof NullJSONData && (temp = resp.castConcreteJSON(NullJSONData.class)).isError()) {
                    this.commandResults.add(temp);
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + temp.getMessages());
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + PostCodeIpmiOptions.GET_FIRST_CURRENT_DATA.getItem() + " fail.");
                    this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                    return false;
                }
                byte[] firstData = resp.castConcreteJSON(GbtIpmiCommandResponseData.class).getAllResponseData();
                responseBuffer.addAll(Bytes.asList((byte[])firstData));
                if (currentLength > 256) {
                    NullJSONData temp3;
                    resp = this.ipmiReceiver.sendIPMIRawCommand(handle, PostCodeIpmiOptions.GET_NEXT_CURRENT_DATA, this.commandArgs, this.getCommandName(), this.commandID);
                    if (resp instanceof NullJSONData && (temp3 = resp.castConcreteJSON(NullJSONData.class)).isError()) {
                        this.commandResults.add(temp3);
                        this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + temp3.getMessages());
                        this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + PostCodeIpmiOptions.GET_NEXT_CURRENT_DATA.getItem() + " fail.");
                        this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                        responseBuffer.clear();
                        return false;
                    }
                    byte[] secondData = resp.castConcreteJSON(GbtIpmiCommandResponseData.class).getAllResponseData();
                    responseBuffer.addAll(Bytes.asList((byte[])secondData));
                }
                Byte[] tempBuffer = responseBuffer.toArray(new Byte[0]);
                byte[] finalResponse = ArrayUtils.toPrimitive((Byte[])tempBuffer);
                postCodeData.setLength(new BigDecimal(finalResponse.length));
                postCodeData.setData(finalResponse);
                this.commandResults.add(postCodeData);
                this.rawByteDataPrinter(finalResponse);
                this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                responseBuffer.clear();
                return true;
            }
            case Previous: {
                NullJSONData temp;
                NullJSONData temp4;
                resp = this.ipmiReceiver.sendIPMIRawCommand(handle, PostCodeIpmiOptions.GET_PREVIOUS_LENGTH, this.commandArgs, this.getCommandName(), this.commandID);
                if (resp instanceof NullJSONData && (temp4 = resp.castConcreteJSON(NullJSONData.class)).isError()) {
                    this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                    this.commandResults.add(temp4);
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + temp4.getMessages());
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + PostCodeIpmiOptions.GET_PREVIOUS_LENGTH.getItem() + " fail.");
                    return false;
                }
                int previousLength = resp.castConcreteJSON(GbtIpmiCommandResponseData.class).getResponseData(0) & 0xFF;
                postCodeData.setLength(new BigDecimal(previousLength));
                if (previousLength == 0) {
                    this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                    this.commandResults.add(postCodeData);
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] No previous post code.");
                    return true;
                }
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Post code length : " + previousLength);
                resp = this.ipmiReceiver.sendIPMIRawCommand(handle, PostCodeIpmiOptions.GET_FIRST_PREVIOUS_DATA, this.commandArgs, this.getCommandName(), this.commandID);
                if (resp instanceof NullJSONData && (temp = resp.castConcreteJSON(NullJSONData.class)).isError()) {
                    this.commandResults.add(temp);
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + temp.getMessages());
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + PostCodeIpmiOptions.GET_FIRST_PREVIOUS_DATA.getItem() + " fail.");
                    this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                    return false;
                }
                byte[] firstDataP = resp.castConcreteJSON(GbtIpmiCommandResponseData.class).getAllResponseData();
                responseBuffer.addAll(Bytes.asList((byte[])firstDataP));
                if (previousLength > 256) {
                    NullJSONData temp5;
                    resp = this.ipmiReceiver.sendIPMIRawCommand(handle, PostCodeIpmiOptions.GET_NEXT_PREVIOUS_DATA, this.commandArgs, this.getCommandName(), this.commandID);
                    if (resp instanceof NullJSONData && (temp5 = resp.castConcreteJSON(NullJSONData.class)).isError()) {
                        this.commandResults.add(temp5);
                        this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + temp5.getMessages());
                        this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + PostCodeIpmiOptions.GET_NEXT_PREVIOUS_DATA.getItem() + " fail.");
                        this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                        responseBuffer.clear();
                        return false;
                    }
                    byte[] secondData = resp.castConcreteJSON(GbtIpmiCommandResponseData.class).getAllResponseData();
                    responseBuffer.addAll(Bytes.asList((byte[])secondData));
                }
                Byte[] tempBufferP = responseBuffer.toArray(new Byte[0]);
                byte[] finalResponseP = ArrayUtils.toPrimitive((Byte[])tempBufferP);
                postCodeData.setLength(new BigDecimal(finalResponseP.length));
                postCodeData.setData(finalResponseP);
                this.commandResults.add(postCodeData);
                this.rawByteDataPrinter(finalResponseP);
                this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                responseBuffer.clear();
                return true;
            }
        }
        this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Unknown option of post code command.");
        this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
        return false;
    }

    @Override
    public void close() throws Exception {
        ((Builder)this.commandArgs).close();
    }

    @Override
    public void cancelHook(Object obj) {
    }

    private void rawByteDataPrinter(byte[] rawData) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < rawData.length; ++i) {
            stringBuilder.append(GbtCommonConverters.bytesToHex(rawData[i]));
            if ((i + 1) % 16 == 0 && i != 0) {
                stringBuilder.append("\n");
                continue;
            }
            stringBuilder.append(" ");
        }
        this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, stringBuilder.toString());
        stringBuilder.setLength(0);
    }

    public static final class Builder
    extends AbstractCommandBuilder<Builder> {
        private String bmcIP;
        private String bmcUsername = "admin";
        private String bmcPassword = "password";
        private PostCodeOptions postCodeOptions = PostCodeOptions.Unknown;

        @Override
        public boolean checkArgs() {
            if (this.bmcIP == null) {
                return false;
            }
            if (this.args != null) {
                if (this.args.length != 1) {
                    return false;
                }
                this.postCodeOptions = PostCodeOptions.parse(this.args[0]);
            }
            return this.postCodeOptions != PostCodeOptions.Unknown;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        public PostCodeCommand build() {
            return new PostCodeCommand(this);
        }

        @Override
        public void close() throws Exception {
            this.args = null;
            this.bmcIP = null;
            this.bmcUsername = null;
            this.bmcPassword = null;
            this.postCodeOptions = null;
            this.loggerWriter.close();
        }

        public Builder setBMCIP(String bmcIP) {
            this.bmcIP = bmcIP;
            return this.getThis();
        }

        public Builder setBMCUsername(String username) {
            this.bmcUsername = username;
            return this.getThis();
        }

        public Builder setBMCPassword(String password) {
            this.bmcPassword = password;
            return this.getThis();
        }

        public Builder setPostCodeOptions(PostCodeOptions postCodeOptions) {
            this.postCodeOptions = postCodeOptions;
            return this.getThis();
        }
    }
}

