/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.redfish;

import Gbt.core.commands.AbstractCommand;
import Gbt.core.commands.AbstractCommandBuilder;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.receivers.GbtIPMICommandReceiver;
import Gbt.core.receivers.RESTClientReceiver;
import Gbt.core.redfish.RedfishApiPayload;
import Gbt.core.redfish.RedfishApiService;
import Gbt.core.rest.RESTException;
import Gbt.core.rest.RESTHttpMethods;
import Gbt.core.rest.RESTProtocolHeaders;
import Gbt.core.rest.RESTRequest;
import Gbt.core.rest.RESTRequestImpl;
import Gbt.utility.bmcinfo.BMCVendor;
import Gbt.utility.redfish.RestFullResponseData;
import Gbt.utility.redfish.factories.RedfishApiMenu;
import Gbt.utility.redfish.options.RootServiceApiOptions;
import com.veraxsystems.vxipmi.api.async.ConnectionHandle;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.ArrayUtils;

public final class RedfishCommand
extends AbstractCommand<Builder> {
    public static final String COMMAND_NAME = "redfish";
    public static final String NA_USER_PASSWORD = "N/A";
    private static final String AMI_REDFISH_DEFAULT_USERNAME = "Administrator";
    private static final String AMI_REDFISH_DEFAULT_PASSWORD = "superuser";
    private final RESTClientReceiver restReceiver;
    private final GbtIPMICommandReceiver ipmiReceiver;

    protected RedfishCommand(Builder commandArgs) {
        super(commandArgs);
        this.commandID = ((Builder)this.commandArgs).bmcIP + "_" + this.getCommandName() + "_" + ((Builder)this.commandArgs).apiMenu.getApiName();
        this.restReceiver = RESTClientReceiver.getInstance();
        this.ipmiReceiver = GbtIPMICommandReceiver.getInstance();
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String getDocumentsName() {
        return this.getCommandName() + "/" + ((Builder)this.commandArgs).apiMenu.toString();
    }

    @Override
    public boolean checkAll() {
        if (!((Builder)this.commandArgs).checkArgs()) {
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Check arguments fail.");
            return false;
        }
        if (this.ipmiReceiver == null) {
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI client receiver is null.");
            return false;
        }
        if (this.restReceiver == null) {
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] REST client receiver is null.");
            return false;
        }
        return true;
    }

    @Override
    public boolean execute() {
        if (((Builder)this.commandArgs).port == 0 && !this.findServiceRoot()) {
            return false;
        }
        if (((Builder)this.commandArgs).redfishApiPayload == null) {
            Object payLoad = ((RedfishApiPayload)((RedfishApiPayload)((Builder)this.commandArgs).apiMenu.getApiPayload(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).redfishUsername, ((Builder)this.commandArgs).redfishPassword, this.loggerWriter).setPort(((Builder)this.commandArgs).port)).setDebug(((Builder)this.commandArgs).debug)).setRestRawArgs(this.parseRawArgs());
            ((Builder)this.commandArgs).setServicePayload((RedfishApiPayload<?, ?>)payLoad);
        } else {
            ((Builder)this.commandArgs).redfishApiPayload.setLoggerWriter(this.loggerWriter);
        }
        ((Builder)this.commandArgs).redfishApiPayload.setProtocolHeader(((Builder)this.commandArgs).protocolHeader);
        RedfishApiService service = ((Builder)this.commandArgs).redfishApiPayload.build();
        if (!service.requestValidation()) {
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
            return false;
        }
        if (!service.execute()) {
            this.commandResults.addAll(service.getResponseData());
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
            return false;
        }
        this.commandResults.addAll(service.getResponseData());
        this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
        return true;
    }

    @Override
    public void close() throws Exception {
        this.commandID = null;
        ((Builder)this.commandArgs).close();
        this.loggerWriter.close();
    }

    @Override
    public void cancelHook(Object obj) {
    }

    private String[] parseRawArgs() {
        if (((Builder)this.commandArgs).getRestRawArgs() == null) {
            return new String[0];
        }
        Object[] temp = ((Builder)this.commandArgs).getRestRawArgs();
        temp = (String[])ArrayUtils.removeElement((Object[])temp, (Object)((Builder)this.commandArgs).apiMenu.getApiName());
        for (int i = 0; i < temp.length; ++i) {
            if (((String)temp[i]).contains("port=")) {
                temp = (String[])ArrayUtils.removeElement((Object[])temp, (Object)temp[i]);
                continue;
            }
            if (!"debug".equals(temp[i])) continue;
            temp = (String[])ArrayUtils.removeElement((Object[])temp, (Object)temp[i]);
        }
        return temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean findServiceRoot() {
        ConnectionHandle handle = this.ipmiReceiver.createIPMIConnection(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).username, ((Builder)this.commandArgs).password, this.getCommandName(), this.commandID);
        if (handle == null) {
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI connection fail.");
            return false;
        }
        BMCVendor vendor = this.ipmiReceiver.getBmcVendor(handle, this.getCommandName(), this.commandID);
        RESTRequestImpl request = null;
        switch (vendor) {
            case VERTIV: {
                request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHostname(((Builder)this.commandArgs).bmcIP)).setProtocolHeader(RESTProtocolHeaders.HTTPS)).setHttpMethods(RESTHttpMethods.GET)).setServiceURI(RootServiceApiOptions.SHOW.getMainUri()).setContentType("application/json")).build();
                if (((Builder)this.commandArgs).redfishUsername.equals(NA_USER_PASSWORD)) {
                    ((Builder)this.commandArgs).setRedfishUsername("admin");
                }
                if (((Builder)this.commandArgs).redfishPassword.equals(NA_USER_PASSWORD)) {
                    ((Builder)this.commandArgs).setRedfishPassword("password");
                }
                this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                break;
            }
            case AMI: {
                request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHostname(((Builder)this.commandArgs).bmcIP)).setProtocolHeader(RESTProtocolHeaders.HTTPS)).setHttpMethods(RESTHttpMethods.GET)).setServiceURI(RootServiceApiOptions.SHOW.getMainUri()).setContentType("application/json")).build();
                if (((Builder)this.commandArgs).redfishUsername.equals(NA_USER_PASSWORD)) {
                    ((Builder)this.commandArgs).setRedfishUsername(AMI_REDFISH_DEFAULT_USERNAME);
                }
                if (((Builder)this.commandArgs).redfishPassword.equals(NA_USER_PASSWORD)) {
                    ((Builder)this.commandArgs).setRedfishPassword(AMI_REDFISH_DEFAULT_PASSWORD);
                }
                this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                break;
            }
            case OPENBMC: {
                request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHostname(((Builder)this.commandArgs).bmcIP)).setProtocolHeader(RESTProtocolHeaders.HTTP)).setHttpMethods(RESTHttpMethods.GET)).setServiceURI(RootServiceApiOptions.SHOW.getMainUri()).setContentType("application/json")).build();
                if (((Builder)this.commandArgs).redfishUsername.equals(NA_USER_PASSWORD)) {
                    ((Builder)this.commandArgs).setRedfishUsername("admin");
                }
                if (((Builder)this.commandArgs).redfishPassword.equals(NA_USER_PASSWORD)) {
                    ((Builder)this.commandArgs).setRedfishPassword("password");
                }
                ((Builder)this.commandArgs).setProtocolHeader(RESTProtocolHeaders.HTTP);
                this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                break;
            }
            default: {
                this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Get BMC vendor fail.");
                return false;
            }
        }
        Client client = null;
        try {
            client = this.restReceiver.createHttpsClient(((Builder)this.commandArgs).username, ((Builder)this.commandArgs).password, ((Builder)this.commandArgs).debug);
        }
        catch (RESTException re) {
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Create HTTPS client fail.");
            return false;
        }
        try {
            Response response = this.restReceiver.syncInvoke(client, request, this.getCommandName(), this.commandID);
            RestFullResponseData desResp = this.restReceiver.deserializeAsCommonData(response);
            if (desResp.isRedfishErrorResponse()) {
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Cannot find service root of Redfish.");
            }
            boolean bl = !desResp.isRedfishErrorResponse();
            return bl;
        }
        catch (RESTException re) {
            if (re.getStatusCode() == 404) {
                try {
                    request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHostname(((Builder)this.commandArgs).bmcIP)).setHttpMethods(RESTHttpMethods.GET)).setPort(8080)).setServiceURI(RootServiceApiOptions.SHOW.getMainUri()).setContentType("application/json")).build();
                    Response response = this.restReceiver.syncInvoke(client, request, this.getCommandName(), this.commandID);
                    RestFullResponseData desResp = this.restReceiver.deserializeAsCommonData(response);
                    ((Builder)this.commandArgs).setPort(8080);
                    if (((Builder)this.commandArgs).redfishUsername.equals(NA_USER_PASSWORD)) {
                        ((Builder)this.commandArgs).setRedfishUsername("admin");
                    }
                    if (((Builder)this.commandArgs).redfishPassword.equals(NA_USER_PASSWORD)) {
                        ((Builder)this.commandArgs).setRedfishPassword("password");
                    }
                    if (desResp.isRedfishErrorResponse()) {
                        this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Cannot find service root of Redfish.");
                    }
                    boolean bl = !desResp.isRedfishErrorResponse();
                    return bl;
                }
                catch (RESTException re2) {
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Cannot find service root of Redfish.");
                    boolean bl = false;
                    return bl;
                }
            }
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Cannot find service root of Redfish.");
            boolean bl = false;
            return bl;
        }
        finally {
            client.close();
        }
    }

    public static final class Builder
    extends AbstractCommandBuilder<Builder> {
        private String bmcIP;
        private String username = "N/A";
        private String password = "N/A";
        private String redfishUsername = "N/A";
        private String redfishPassword = "N/A";
        private RedfishApiMenu apiMenu = RedfishApiMenu.UNKNOWN;
        private int port = 0;
        private boolean debug = false;
        private RedfishApiPayload<?, ?> redfishApiPayload;
        private RESTProtocolHeaders protocolHeader = RESTProtocolHeaders.HTTPS;

        @Override
        public boolean checkArgs() {
            if (this.bmcIP == null) {
                return false;
            }
            if (this.args != null) {
                if (this.args.length < 2) {
                    return false;
                }
                this.apiMenu = RedfishApiMenu.parse(this.args[0]);
                if (this.apiMenu == RedfishApiMenu.UNKNOWN) {
                    return false;
                }
                if (this.apiMenu.getApiOption(this.args[1]).getOptionName().toLowerCase().equals(RedfishApiMenu.UNKNOWN.getApiName()) && this.apiMenu != RedfishApiMenu.LOGSERVICE) {
                    return false;
                }
                for (String arg : this.args) {
                    if (arg.contains("port=")) {
                        this.setPort(Integer.parseInt(arg.substring(arg.lastIndexOf("port=") + 5)));
                    }
                    if (!"debug".equals(arg)) continue;
                    this.setDebug(true);
                }
            } else {
                if (this.redfishApiPayload == null) {
                    return false;
                }
                if (this.apiMenu == RedfishApiMenu.UNKNOWN) {
                    return false;
                }
                if (this.redfishApiPayload.getServiceOption().getOptionName().toLowerCase().equals(RedfishApiMenu.UNKNOWN.getApiName())) {
                    return false;
                }
            }
            return true;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        public RedfishCommand build() {
            if (this.args != null) {
                RedfishApiMenu redfishApiMenu = this.apiMenu = this.args.length > 0 ? RedfishApiMenu.parse(this.args[0]) : RedfishApiMenu.UNKNOWN;
            }
            if (this.redfishApiPayload != null) {
                this.apiMenu = RedfishApiMenu.parse(this.redfishApiPayload.build().getServiceName());
            }
            return new RedfishCommand(this);
        }

        public Builder setBMCIP(String bmcIP) {
            this.bmcIP = bmcIP;
            return this.getThis();
        }

        public Builder setBMCUsername(String userName) {
            this.username = userName;
            return this.getThis();
        }

        public Builder setBMCPassword(String password) {
            this.password = password;
            return this.getThis();
        }

        public Builder setRedfishUsername(String redfishUsername) {
            this.redfishUsername = redfishUsername;
            return this.getThis();
        }

        public Builder setRedfishPassword(String redfishPassword) {
            this.redfishPassword = redfishPassword;
            return this.getThis();
        }

        public Builder setPort(int port) {
            this.port = port;
            return this.getThis();
        }

        public Builder setDebug(boolean debug) {
            this.debug = debug;
            return this.getThis();
        }

        public Builder setServicePayload(RedfishApiPayload<?, ?> redfishApiPayload) {
            this.redfishApiPayload = redfishApiPayload;
            return this.getThis();
        }

        public Builder setProtocolHeader(RESTProtocolHeaders protocolHeader) {
            this.protocolHeader = protocolHeader;
            return this.getThis();
        }

        protected String[] getRestRawArgs() {
            return this.args;
        }

        @Override
        public void close() {
            this.args = null;
            this.bmcIP = null;
            this.username = null;
            this.password = null;
            this.redfishUsername = null;
            this.redfishPassword = null;
        }
    }
}

