/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.redfish;

import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.jsonapi.JacksonCommonUtil;
import Gbt.core.redfish.RedfishCommonProperties;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;

public final class RestFullResponseData
extends AbstractJSONPOJO {
    private int httpStatus;
    private MultivaluedMap<String, Object> responseHeaders;
    private JsonNode responseBody;

    @JsonProperty(value="HttpStatus")
    public int getHttpStatus() {
        return this.httpStatus;
    }

    public void setHttpStatus(int httpStatus) {
        this.httpStatus = httpStatus;
    }

    @JsonProperty(value="ResponseHeaders")
    public MultivaluedMap<String, Object> getResponseHeaders() {
        return this.responseHeaders;
    }

    public void setResponseHeaders(MultivaluedMap<String, Object> responseHeaders) {
        this.responseHeaders = responseHeaders;
    }

    @JsonProperty(value="ResponseBody")
    public JsonNode getResponseBody() {
        return this.responseBody;
    }

    public void setResponseBody(JsonNode responseBody) {
        this.responseBody = responseBody;
    }

    @Override
    public String toString() {
        return this.responseBody == null ? super.toString() : JacksonCommonUtil.getUtil().getPrettyPrintString(this.responseBody);
    }

    @JsonIgnore
    public boolean isRedfishErrorResponse() {
        if (this.responseBody == null) {
            return false;
        }
        return this.responseBody.get(RedfishCommonProperties.ERROR.toString()) != null;
    }

    @JsonIgnore
    public List<String> getMembersOdataId() {
        ArrayList<String> members = new ArrayList<String>();
        if (this.responseBody == null) {
            return members;
        }
        if (this.responseBody.get(RedfishCommonProperties.MEMBERS.toString()) == null) {
            return members;
        }
        if (!this.responseBody.get(RedfishCommonProperties.MEMBERS.toString()).isArray()) {
            return members;
        }
        Iterator itar = this.responseBody.get(RedfishCommonProperties.MEMBERS.toString()).elements();
        while (itar.hasNext()) {
            members.add(((JsonNode)itar.next()).get(RedfishCommonProperties.ODATA_ID.toString()).asText());
        }
        return members;
    }

    @JsonIgnore
    public Map<String, String> getAllNextOdataId() {
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.responseBody == null) {
            return map;
        }
        Iterator rootFieldNames = this.responseBody.fieldNames();
        while (rootFieldNames.hasNext()) {
            String rootfieldName = (String)rootFieldNames.next();
            map.putAll(this.recursiveSearchJsonNode(rootfieldName, this.responseBody.get(rootfieldName), RedfishCommonProperties.ODATA_ID.toString()));
        }
        return map;
    }

    @JsonIgnore
    public Map<String, String> getAllActionTargets() {
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.responseBody == null) {
            return map;
        }
        Iterator rootFieldNames = this.responseBody.fieldNames();
        while (rootFieldNames.hasNext()) {
            String rootfieldName = (String)rootFieldNames.next();
            map.putAll(this.recursiveSearchJsonNode(rootfieldName, this.responseBody.get(rootfieldName), RedfishCommonProperties.TARGET.toString()));
        }
        return map;
    }

    private final Map<String, String> recursiveSearchJsonNode(String fieldName, JsonNode fieldNode, String searchKey) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (fieldNode == null) {
            return map;
        }
        switch (fieldNode.getNodeType()) {
            case OBJECT: {
                JsonNode nextFieldNode = fieldNode.get(searchKey);
                if (nextFieldNode == null) {
                    Iterator nextFieldNames = fieldNode.fieldNames();
                    while (nextFieldNames.hasNext()) {
                        String nextFieldName = (String)nextFieldNames.next();
                        map.putAll(this.recursiveSearchJsonNode(nextFieldName, fieldNode.get(nextFieldName), searchKey));
                    }
                    return map;
                }
                switch (nextFieldNode.getNodeType()) {
                    case STRING: {
                        map.put(fieldName, nextFieldNode.asText());
                        return map;
                    }
                }
                return map;
            }
        }
        return map;
    }
}

