/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.redfish.services;

import Gbt.core.jsonapi.JacksonCommonUtil;
import Gbt.core.loggers.AbstractLoggerWriter;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.redfish.RedfishApiPayload;
import Gbt.core.redfish.RedfishApiService;
import Gbt.core.redfish.RedfishResourceTypes;
import Gbt.core.rest.RESTException;
import Gbt.core.rest.RESTHttpMethods;
import Gbt.core.rest.RESTRequest;
import Gbt.core.rest.RESTRequestImpl;
import Gbt.utility.Common.GbtCommonConverters;
import Gbt.utility.redfish.RestFullResponseData;
import Gbt.utility.redfish.factories.RedfishApiMenu;
import Gbt.utility.redfish.models.common.serial.SerialInterfaceResource;
import Gbt.utility.redfish.options.SerialInterfacesApiOptions;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.Response;

public final class SerialInterfacesApi
extends RedfishApiService<Payload> {
    protected SerialInterfacesApi(Payload servicePayload) {
        super(servicePayload);
    }

    @Override
    public String getServiceName() {
        return RedfishApiMenu.SERIAL.getApiName();
    }

    @Override
    protected boolean checkRawArgs() {
        if (((Payload)this.servicePayload).getRestRawArgs().length == 0) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((Payload)this.servicePayload).getIpAddress() + "] The input arguments not enough.");
            return false;
        }
        ((Payload)this.servicePayload).setServiceOption(SerialInterfacesApiOptions.parse(((Payload)this.servicePayload).getRestRawArgs()[0]));
        switch ((SerialInterfacesApiOptions)((Payload)this.servicePayload).getServiceOption()) {
            case LIST: {
                if (((Payload)this.servicePayload).getRestRawArgs().length == 2) {
                    ((Payload)this.servicePayload).setManagerId(((Payload)this.servicePayload).getRestRawArgs()[1]);
                }
                return true;
            }
            case GET: {
                switch (((Payload)this.servicePayload).getRestRawArgs().length) {
                    case 2: {
                        ((Payload)this.servicePayload).setSerialInterfaceId(((Payload)this.servicePayload).getRestRawArgs()[1]);
                        return true;
                    }
                    case 3: {
                        ((Payload)this.servicePayload).setManagerId(((Payload)this.servicePayload).getRestRawArgs()[1]);
                        ((Payload)this.servicePayload).setSerialInterfaceId(((Payload)this.servicePayload).getRestRawArgs()[2]);
                        return true;
                    }
                }
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((SerialInterfacesApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
                return false;
            }
            case MODIFY: {
                switch (((Payload)this.servicePayload).getRestRawArgs().length) {
                    case 2: {
                        ((Payload)this.servicePayload).setSerialInterfaceId(((Payload)this.servicePayload).getRestRawArgs()[1]);
                        return true;
                    }
                    case 3: {
                        ((Payload)this.servicePayload).setManagerId(((Payload)this.servicePayload).getRestRawArgs()[1]);
                        ((Payload)this.servicePayload).setUploadJsonFile(GbtCommonConverters.stringToJavaIoFile(((Payload)this.servicePayload).getRestRawArgs()[2]));
                        return this.uploadFileValidation(RedfishResourceTypes.SerialInterface);
                    }
                }
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((SerialInterfacesApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
                return false;
            }
        }
        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((SerialInterfacesApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
        return false;
    }

    @Override
    protected boolean checkPayLoad() {
        switch ((SerialInterfacesApiOptions)((Payload)this.servicePayload).getServiceOption()) {
            case LIST: {
                return true;
            }
            case GET: {
                if (((Payload)this.servicePayload).getSerialInterfaceId() == null) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((SerialInterfacesApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
                    return false;
                }
                return true;
            }
            case MODIFY: {
                if (((Payload)this.servicePayload).getSerialInterfaceId() == null) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, SerialInterfacesApiOptions.GET.getPayLoadErrorMessages());
                    return false;
                }
                if (((Payload)this.servicePayload).getUploadJsonFile() != null) {
                    return this.uploadFileValidation(RedfishResourceTypes.SerialInterface);
                }
                if (((Payload)this.servicePayload).getConfigData() != null) {
                    return this.uploadDataValidation(RedfishResourceTypes.SerialInterface, ((Payload)this.servicePayload).getConfigData());
                }
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((SerialInterfacesApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
                return false;
            }
        }
        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((SerialInterfacesApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        Client client = null;
        try {
            client = this.restReceiver.createHttpsClient(((Payload)this.servicePayload).getUsername(), ((Payload)this.servicePayload).getPassword(), ((Payload)this.servicePayload).isDebug());
        }
        catch (RESTException re) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((Payload)this.servicePayload).getIpAddress() + "] Create HTTPS client fail.");
            return false;
        }
        if (((Payload)this.servicePayload).getManagerId() == null) {
            ((Payload)this.servicePayload).setManagerId("Self");
        }
        switch ((SerialInterfacesApiOptions)((Payload)this.servicePayload).getServiceOption()) {
            case LIST: {
                try {
                    RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHostname(((Payload)this.servicePayload).getIpAddress())).setProtocolHeader(((Payload)this.servicePayload).getProtocolHeader())).setPort(((Payload)this.servicePayload).getPort())).setHttpMethods(RESTHttpMethods.GET)).setContentType("application/json")).setServiceURI(((SerialInterfacesApiOptions)((Payload)this.servicePayload).getServiceOption()).getMainUri().replace("<id>", ((Payload)this.servicePayload).getManagerId())).build();
                    Response response = this.restReceiver.syncInvoke(client, request, this.logDirPath, this.serviceLogsId);
                    RestFullResponseData desResp = this.restReceiver.deserializeAsCommonData(response);
                    this.responseData.add(desResp);
                    if (desResp.isRedfishErrorResponse()) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, desResp.toString());
                        boolean bl = false;
                        return bl;
                    }
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, this.serviceLogsId, "[" + ((Payload)this.servicePayload).getIpAddress() + "] Serial Interfaces : ");
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, this.serviceLogsId, JacksonCommonUtil.getUtil().getPrettyPrintString(desResp.getMembersOdataId()));
                    boolean bl = true;
                    return bl;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getMessage());
                    if (re.getUnexpectedBody() != null) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getUnexpectedBody());
                    }
                    boolean response = false;
                    return response;
                }
                finally {
                    client.close();
                }
            }
            case GET: {
                try {
                    RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHostname(((Payload)this.servicePayload).getIpAddress())).setProtocolHeader(((Payload)this.servicePayload).getProtocolHeader())).setPort(((Payload)this.servicePayload).getPort())).setHttpMethods(RESTHttpMethods.GET)).setContentType("application/json")).setServiceURI(((SerialInterfacesApiOptions)((Payload)this.servicePayload).getServiceOption()).getMainUri().replace("<id>", ((Payload)this.servicePayload).getManagerId())).setServiceId(((Payload)this.servicePayload).getSerialInterfaceId()).build();
                    Response response = this.restReceiver.syncInvoke(client, request, this.logDirPath, this.serviceLogsId);
                    RestFullResponseData desResp = this.restReceiver.deserializeAsCommonData(response);
                    this.responseData.add(desResp);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(desResp.isRedfishErrorResponse() ? GbtLogLevel.ERROR : GbtLogLevel.INFO, this.serviceLogsId, desResp.toString());
                    boolean bl = !desResp.isRedfishErrorResponse();
                    return bl;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getMessage());
                    if (re.getUnexpectedBody() != null) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getUnexpectedBody());
                    }
                    boolean response = false;
                    return response;
                }
                finally {
                    client.close();
                }
            }
            case MODIFY: {
                try {
                    String etag = this.getETag(((Payload)this.servicePayload).getProtocolHeader(), client, ((SerialInterfacesApiOptions)((Payload)this.servicePayload).getServiceOption()).getMainUri().replace("<id>", ((Payload)this.servicePayload).getManagerId()) + "/" + ((Payload)this.servicePayload).getSerialInterfaceId());
                    RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHostname(((Payload)this.servicePayload).getIpAddress())).setProtocolHeader(((Payload)this.servicePayload).getProtocolHeader())).setPort(((Payload)this.servicePayload).getPort())).setHttpMethods(RESTHttpMethods.PATCH)).setContentType("application/json")).setServiceURI(((SerialInterfacesApiOptions)((Payload)this.servicePayload).getServiceOption()).getMainUri().replace("<id>", ((Payload)this.servicePayload).getManagerId())).setServiceId(((Payload)this.servicePayload).getSerialInterfaceId()).setHeaders("If-Match", etag)).setRawJsonData(this.requestBody)).build();
                    Response response = this.restReceiver.syncInvoke(client, request, this.logDirPath, this.serviceLogsId);
                    RestFullResponseData desResp = this.restReceiver.deserializeAsCommonData(response);
                    this.responseData.add(desResp);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(desResp.isRedfishErrorResponse() ? GbtLogLevel.ERROR : GbtLogLevel.INFO, this.serviceLogsId, desResp.toString());
                    boolean bl = !desResp.isRedfishErrorResponse();
                    return bl;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getMessage());
                    if (re.getUnexpectedBody() != null) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getUnexpectedBody());
                    }
                    boolean bl = false;
                    return bl;
                }
                finally {
                    client.close();
                }
            }
        }
        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((SerialInterfacesApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
        return false;
    }

    public static final class Payload
    extends RedfishApiPayload<Payload, SerialInterfacesApiOptions> {
        private String managerId;
        private String serialInterfaceId;
        private SerialInterfaceResource configData;

        public Payload(String ipAddress, AbstractLoggerWriter loggerWriter) {
            super(ipAddress, loggerWriter);
            this.setServiceOption(SerialInterfacesApiOptions.UNKNOWN);
        }

        public Payload(String ipAddress, String username, String password, AbstractLoggerWriter loggerWriter) {
            super(ipAddress, username, password, loggerWriter);
            this.setServiceOption(SerialInterfacesApiOptions.UNKNOWN);
        }

        @Override
        protected Payload getThis() {
            return this;
        }

        public SerialInterfacesApi build() {
            return new SerialInterfacesApi(this);
        }

        public String getManagerId() {
            return this.managerId;
        }

        public Payload setManagerId(String managerId) {
            this.managerId = managerId;
            return this.getThis();
        }

        public String getSerialInterfaceId() {
            return this.serialInterfaceId;
        }

        public Payload setSerialInterfaceId(String serialInterfaceId) {
            this.serialInterfaceId = serialInterfaceId;
            return this.getThis();
        }

        public SerialInterfaceResource getConfigData() {
            return this.configData;
        }

        public Payload setConfigData(SerialInterfaceResource configData) {
            this.configData = configData;
            return this.getThis();
        }
    }
}

