/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.rest.options;

import Gbt.core.jsonapi.JacksonCommonUtil;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.core.rest.RESTServicesOptions;
import Gbt.utility.Update.UpdateType;
import Gbt.utility.Update.fwInfo.BIOSUpdateFWInfo;
import Gbt.utility.Update.fwInfo.BMCUpdateFWInfo;
import Gbt.utility.Update.fwInfo.CPLDUpdateFWInfo;
import Gbt.utility.Update.fwInfo.PSUUpdateFWInfo;
import Gbt.utility.Update.fwInfo.SKUUpdateFWInfo;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.util.List;

public enum UpdateServiceOptions implements RESTServicesOptions
{
    UNKNOWN(UpdateType.UNKNOWN),
    BMC(UpdateType.BMC),
    BIOS(UpdateType.BIOS),
    CPLDBPB(UpdateType.CPLDBPB),
    CPLDMB(UpdateType.CPLDMB),
    PSU(UpdateType.PSU),
    SKU(UpdateType.SKU);

    private final UpdateType updateType;

    private UpdateServiceOptions(UpdateType updateType) {
        this.updateType = updateType;
    }

    @Override
    public String getOptionName() {
        return this.updateType.toString();
    }

    @Override
    public JavaType getRequestPayloadType() {
        switch (this) {
            case BMC: {
                return JacksonCommonUtil.getUtil().getTypeFactory().constructType(BMCUpdateFWInfo.class);
            }
            case BIOS: {
                return JacksonCommonUtil.getUtil().getTypeFactory().constructType(BIOSUpdateFWInfo.class);
            }
            case CPLDBPB: {
                return JacksonCommonUtil.getUtil().getTypeFactory().constructType(CPLDUpdateFWInfo.class);
            }
            case CPLDMB: {
                return JacksonCommonUtil.getUtil().getTypeFactory().constructType(CPLDUpdateFWInfo.class);
            }
            case PSU: {
                return JacksonCommonUtil.getUtil().getTypeFactory().constructType(PSUUpdateFWInfo.class);
            }
            case SKU: {
                return JacksonCommonUtil.getUtil().getTypeFactory().constructType(SKUUpdateFWInfo.class);
            }
        }
        return JacksonCommonUtil.getUtil().getTypeFactory().constructType(NullJSONData.class);
    }

    @Override
    public List<JavaType> getRequestPayloadTypes() {
        return null;
    }

    @Override
    public CollectionType getRequestPayloadCollectionType() {
        switch (this) {
            case BMC: {
                return JacksonCommonUtil.getUtil().getTypeFactory().constructCollectionType(List.class, BMCUpdateFWInfo.class);
            }
            case BIOS: {
                return JacksonCommonUtil.getUtil().getTypeFactory().constructCollectionType(List.class, BIOSUpdateFWInfo.class);
            }
            case CPLDBPB: {
                return JacksonCommonUtil.getUtil().getTypeFactory().constructCollectionType(List.class, CPLDUpdateFWInfo.class);
            }
            case CPLDMB: {
                return JacksonCommonUtil.getUtil().getTypeFactory().constructCollectionType(List.class, CPLDUpdateFWInfo.class);
            }
            case PSU: {
                return JacksonCommonUtil.getUtil().getTypeFactory().constructCollectionType(List.class, PSUUpdateFWInfo.class);
            }
            case SKU: {
                return JacksonCommonUtil.getUtil().getTypeFactory().constructCollectionType(List.class, SKUUpdateFWInfo.class);
            }
        }
        return JacksonCommonUtil.getUtil().getTypeFactory().constructCollectionType(List.class, NullJSONData.class);
    }

    @Override
    public List<CollectionType> getRequestPayloadCollectionTypes() {
        return null;
    }

    public static final UpdateServiceOptions parse(String optionName) {
        switch (UpdateType.parse(optionName)) {
            case BMC: 
            case CMC: {
                return BMC;
            }
            case BIOS: {
                return BIOS;
            }
            case CPLDBPB: {
                return CPLDBPB;
            }
            case CPLDMB: {
                return CPLDMB;
            }
            case PSU: {
                return PSU;
            }
            case SKU: {
                return SKU;
            }
        }
        return UNKNOWN;
    }

    public static final UpdateServiceOptions parse(UpdateType updateType) {
        switch (updateType) {
            case BMC: 
            case CMC: {
                return BMC;
            }
            case BIOS: {
                return BIOS;
            }
            case CPLDBPB: {
                return CPLDBPB;
            }
            case CPLDMB: {
                return CPLDMB;
            }
            case PSU: {
                return PSU;
            }
            case SKU: {
                return SKU;
            }
        }
        return UNKNOWN;
    }
}

