/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.rest.services;

import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.jsonapi.JacksonCommonUtil;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.core.loggers.AbstractLoggerWriter;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.rest.RESTException;
import Gbt.core.rest.RESTHttpMethods;
import Gbt.core.rest.RESTRequest;
import Gbt.core.rest.RESTRequestImpl;
import Gbt.core.rest.RESTServices;
import Gbt.core.rest.RESTServicesOptions;
import Gbt.utility.rest.models.fanprofile.AMIRestFanProfileArr;
import Gbt.utility.rest.models.fanprofile.AMIRestFanProfileRun;
import Gbt.utility.rest.models.fanprofile.AMIRestFanProfiles;
import java.io.File;
import java.util.List;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;

public final class FanProfileService
extends RESTServices {
    public static final String SERVICE_NAME = "fanprofile";
    private static final String FAN_PROFILE_URI = "/api/settings/fanprofile";
    private static final String FAN_PROFILE_COLLECTION_URI = "/api/settings/fanprofile/collection";
    private static final String FAN_RUN_URI = "/api/settings/fanprofile/mode";
    private AMIRestFanProfiles uploadFile;
    private AMIRestFanProfileRun uploadRunFile;

    public FanProfileService(AbstractLoggerWriter loggerWriter) {
        super(loggerWriter);
    }

    @Override
    public String getServiceName() {
        return SERVICE_NAME;
    }

    @Override
    public boolean readJsonData(AbstractJSONPOJO jsonData, RESTServicesOptions restServicesOptions) {
        return true;
    }

    @Override
    public boolean readJsonFiles(List<File> dataFiles, RESTServicesOptions restServicesOptions) {
        switch (restServicesOptions.getOptionName()) {
            case "post": {
                try {
                    this.uploadFile = (AMIRestFanProfiles)JacksonCommonUtil.getUtil().readJSONFile(dataFiles.get(0), restServicesOptions.getRequestPayloadType());
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
            case "run": {
                try {
                    this.uploadRunFile = (AMIRestFanProfileRun)JacksonCommonUtil.getUtil().readJSONFile(dataFiles.get(0), restServicesOptions.getRequestPayloadType());
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public boolean uploadFiles(List<File> uploadFiles, RESTServicesOptions restServicesOptions) {
        return true;
    }

    @Override
    public boolean execute(String ipAddress, RESTServicesOptions restServicesOptions) {
        String logName = ipAddress + "_" + this.logDirPath + "_" + this.getServiceName();
        switch (restServicesOptions.getOptionName()) {
            case "get": {
                try {
                    RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setCookies(this.sessionData)).setHostname(ipAddress)).setPort(this.bmcPort)).setHttpMethods(RESTHttpMethods.GET)).setServiceURI(FAN_PROFILE_COLLECTION_URI).setContentType("application/json")).build();
                    Response response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
                    List<AMIRestFanProfileArr> fanProfilelist = this.clientReceiver.deserialize(response, new GenericType<List<AMIRestFanProfileArr>>(){});
                    this.jsonResults.addAll(fanProfilelist);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Get fan profile success.");
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, logName, fanProfilelist.toString());
                    return true;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Get fan profile fail.");
                    this.restExceptionMessages(re, ipAddress, logName);
                    this.jsonResults.add(new NullJSONData().setError(true).setMessages("Get fan profile fail."));
                    return false;
                }
            }
            case "post": {
                try {
                    RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setCookies(this.sessionData)).setHostname(ipAddress)).setPort(this.bmcPort)).setHttpMethods(RESTHttpMethods.POST)).setServiceURI(FAN_PROFILE_URI).setContentType("application/json")).setRawJsonData(this.uploadFile)).build();
                    Response response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
                    AMIRestFanProfiles fanProfile = this.clientReceiver.deserialize(response, new GenericType<AMIRestFanProfiles>(){});
                    this.jsonResults.add(fanProfile);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Upload fan profile success.");
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, logName, fanProfile.toString());
                    return true;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Upload fan profile fail.");
                    this.restExceptionMessages(re, ipAddress, logName);
                    this.jsonResults.add(new NullJSONData().setError(true).setMessages("Upload fan profile fail."));
                    return false;
                }
            }
            case "run": {
                try {
                    RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setCookies(this.sessionData)).setHostname(ipAddress)).setPort(this.bmcPort)).setHttpMethods(RESTHttpMethods.POST)).setServiceURI(FAN_RUN_URI).setContentType("application/json")).setRawJsonData(this.uploadRunFile)).build();
                    Response response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
                    AMIRestFanProfileRun fanProfile = this.clientReceiver.deserialize(response, new GenericType<AMIRestFanProfileRun>(){});
                    this.jsonResults.add(fanProfile);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Run fan profile success.");
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, logName, fanProfile.toString());
                    return true;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Run fan profile fail.");
                    this.restExceptionMessages(re, ipAddress, logName);
                    this.jsonResults.add(new NullJSONData().setError(true).setMessages("Run fan profile fail."));
                    return false;
                }
            }
        }
        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Unknown option of " + this.getServiceName() + " service.");
        this.jsonResults.add(new NullJSONData().setError(true).setMessages("Unknown option of " + this.getServiceName() + " service."));
        return false;
    }
}

