/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.scan;

import Gbt.core.engines.AbstractSingleTask;
import Gbt.core.engines.records.EngineRecordStates;
import Gbt.core.engines.records.RmcpPingRecords;
import Gbt.core.ipmi.GbtIPMIConnector;
import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.receivers.GbtIPMICommandReceiver;
import Gbt.utility.bmclanconfig.BMCLanConfigCommand;
import Gbt.utility.bmclanconfig.BMCLanConfigData;
import Gbt.utility.bmclanconfig.BMCLanConfigIPMIOptions;
import Gbt.utility.scan.ScanCommand;
import com.veraxsystems.vxipmi.api.async.ConnectionHandle;
import com.veraxsystems.vxipmi.api.sync.IpmiConnector;
import com.veraxsystems.vxipmi.coding.commands.PrivilegeLevel;
import com.veraxsystems.vxipmi.coding.security.CipherSuite;
import com.veraxsystems.vxipmi.connection.ConnectionException;
import java.io.IOException;
import java.net.InetAddress;
import java.util.List;
import java.util.concurrent.CancellationException;

public final class RmcpPingTask
extends AbstractSingleTask {
    private RmcpPingRecords genericResult;
    private String currentIP;
    private String username;
    private String password;
    private boolean isPingOnly;

    protected RmcpPingTask(Builder taskBuilder) {
        super(taskBuilder);
        this.currentIP = taskBuilder.currentIP;
        this.username = taskBuilder.username;
        this.password = taskBuilder.password;
        this.genericResult = new RmcpPingRecords(this.taskID).setBMCIP(this.currentIP);
        this.isPingOnly = taskBuilder.isPingOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RmcpPingRecords call() throws CancellationException {
        RmcpPingRecords rmcpPingRecords;
        IpmiConnector ipmiConnector = null;
        ConnectionHandle handle = null;
        try {
            ipmiConnector = GbtIPMIConnector.getConnector();
            handle = ipmiConnector.createConnection(InetAddress.getByName(this.currentIP));
        }
        catch (IOException ioe) {
            return this.genericResult.setStates(EngineRecordStates.Fail);
        }
        try {
            ipmiConnector.sendRmcpPingMessage(handle);
            this.loggerWriter.appendPath("scan").writeLogs(GbtLogLevel.INFO, this.taskID, "[" + this.currentIP + "] RMCP ping success.");
        }
        catch (ConnectionException ce) {
            ipmiConnector.closeConnection(handle);
            this.loggerWriter.appendPath("scan").writeLogs(GbtLogLevel.ERROR, this.taskID, "[" + this.currentIP + "] RMCP ping fail.");
            return this.genericResult.setStates(EngineRecordStates.Fail);
        }
        if (this.isPingOnly) {
            ipmiConnector.closeConnection(handle);
            return this.genericResult.setStates(EngineRecordStates.Pass).setUsername(this.username).setPassword(this.password).setMacAddress("");
        }
        try {
            List<CipherSuite> css = ipmiConnector.getAvailableCipherSuites(handle);
            this.loggerWriter.appendPath("scan").writeLogs(GbtLogLevel.INFO, this.taskID, "[" + this.currentIP + "] Get the available cipher suite (3).");
            ipmiConnector.getChannelAuthenticationCapabilities(handle, css, PrivilegeLevel.Administrator);
            this.loggerWriter.appendPath("scan").writeLogs(GbtLogLevel.INFO, this.taskID, "[" + this.currentIP + "] Get channel authentication capabilities.");
            ipmiConnector.openSession(handle, this.username, this.password, null);
            this.loggerWriter.appendPath("scan").writeLogs(GbtLogLevel.INFO, this.taskID, "[" + this.currentIP + "] Open IPMI session success.");
            AbstractJSONPOJO resp = GbtIPMICommandReceiver.getInstance().sendIPMIRawCommand(handle, BMCLanConfigIPMIOptions.GET_MAC_ADDRESS, new BMCLanConfigCommand.Builder(), "scan", this.taskID);
            if (resp instanceof BMCLanConfigData) {
                String macAddress = resp.castConcreteJSON(BMCLanConfigData.class).getMacAddress();
                this.loggerWriter.appendPath("scan").writeLogs(GbtLogLevel.INFO, this.taskID, "[" + this.currentIP + "] Get MAC : " + macAddress);
                RmcpPingRecords rmcpPingRecords2 = this.genericResult.setStates(EngineRecordStates.Pass).setUsername(this.username).setPassword(this.password).setMacAddress(macAddress).setIsAccountPassCorrect(true);
                return rmcpPingRecords2;
            }
            RmcpPingRecords macAddress = this.genericResult.setStates(EngineRecordStates.Fail);
            return macAddress;
        }
        catch (ConnectionException ce) {
            this.loggerWriter.appendPath("scan").writeLogs(GbtLogLevel.ERROR, this.taskID, "[" + this.currentIP + "] Permission denied.");
            rmcpPingRecords = this.genericResult.setStates(EngineRecordStates.Fail).setUsername(this.username).setPassword(this.password).setIsAccountPassCorrect(false);
            return rmcpPingRecords;
        }
        catch (Exception e) {
            rmcpPingRecords = this.genericResult.setStates(EngineRecordStates.Fail);
            return rmcpPingRecords;
        }
        finally {
            if (handle != null) {
                try {
                    ipmiConnector.closeSession(handle);
                }
                catch (ConnectionException ce) {
                    this.loggerWriter.appendPath("scan").writeLogs(GbtLogLevel.ERROR, this.taskID, "[" + this.currentIP + "] No session opened.");
                }
                ipmiConnector.closeConnection(handle);
            }
        }
    }

    @Override
    public RmcpPingRecords getResult() {
        return this.genericResult;
    }

    @Override
    public void cancelConsideration() {
        this.loggerWriter.appendPath("scan").writeLogs(GbtLogLevel.INFO, this.taskID, "Cancel consideration.");
    }

    @Override
    public void close() throws Exception {
        this.taskID = null;
        this.currentIP = null;
        this.currentThread = null;
        this.loggerWriter.close();
    }

    public static final class Builder
    extends AbstractSingleTask.TaskBuilder<Builder> {
        private String currentIP;
        private String username;
        private String password;
        private boolean isPingOnly;

        @Override
        protected Builder getThis() {
            return this;
        }

        public RmcpPingTask build() {
            return new RmcpPingTask(this);
        }

        public Builder setBmcIP(String currentIP) {
            this.currentIP = currentIP;
            this.expandTaskID(this.currentIP + "_" + "scan" + "_" + ScanCommand.ScanType.RMCP.toString());
            return this.getThis();
        }

        public Builder setUsername(String username) {
            this.username = username;
            return this.getThis();
        }

        public Builder setPassword(String password) {
            this.password = password;
            return this.getThis();
        }

        public Builder setPingOnly(boolean isPingOnly) {
            this.isPingOnly = isPingOnly;
            return this.getThis();
        }
    }
}

