/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.solcmd;

import Gbt.core.commands.AbstractCommand;
import Gbt.core.commands.AbstractCommandBuilder;
import Gbt.core.engines.records.SolMessageRecords;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.receivers.SolCommandReceiver;
import Gbt.utility.solcmd.SolCmdData;
import com.veraxsystems.vxipmi.api.sol.SerialOverLan;
import com.veraxsystems.vxipmi.api.sol.SolEventListener;

public class SolCmdCommand
extends AbstractCommand<Builder> {
    public static final String COMMAND_NAME = "solcmd";
    private volatile SolCommandReceiver solCommandReceiver;
    private volatile SolEventListener solEventListener;

    protected SolCmdCommand(Builder commandArgs) {
        super(commandArgs);
        this.commandID = ((Builder)this.commandArgs).bmcIP + "_" + COMMAND_NAME;
        this.solCommandReceiver = SolCommandReceiver.getInstance();
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String getDocumentsName() {
        return COMMAND_NAME;
    }

    @Override
    public boolean checkAll() {
        if (!((Builder)this.commandArgs).checkArgs()) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Command arguments check fail.");
            return false;
        }
        if (this.solCommandReceiver == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI receiver is null.");
            return false;
        }
        return true;
    }

    @Override
    public boolean execute() {
        SerialOverLan serialOverLan = null;
        SolCmdData solCmdData = new SolCmdData();
        try {
            serialOverLan = this.solCommandReceiver.activateSol(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword, COMMAND_NAME);
        }
        catch (Exception e) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Activate SOL fail.");
            solCmdData.setMessage("Activate SOL fail.");
            return false;
        }
        this.solCommandReceiver.asyncSendCommand(serialOverLan, ((Builder)this.commandArgs).solCmd, COMMAND_NAME);
        solCmdData.setCommand(((Builder)this.commandArgs).solCmd);
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Send SOL command:");
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + ((Builder)this.commandArgs).solCmd);
        SolMessageRecords records = SolCommandReceiver.getInstance().getAsyncCommandRecords(serialOverLan);
        int count = 0;
        int tempLength = 0;
        boolean endReading = false;
        while (!endReading) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Waitting for response...");
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            count = tempLength == records.getFullMessages().length() ? ++count : 0;
            if (count > ((Builder)this.commandArgs).timeout) {
                endReading = true;
                continue;
            }
            tempLength = records.getFullMessages().length();
        }
        if (records.getFullMessages().length() <= 0) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] SOL comamnd no response.");
        } else {
            solCmdData.setResponse(records.getFullMessages());
        }
        try {
            SolCmdCommand solCmdCommand = this;
            solCmdCommand.solCommandReceiver.getInstance().deactivateSol(serialOverLan, COMMAND_NAME);
        }
        catch (Exception e) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Deactivate SOL fail.");
            solCmdData.setMessage("Deactivate SOL fail.");
            return false;
        }
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] SOL command success.");
        solCmdData.setResult(true);
        solCmdData.setMessage("SOL command success.");
        return true;
    }

    @Override
    public void cancelHook(Object obj) {
    }

    @Override
    public void close() throws Exception {
        ((Builder)this.commandArgs).close();
    }

    public static final class Builder
    extends AbstractCommandBuilder<Builder> {
        private String bmcIP;
        private String bmcUsername = "admin";
        private String bmcPassword = "password";
        private String solCmd = null;
        private int timeout = 3;

        @Override
        public boolean checkArgs() {
            if (this.bmcIP == null) {
                return false;
            }
            if (this.args != null) {
                for (int i = 0; i < this.args.length; ++i) {
                    if (this.args[i].startsWith("timeout=")) {
                        try {
                            this.timeout = Integer.parseInt(this.args[i].split("timeout=")[1]);
                        }
                        catch (Exception e) {
                            this.timeout = -1;
                        }
                        continue;
                    }
                    this.solCmd = this.args[i].length() == 2 ? "" : this.args[i];
                }
            }
            return this.solCmd != null && this.timeout >= 1;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        @Override
        public AbstractCommand<Builder> build() {
            return new SolCmdCommand(this);
        }

        @Override
        public void close() throws Exception {
            this.args = null;
            this.bmcIP = null;
            this.bmcUsername = null;
            this.bmcPassword = null;
            this.solCmd = null;
            this.loggerWriter.close();
        }

        public Builder setBMCIP(String bmcIP) {
            this.bmcIP = bmcIP;
            return this.getThis();
        }

        public Builder setBMCUsername(String bmcUsername) {
            this.bmcUsername = bmcUsername;
            return this.getThis();
        }

        public Builder setBMCPassword(String bmcPassword) {
            this.bmcPassword = bmcPassword;
            return this.getThis();
        }

        public Builder setSolCmd(String solCmd) {
            this.solCmd = solCmd;
            return this.getThis();
        }

        public Builder setTimeout(int timeout) {
            this.timeout = timeout;
            return this.getThis();
        }
    }
}

