/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.multipart.support;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import org.springframework.http.HttpHeaders;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.support.AbstractMultipartHttpServletRequest;

public class StandardMultipartHttpServletRequest
extends AbstractMultipartHttpServletRequest {
    private static final String CONTENT_DISPOSITION = "content-disposition";
    private static final String FILENAME_KEY = "filename=";

    public StandardMultipartHttpServletRequest(HttpServletRequest request) throws MultipartException {
        super(request);
        try {
            Collection parts = request.getParts();
            LinkedMultiValueMap files = new LinkedMultiValueMap(parts.size());
            for (Part part : parts) {
                String filename = this.extractFilename(part.getHeader(CONTENT_DISPOSITION));
                if (filename == null) continue;
                files.add((Object)part.getName(), (Object)new StandardMultipartFile(part, filename));
            }
            this.setMultipartFiles((MultiValueMap<String, MultipartFile>)files);
        }
        catch (Exception ex) {
            throw new MultipartException("Could not parse multipart servlet request", ex);
        }
    }

    private String extractFilename(String contentDisposition) {
        if (contentDisposition == null) {
            return null;
        }
        int startIndex = contentDisposition.indexOf(FILENAME_KEY);
        if (startIndex == -1) {
            return null;
        }
        String filename = contentDisposition.substring(startIndex + FILENAME_KEY.length());
        if (filename.startsWith("\"")) {
            int endIndex = filename.indexOf("\"", 1);
            if (endIndex != -1) {
                return filename.substring(1, endIndex);
            }
        } else {
            int endIndex = filename.indexOf(";");
            if (endIndex != -1) {
                return filename.substring(0, endIndex);
            }
        }
        return filename;
    }

    @Override
    public String getMultipartContentType(String paramOrFileName) {
        try {
            Part part = this.getPart(paramOrFileName);
            return part != null ? part.getContentType() : null;
        }
        catch (Exception ex) {
            throw new MultipartException("Could not access multipart servlet request", ex);
        }
    }

    @Override
    public HttpHeaders getMultipartHeaders(String paramOrFileName) {
        try {
            Part part = this.getPart(paramOrFileName);
            if (part != null) {
                HttpHeaders headers = new HttpHeaders();
                for (String headerName : part.getHeaderNames()) {
                    headers.put(headerName, new ArrayList<String>(part.getHeaders(headerName)));
                }
                return headers;
            }
            return null;
        }
        catch (Exception ex) {
            throw new MultipartException("Could not access multipart servlet request", ex);
        }
    }

    private static class StandardMultipartFile
    implements MultipartFile {
        private final Part part;
        private final String filename;

        public StandardMultipartFile(Part part, String filename) {
            this.part = part;
            this.filename = filename;
        }

        @Override
        public String getName() {
            return this.part.getName();
        }

        @Override
        public String getOriginalFilename() {
            return this.filename;
        }

        @Override
        public String getContentType() {
            return this.part.getContentType();
        }

        @Override
        public boolean isEmpty() {
            return this.part.getSize() == 0L;
        }

        @Override
        public long getSize() {
            return this.part.getSize();
        }

        @Override
        public byte[] getBytes() throws IOException {
            return FileCopyUtils.copyToByteArray((InputStream)this.part.getInputStream());
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.part.getInputStream();
        }

        @Override
        public void transferTo(File dest) throws IOException, IllegalStateException {
            this.part.write(dest.getPath());
        }
    }
}

