/*
 * Decompiled with CFR 0.152.
 */
package Gbt.core.engines.records;

import Gbt.core.commands.AbstractCommand;
import Gbt.core.engines.records.EngineRecordStates;
import Gbt.core.engines.records.EngineRecords;
import Gbt.core.jsonapi.AbstractJSONPOJO;
import java.util.ArrayList;
import java.util.List;

public final class CommandTaskRecords
extends EngineRecords {
    private final AbstractCommand<?> command;

    public CommandTaskRecords(AbstractCommand<?> command) {
        super(command.getCommandID());
        this.command = command;
    }

    @Override
    public CommandTaskRecords setStates(EngineRecordStates states) {
        this.states = states;
        return this;
    }

    public final AbstractCommand<?> getCommand() {
        return this.command;
    }

    public final <T extends AbstractCommand<?>> T getCommand(Class<T> clazz) {
        try {
            return (T)((AbstractCommand)clazz.cast(this.command));
        }
        catch (ClassCastException cce) {
            return null;
        }
    }

    public final String getTargetIP() {
        return this.getRecordsID().split("_")[0];
    }

    public final String getCommandName() {
        return this.command.getCommandName();
    }

    public final String getFinalElapsedTimes() {
        return this.command.getFinalElapsedTimes();
    }

    public final List<String> getLogMessages() {
        return this.command.getLogMessages();
    }

    public final String getLastLogMessage() {
        return this.command.getLastLogMessage();
    }

    public final List<AbstractJSONPOJO> getResultData() {
        return this.command.getCommandResults();
    }

    public <C extends AbstractJSONPOJO> List<C> getResultData(Class<C> clazz) {
        ArrayList<C> concreteCommandResults = new ArrayList<C>();
        if (this.command.getCommandResults().isEmpty()) {
            return concreteCommandResults;
        }
        for (AbstractJSONPOJO abstractJSONPOJO : this.command.getCommandResults()) {
            C temp = abstractJSONPOJO.castConcreteJSON(clazz);
            if (temp == null) continue;
            concreteCommandResults.add(temp);
        }
        return concreteCommandResults;
    }
}

