/*
 * Decompiled with CFR 0.152.
 */
package Gbt.core.engines.records;

import Gbt.core.engines.records.EngineRecordStates;
import Gbt.core.engines.records.EngineRecords;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class EngineGroupRecords {
    protected String groupID;
    protected EngineRecordStates groupStates;
    protected Map<String, EngineRecords> engineRecords;

    protected EngineGroupRecords(String groupID) {
        this.groupID = groupID;
        this.groupStates = EngineRecordStates.Fail;
        this.engineRecords = new ConcurrentHashMap<String, EngineRecords>();
    }

    public abstract void assemble(EngineRecords var1);

    public abstract EngineRecords searchSingleRecords(String var1);

    public boolean changeSingleRecordsStates(String singleRecordID, EngineRecordStates states) {
        if (this.engineRecords.containsKey(singleRecordID)) {
            this.engineRecords.get(singleRecordID).setStates(states);
            return true;
        }
        return false;
    }

    public int countRecords(EngineRecordStates states) {
        int count = 0;
        for (String taskID : this.engineRecords.keySet()) {
            if (!this.engineRecords.get(taskID).getStates().equals((Object)states)) continue;
            ++count;
        }
        return count;
    }

    public String getGroupID() {
        return this.groupID;
    }

    public EngineRecordStates getGroupStates() {
        return this.groupStates;
    }

    public EngineGroupRecords setGroupStates(EngineRecordStates groupStates) {
        this.groupStates = groupStates;
        return this;
    }

    public <T extends EngineGroupRecords> T castSubRecords(Class<T> clazz) {
        try {
            return (T)((EngineGroupRecords)clazz.cast(this));
        }
        catch (ClassCastException cce) {
            cce.printStackTrace();
            return null;
        }
    }
}

