/*
 * Decompiled with CFR 0.152.
 */
package Gbt.core.jsonapi;

import Gbt.core.jsonapi.GbtJsonModules;
import Gbt.utility.Common.GbtCommonConverters;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.main.JsonSchema;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;

public final class JacksonCommonUtil {
    private static final String JSON_V4_SCHEMA_IDENTIFIER = "http://json-schema.org/draft-04/schema#";
    private static final String JSON_SCHEMA_IDENTIFIER_ELEMENT = "$schema";
    private static JacksonCommonUtil instance;
    private volatile ObjectMapper mapper = new ObjectMapper();
    private volatile DefaultPrettyPrinter dpp;

    private JacksonCommonUtil() {
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
        this.mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        this.mapper.enable(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);
        this.mapper.enable(DeserializationFeature.READ_ENUMS_USING_TO_STRING);
        this.mapper.registerModule((Module)new JodaModule());
        this.mapper.registerModule((Module)new GbtJsonModules());
        this.mapper.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        this.dpp = new DefaultPrettyPrinter();
        this.dpp.indentArraysWith((DefaultPrettyPrinter.Indenter)DefaultIndenter.SYSTEM_LINEFEED_INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final JacksonCommonUtil getUtil() {
        if (instance != null) return instance;
        Class<JacksonCommonUtil> clazz = JacksonCommonUtil.class;
        synchronized (JacksonCommonUtil.class) {
            if (instance != null) return instance;
            instance = new JacksonCommonUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean close() {
        if (instance != null) {
            JacksonCommonUtil jacksonCommonUtil = this;
            synchronized (jacksonCommonUtil) {
                if (instance != null) {
                    try {
                        this.mapper = null;
                        this.dpp = null;
                        instance = null;
                        return true;
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
                return true;
            }
        }
        return true;
    }

    public final String getPrettyPrintString(Object obj) {
        try {
            return this.mapper.writer((PrettyPrinter)this.dpp).writeValueAsString(obj);
        }
        catch (JsonProcessingException jpe) {
            return jpe.getMessage();
        }
    }

    public final TypeFactory getTypeFactory() {
        return this.mapper.getTypeFactory();
    }

    public <T> T jsonNodeToPojo(JsonNode jsonNode, Class<T> clazz) throws JsonProcessingException {
        return (T)this.mapper.treeToValue((TreeNode)jsonNode, clazz);
    }

    public final <T> T readJSONFile(File jsonFilePath, JavaType javaType) throws IOException {
        return (T)this.mapper.readValue(jsonFilePath, javaType);
    }

    public final <T> List<T> readJSONArrayFile(File jsonFilePath, CollectionType javaType) throws IOException {
        return (List)this.mapper.readValue(jsonFilePath, (JavaType)javaType);
    }

    public final <T> T readJSONFile(File jsonFilePath, Class<T> type) throws IOException {
        return (T)this.mapper.readValue(jsonFilePath, type);
    }

    public final <T> List<T> readJSONArrayFile(File jsonFilePath, Class<T> type) throws IOException {
        return (List)this.mapper.readValue(jsonFilePath, (JavaType)this.mapper.getTypeFactory().constructCollectionType(List.class, type));
    }

    public final <T> T readJsonStrings(String contexts, Class<T> type) throws IOException {
        return (T)this.mapper.readValue(contexts, type);
    }

    public final void writeJSONFile(File outputFile, Object obj) throws IOException {
        if (outputFile.exists()) {
            outputFile.delete();
        }
        if (outputFile.getParentFile() != null && !outputFile.getParentFile().exists()) {
            outputFile.getParentFile().mkdirs();
        }
        FileOutputStream outputStream = new FileOutputStream(outputFile);
        this.mapper.writer((PrettyPrinter)this.dpp).writeValue((OutputStream)outputStream, obj);
        outputStream.close();
    }

    public final void writeJSONFile(String outputFile, Object obj) throws IOException {
        if (!outputFile.endsWith(".json")) {
            outputFile = outputFile + ".json";
        }
        this.writeJSONFile(GbtCommonConverters.stringToJavaIoFile(outputFile), obj);
    }

    public JsonNode readRootNode(String contexts) throws IOException {
        return this.mapper.readTree(contexts);
    }

    public JsonNode readRootNode(byte[] bytes) throws IOException {
        return this.mapper.readTree(bytes);
    }

    public JsonNode readRootNode(File file) throws IOException {
        return this.mapper.readTree(file);
    }

    public JsonNode readRootNode(URL url) throws IOException {
        return this.mapper.readTree(url);
    }

    public JsonNode readRootNode(InputStream inputStream) throws IOException {
        return this.mapper.readTree(inputStream);
    }

    public JsonNode readRootNode(Object obj) {
        return this.mapper.valueToTree(obj);
    }

    public JsonSchema readJsonSchemaNode(String schemaText) throws IOException, ProcessingException {
        return this.readJsonSchemaNode(this.mapper.readTree(schemaText));
    }

    public JsonSchema readJsonSchemaNode(File schemaFile) throws IOException, ProcessingException {
        return this.readJsonSchemaNode(this.mapper.readTree(schemaFile));
    }

    public JsonSchema readJsonSchemaNode(URL schemaUrl) throws IOException, ProcessingException {
        return this.readJsonSchemaNode(this.mapper.readTree(schemaUrl));
    }

    public JsonSchema readJsonSchemaNode(byte[] schemaBytes) throws IOException, ProcessingException {
        return this.readJsonSchemaNode(this.mapper.readTree(schemaBytes));
    }

    public JsonSchema readJsonSchemaNode(InputStream schemaStream) throws IOException, ProcessingException {
        return this.readJsonSchemaNode(this.mapper.readTree(schemaStream));
    }

    public JsonSchema readJsonSchemaNode(Object schemaPojo) throws ProcessingException {
        return this.readJsonSchemaNode(this.mapper.valueToTree(schemaPojo));
    }

    public boolean isJsonValid(String schemaText, String jsonText) throws IOException, ProcessingException {
        return this.isJsonValid(this.readJsonSchemaNode(schemaText), this.readRootNode(jsonText));
    }

    public boolean isJsonValid(File schemaFile, File jsonFile) throws IOException, ProcessingException {
        return this.isJsonValid(this.readJsonSchemaNode(schemaFile), this.readRootNode(jsonFile));
    }

    public boolean isJsonValid(URL schemaURL, URL jsonURL) throws IOException, ProcessingException {
        return this.isJsonValid(this.readJsonSchemaNode(schemaURL), this.readRootNode(jsonURL));
    }

    public boolean isJsonValid(byte[] schemaBytes, byte[] jsonBytes) throws IOException, ProcessingException {
        return this.isJsonValid(this.readJsonSchemaNode(schemaBytes), this.readRootNode(jsonBytes));
    }

    public boolean isJsonValid(InputStream schemaStream, InputStream jsonStream) throws IOException, ProcessingException {
        return this.isJsonValid(this.readJsonSchemaNode(schemaStream), this.readRootNode(jsonStream));
    }

    public boolean isJsonValid(JsonSchema jsonSchema, String jsonText) throws IOException, ProcessingException {
        return this.isJsonValid(jsonSchema, this.readRootNode(jsonText));
    }

    public boolean isJsonValid(JsonSchema jsonSchema, File jsonFile) throws IOException, ProcessingException {
        return this.isJsonValid(jsonSchema, this.readRootNode(jsonFile));
    }

    public boolean isJsonValid(JsonSchema jsonSchema, URL jsonURL) throws IOException, ProcessingException {
        return this.isJsonValid(jsonSchema, this.readRootNode(jsonURL));
    }

    public boolean isJsonValid(JsonSchema jsonSchema, byte[] jsonBytes) throws IOException, ProcessingException {
        return this.isJsonValid(jsonSchema, this.readRootNode(jsonBytes));
    }

    public boolean isJsonValid(JsonSchema jsonSchema, InputStream jsonStream) throws IOException, ProcessingException {
        return this.isJsonValid(jsonSchema, this.readRootNode(jsonStream));
    }

    public ProcessingReport validateJson(String schemaText, String jsonText) throws IOException, ProcessingException {
        return this.validateJson(this.readJsonSchemaNode(schemaText), this.readRootNode(jsonText));
    }

    public ProcessingReport validateJson(File schemaFile, File jsonFile) throws IOException, ProcessingException {
        return this.validateJson(this.readJsonSchemaNode(schemaFile), this.readRootNode(jsonFile));
    }

    public ProcessingReport validateJson(URL schemaURL, URL jsonURL) throws IOException, ProcessingException {
        return this.validateJson(this.readJsonSchemaNode(schemaURL), this.readRootNode(jsonURL));
    }

    public ProcessingReport validateJson(byte[] schemaBytes, byte[] jsonBytes) throws IOException, ProcessingException {
        return this.validateJson(this.readJsonSchemaNode(schemaBytes), this.readRootNode(jsonBytes));
    }

    public ProcessingReport validateJson(InputStream schemaStream, InputStream jsonStream) throws IOException, ProcessingException {
        return this.validateJson(this.readJsonSchemaNode(schemaStream), this.readRootNode(jsonStream));
    }

    public ProcessingReport validateJson(JsonSchema jsonSchema, String jsonText) throws IOException, ProcessingException {
        return this.validateJson(jsonSchema, this.readRootNode(jsonText));
    }

    public ProcessingReport validateJson(JsonSchema jsonSchema, File jsonFile) throws IOException, ProcessingException {
        return this.validateJson(jsonSchema, this.readRootNode(jsonFile));
    }

    public ProcessingReport validateJson(JsonSchema jsonSchema, URL jsonURL) throws IOException, ProcessingException {
        return this.validateJson(jsonSchema, this.readRootNode(jsonURL));
    }

    public ProcessingReport validateJson(JsonSchema jsonSchema, byte[] jsonBytes) throws IOException, ProcessingException {
        return this.validateJson(jsonSchema, this.readRootNode(jsonBytes));
    }

    public ProcessingReport validateJson(JsonSchema jsonSchema, InputStream jsonStream) throws IOException, ProcessingException {
        return this.validateJson(jsonSchema, this.readRootNode(jsonStream));
    }

    public JsonSchema readJsonSchemaNode(JsonNode jsonNode) throws ProcessingException {
        JsonNode schemaIdentifier = jsonNode.get(JSON_SCHEMA_IDENTIFIER_ELEMENT);
        if (null == schemaIdentifier) {
            ((ObjectNode)jsonNode).put(JSON_SCHEMA_IDENTIFIER_ELEMENT, JSON_V4_SCHEMA_IDENTIFIER);
        }
        JsonSchemaFactory factory = JsonSchemaFactory.byDefault();
        return factory.getJsonSchema(jsonNode);
    }

    public boolean isJsonValid(JsonSchema jsonSchema, JsonNode jsonNode) throws ProcessingException {
        return jsonSchema.validate(jsonNode).isSuccess();
    }

    public ProcessingReport validateJson(JsonSchema jsonSchema, JsonNode jsonNode) throws ProcessingException {
        return jsonSchema.validate(jsonNode);
    }
}

