/*
 * Decompiled with CFR 0.152.
 */
package Gbt.core.rest;

import com.fasterxml.jackson.annotation.JsonValue;

public enum RESTHttpMethods {
    Unsupport("Unsupport"),
    GET("GET"),
    POST("POST"),
    PUT("PUT"),
    PATCH("PATCH"),
    DELETE("DELETE");

    private static final String UNSUPPORT_ITEM = "Unsupport";
    private static final String GET_ITEM = "GET";
    private static final String POST_ITEM = "POST";
    private static final String PUT_ITEM = "PUT";
    private static final String PATCH_ITEM = "PATCH";
    private static final String DELETE_ITEM = "DELETE";
    private final String item;

    private RESTHttpMethods(String item) {
        this.item = item;
    }

    @JsonValue
    public String toString() {
        return this.item;
    }

    public boolean isGET() {
        return this.item.equals(GET_ITEM);
    }

    public boolean isPOST() {
        return this.item.equals(POST_ITEM);
    }

    public boolean isPUT() {
        return this.item.equals(PUT_ITEM);
    }

    public boolean isDELETE() {
        return this.item.equals(DELETE_ITEM);
    }

    public boolean isPATCH() {
        return this.item.equals(PATCH_ITEM);
    }

    public boolean isUnsupport() {
        return this.item.equals(UNSUPPORT_ITEM);
    }

    public static final RESTHttpMethods parse(String method) {
        if (method == null) {
            return Unsupport;
        }
        switch (method.toUpperCase()) {
            case "GET": {
                return GET;
            }
            case "POST": {
                return POST;
            }
            case "PUT": {
                return PUT;
            }
            case "PATCH": {
                return PATCH;
            }
            case "DELETE": {
                return DELETE;
            }
        }
        return Unsupport;
    }
}

