/*
 * Decompiled with CFR 0.152.
 */
package Gbt.core.vmedia.isocaching;

import Gbt.core.vmedia.isocaching.ReadAheadCache;

public class CacheManager
extends Thread {
    public static final int MAX_FREE_BANKS_COUNT = 128;
    private ReadAheadCache readAheadCache = null;
    private int freeBankCount = 256;
    private boolean running = false;
    private boolean sortCache = false;
    private boolean cleanUpCache = false;

    public CacheManager(ReadAheadCache readAheadCache) {
        this.readAheadCache = readAheadCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.running) {
            Object object = this.readAheadCache.getCacheLock();
            synchronized (object) {
                if (this.isCleanUpCache()) {
                    this.readAheadCache.setCacheLocked(true);
                    this.cleanUpCache();
                    this.readAheadCache.setCacheLocked(false);
                    this.readAheadCache.getCacheLock().notifyAll();
                    this.setCleanUpCache(false);
                }
                try {
                    this.readAheadCache.getCacheLock().wait();
                }
                catch (InterruptedException ie) {
                    ie.getMessage();
                }
            }
        }
    }

    public void cleanUpCache() {
        int bankCount;
        for (bankCount = 0; bankCount < 128 && this.readAheadCache.getSectorDataCache().size() > 0; ++bankCount) {
            try {
                this.readAheadCache.getSectorDataCache().removeLast().getSectorKey();
                continue;
            }
            catch (Exception e) {
                break;
            }
        }
        this.setFreeBankCount(bankCount);
        System.gc();
    }

    public void startThread() {
        this.running = true;
        this.start();
    }

    public void stopThread() {
        this.running = false;
    }

    public int getFreeBankCount() {
        return this.freeBankCount;
    }

    public void setFreeBankCount(int freeBankCount) {
        this.freeBankCount = freeBankCount;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public boolean isSortCache() {
        return this.sortCache;
    }

    public void setSortCache(boolean sortCache) {
        this.sortCache = sortCache;
    }

    public boolean isCleanUpCache() {
        return this.cleanUpCache;
    }

    public void setCleanUpCache(boolean cleanUpCache) {
        this.cleanUpCache = cleanUpCache;
    }
}

