/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.Chassis;

import com.fasterxml.jackson.annotation.JsonValue;
import com.veraxsystems.vxipmi.common.TypeConverter;

public enum ChassisLastPowerEvent {
    None("None"),
    IpmiPowerOn("IPMI Power On"),
    PowerFault("Power Fault"),
    Interlock("Inter lock"),
    PowerOverload("Power Overload"),
    ACFailed("AC Failed");

    private final String item;

    private ChassisLastPowerEvent(String item) {
        this.item = item;
    }

    @JsonValue
    public String toString() {
        return this.item;
    }

    public static final ChassisLastPowerEvent parse(byte lastPowerEvent) {
        for (int i = 0; i < 5; ++i) {
            byte val = (byte)(lastPowerEvent & TypeConverter.intToByte(1 << i));
            switch (val) {
                case 1: {
                    return ACFailed;
                }
                case 2: {
                    return PowerOverload;
                }
                case 4: {
                    return Interlock;
                }
                case 8: {
                    return PowerFault;
                }
                case 16: {
                    return IpmiPowerOn;
                }
            }
        }
        return None;
    }
}

