/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.Common;

import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class FileWriteThread
implements Runnable {
    private String FileName = null;
    private String Errmsg = null;
    private BufferedWriter bw = null;
    private FileWriter src = null;
    private boolean status = false;
    private boolean error = false;
    private boolean append = false;
    private String exception = "";
    private String exceptionMessage = "";
    private List<String> records = new ArrayList<String>();

    public void setFileName(String TempName) {
        this.FileName = TempName;
    }

    public void setErrmsg() {
        this.Errmsg = null;
    }

    public void setAppend(boolean TempAppend) {
        this.append = TempAppend;
    }

    public String getErrmsg() {
        return this.Errmsg;
    }

    public BufferedWriter getBufferWrite() {
        return this.bw;
    }

    public synchronized boolean isCompleted() {
        return this.status;
    }

    public void setCompleted(boolean sts) {
        this.status = sts;
    }

    public void setRecords(ArrayList<String> WriteRecords) {
        this.records = WriteRecords;
    }

    public boolean isError() {
        return this.error;
    }

    public String getException() {
        return this.exception;
    }

    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        FileWriteThread fileWriteThread = this;
        synchronized (fileWriteThread) {
            try {
                this.src = new FileWriter(this.FileName, this.append);
                this.bw = new BufferedWriter(this.src);
                for (String d : this.records) {
                    this.bw.write(d);
                }
                this.bw.close();
                this.status = true;
                this.Errmsg = "ok";
            }
            catch (FileNotFoundException e) {
                System.out.println("No file write in Thread");
                this.status = true;
                this.error = true;
                this.bw = null;
                this.records = null;
                this.exception = "FileNotFoundException";
                this.exceptionMessage = e.getMessage();
                this.Errmsg = "No File";
            }
            catch (IOException e) {
                System.out.println("IO exception in Thread");
                this.status = true;
                this.error = true;
                this.bw = null;
                this.records = null;
                this.exception = "IOException";
                this.exceptionMessage = e.getMessage();
                this.Errmsg = "IOException";
            }
        }
    }
}

