/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.Common;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public final class SortFilesTool {
    private static final int FILE_DATE = 1;
    private static final int FILE_LENGTH = 2;
    private static final int FILE_NAME = 3;

    private SortFilesTool() {
    }

    public static final List<File> sort(SortOptions option, File filePath, boolean asc) {
        switch (option.getCode()) {
            case 1: {
                return SortFilesTool.sortByDate(filePath, asc);
            }
            case 2: {
                return SortFilesTool.sortByLength(filePath, asc);
            }
            case 3: {
                return SortFilesTool.sortByName(filePath, asc);
            }
        }
        return SortFilesTool.sortByName(filePath, asc);
    }

    public static final List<File> sortByLength(File filePath, final boolean asc) {
        ArrayList<File> aryList = new ArrayList<File>();
        if (!SortFilesTool.filePathCheckout(filePath)) {
            return aryList;
        }
        List<File> fileList = Arrays.asList(filePath.listFiles());
        if (!fileList.isEmpty()) {
            Collections.sort(fileList, new Comparator<File>(){

                @Override
                public int compare(File f1, File f2) {
                    long diffLen = f1.length() - f2.length();
                    if (asc) {
                        if (diffLen > 0L) {
                            return -1;
                        }
                        if (diffLen == 0L) {
                            return 0;
                        }
                        return 1;
                    }
                    if (diffLen > 0L) {
                        return 1;
                    }
                    if (diffLen == 0L) {
                        return 0;
                    }
                    return -1;
                }

                @Override
                public boolean equals(Object obj) {
                    return true;
                }
            });
            aryList.addAll(fileList);
        }
        return aryList;
    }

    public static final List<File> sortByName(File filePath, final boolean asc) {
        ArrayList<File> aryList = new ArrayList<File>();
        if (!SortFilesTool.filePathCheckout(filePath)) {
            return aryList;
        }
        List<File> fileList = Arrays.asList(filePath.listFiles());
        if (!fileList.isEmpty()) {
            Collections.sort(fileList, new Comparator<File>(){

                @Override
                public int compare(File f1, File f2) {
                    if (f1.isDirectory() && f2.isFile()) {
                        return -1;
                    }
                    if (f1.isFile() && f2.isDirectory()) {
                        return 1;
                    }
                    if (asc) {
                        return f1.getName().compareTo(f2.getName());
                    }
                    return f2.getName().compareTo(f1.getName());
                }
            });
            aryList.addAll(fileList);
        }
        return aryList;
    }

    public static final List<File> sortByDate(File filePath, final boolean asc) {
        ArrayList<File> aryList = new ArrayList<File>();
        if (!SortFilesTool.filePathCheckout(filePath)) {
            return aryList;
        }
        File[] fs = filePath.listFiles();
        if (fs.length != 0) {
            Arrays.sort(fs, new Comparator<File>(){

                @Override
                public int compare(File f1, File f2) {
                    long diffDate = f1.lastModified() - f2.lastModified();
                    if (asc) {
                        if (diffDate > 0L) {
                            return 1;
                        }
                        if (diffDate == 0L) {
                            return 0;
                        }
                        return -1;
                    }
                    if (diffDate > 0L) {
                        return -1;
                    }
                    if (diffDate == 0L) {
                        return 0;
                    }
                    return 1;
                }

                @Override
                public boolean equals(Object obj) {
                    return true;
                }
            });
            for (int i = fs.length - 1; i > -1; --i) {
                aryList.add(fs[i]);
            }
        }
        return aryList;
    }

    private static final boolean filePathCheckout(File filePath) {
        if (filePath == null) {
            System.out.println("The given file path instance is null.");
            return false;
        }
        if (!filePath.exists()) {
            System.out.println("The given file path not exists.");
            return false;
        }
        if (!filePath.isDirectory()) {
            System.out.println("The given file path not a directory.");
            return false;
        }
        return true;
    }

    public static enum SortOptions {
        Date(1),
        Length(2),
        Name(3);

        public static final int FILE_DATE = 1;
        public static final int FILE_LENGTH = 2;
        public static final int FILE_NAME = 3;
        private final int code;

        private SortOptions(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static final SortOptions parserOptionsByName(String name) {
            if (name == null) {
                throw new IllegalArgumentException("The given options name is null");
            }
            switch (name) {
                case "date": {
                    return Date;
                }
                case "length": {
                    return Length;
                }
                case "name": {
                    return Name;
                }
            }
            throw new IllegalArgumentException("The given options name " + name + " is invalid.");
        }
    }
}

