/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.Configdeploy;

import Gbt.core.engines.records.CommandTaskRecords;
import Gbt.core.engines.records.EngineRecordStates;
import Gbt.core.engines.records.SSHCmdRecords;
import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.loggers.AbstractLoggerWriter;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.receivers.GbtIPMICommandReceiver;
import Gbt.core.receivers.GbtLocalCommandReceiver;
import Gbt.core.receivers.GbtSSHCommandReceiver;
import Gbt.utility.Chassis.PowerCommand;
import Gbt.utility.Common.CommonFunction;
import Gbt.utility.LoadDefault.LoadDefaultCommand;
import Gbt.utility.bmcinfo.BMCVendor;
import Gbt.utility.bootoptions.BootOptions;
import Gbt.utility.maclist.GetMACListCommand;
import Gbt.utility.maclist.LANMacData;
import Gbt.utility.rest.models.vmcli.AMIRestVmcliImages;
import Gbt.utility.rest.options.VmcliServiceOptions;
import Gbt.utility.rest.services.VmcliUtilService;
import Gbt.utility.vmclitool.VmcliMountInfo;
import com.jcraft.jsch.Session;
import com.veraxsystems.vxipmi.api.async.ConnectionHandle;
import com.veraxsystems.vxipmi.coding.commands.chassis.GetChassisStatusResponseData;
import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;

public class ConfigItems {
    private DateTime startTime;
    private String totalElapsedTimes;
    private String dataLANIP;
    private boolean isAMI;
    private File debugFile;
    private static final String SSHACCOUNT = "root";
    private static final String SSHPASSWORD = "111111";
    private String commandName;
    private String commandID;
    private GbtIPMICommandReceiver ipmiReceiver;
    private GbtLocalCommandReceiver localReceiver;
    private GbtSSHCommandReceiver sshReceiver;
    private AbstractLoggerWriter loggerWriter;
    private static final PeriodFormatter ELAPSED_TIME_FORMATTER = new PeriodFormatterBuilder().appendHours().appendSuffix(" hours, ").appendMinutes().appendSuffix(" mins, ").printZeroAlways().appendSeconds().appendSuffix(".").printZeroAlways().appendMillis3Digit().appendSuffix(" sec.").toFormatter();

    public ConfigItems(DateTime startTime, AbstractLoggerWriter loggerWriter, File debugFile, String commandName, String commandID) {
        this.startTime = startTime;
        this.isAMI = false;
        this.ipmiReceiver = GbtIPMICommandReceiver.getInstance();
        this.sshReceiver = GbtSSHCommandReceiver.getInstance();
        this.localReceiver = GbtLocalCommandReceiver.getInstance();
        this.loggerWriter = loggerWriter;
        this.debugFile = debugFile;
        this.commandName = commandName;
        this.commandID = commandID;
    }

    public void close() {
        this.startTime = null;
        this.totalElapsedTimes = null;
        this.dataLANIP = null;
        this.loggerWriter = null;
        this.commandName = null;
        this.commandID = null;
    }

    public boolean checkIsAMI(String bmcIP, String bmcUsername, String bmcPassword) {
        ConnectionHandle handle = this.ipmiReceiver.createIPMIConnection(bmcIP, bmcUsername, bmcPassword, this.commandName, this.commandID);
        if (handle == null) {
            return false;
        }
        this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + bmcIP + "] Start to config deploy.");
        BMCVendor bmcVendor = this.ipmiReceiver.getBmcVendor(handle, this.commandName, this.commandID);
        switch (bmcVendor) {
            case VERTIV: {
                this.ipmiReceiver.closeIPMIConnection(handle, this.commandName, this.commandID);
                this.isAMI = false;
                return true;
            }
            case AMI: {
                this.ipmiReceiver.closeIPMIConnection(handle, this.commandName, this.commandID);
                this.isAMI = true;
                return true;
            }
            case OPENBMC: {
                this.ipmiReceiver.closeIPMIConnection(handle, this.commandName, this.commandID);
                this.isAMI = false;
                return false;
            }
        }
        this.ipmiReceiver.closeIPMIConnection(handle, this.commandName, this.commandID);
        return false;
    }

    public boolean bootIntoMiniOS(boolean isUEFI, String bmcIP, String bmcUsername, String bmcPassword, String absConfigPkgPath, String miniOSISOName, String serverIP) {
        if (!this.mountMiniOS(this.isAMI, bmcIP, bmcUsername, bmcPassword, miniOSISOName, serverIP)) {
            this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandID, "Mount miniOS ISO fail!");
            return false;
        }
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ConnectionHandle handle = this.ipmiReceiver.createIPMIConnection(bmcIP, bmcUsername, bmcPassword, this.commandName, this.commandID);
        if (handle == null) {
            this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandID, "Create IPMI connection fail!");
            return false;
        }
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.isAMI) {
            this.ipmiReceiver.setBootOption(handle, BootOptions.VMCDROM, isUEFI, this.commandName, this.commandID);
        } else if (isUEFI) {
            this.ipmiReceiver.setBootOption(handle, BootOptions.CDROM, isUEFI, this.commandName, this.commandID);
        } else {
            this.ipmiReceiver.setBootOption(handle, BootOptions.VMCDROM, isUEFI, this.commandName, this.commandID);
        }
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.forcePowerONorCycle(handle);
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Map<String, String> macs = this.get3LANMACs(bmcIP, bmcUsername, bmcPassword);
        if (macs == null) {
            this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandID, "Get 3 net mac fail!");
            this.ipmiReceiver.closeIPMIConnection(handle, this.commandName, this.commandID);
            return false;
        }
        this.dataLANIP = this.waitBootComplete(macs, bmcIP, SSHACCOUNT, SSHPASSWORD, handle);
        if (this.dataLANIP.equals("0.0.0.0")) {
            this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandID, "Boot into miniOS fail!");
            this.ipmiReceiver.closeIPMIConnection(handle, this.commandName, this.commandID);
            return false;
        }
        if (!this.unmountMiniOS(this.isAMI, bmcIP, bmcUsername, bmcPassword, miniOSISOName, serverIP)) {
            this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandID, "Unmount miniOS ISO fail!");
            this.ipmiReceiver.closeIPMIConnection(handle, this.commandName, this.commandID);
            return false;
        }
        if (!this.transportConfigPkg(this.dataLANIP, absConfigPkgPath)) {
            this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandID, "Transport config package fail!");
            this.ipmiReceiver.closeIPMIConnection(handle, this.commandName, this.commandID);
            return false;
        }
        this.ipmiReceiver.closeIPMIConnection(handle, this.commandName, this.commandID);
        return true;
    }

    public boolean updateBMC(String firmwareName, int timeout) {
        Session session = this.sshReceiver.openSession(this.dataLANIP, SSHACCOUNT, SSHPASSWORD, this.commandName, this.commandID);
        SSHCmdRecords sshRecords = this.sshReceiver.executeCMD(session, "cd /tmp/configPkg/configUtil/scripts/ ; ./updateBMC.sh /tmp/configPkg/configs/bmc/" + firmwareName + " > foo.out 2> foo.err < /dev/null &", false, this.commandName, this.commandID);
        boolean success = false;
        while (!success && !this.isOverTime(timeout)) {
            this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + this.commandID + "] Waitting BMC update complete...[" + this.getElapsedTimes() + "]");
            sshRecords = this.sshReceiver.executeCMD(session, "cat /tmp/configPkg/configUtil/scripts/BMCupdateInfo.log", true, this.commandName, this.commandID);
            if (sshRecords.getResults().contains("Update BMC success")) {
                success = true;
            } else if (sshRecords.getResults().contains("Update BMC fail")) {
                success = false;
                break;
            }
            try {
                Thread.sleep(15000L);
            }
            catch (InterruptedException ie) {
                this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.WARN, this.commandID, "Interrupt the process of waitting BMC update complete.");
                break;
            }
        }
        if (success) {
            this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.INFO, this.commandID, "Update BMC Sucess! [" + this.getElapsedTimes() + "]");
        } else {
            this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandID, "Update BMC fail! [" + this.getElapsedTimes() + "]");
        }
        this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.TRACE, this.commandID, "====== Content of BMCUpdateInfo.log ======");
        this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.TRACE, this.commandID, sshRecords.getResults());
        this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.TRACE, this.commandID, "==========================================");
        this.sshReceiver.closeSession(session);
        return success;
    }

    public boolean updateBIOS(String firmwareName, int timeout) {
        Session session = this.sshReceiver.openSession(this.dataLANIP, SSHACCOUNT, SSHPASSWORD, this.commandName, this.commandID);
        SSHCmdRecords sshRecords = this.sshReceiver.executeCMD(session, "cd /tmp/configPkg/configUtil/scripts/ ; ./updateBIOS.sh /tmp/configPkg/configs/bios/" + firmwareName + " > foo.out 2> foo.err < /dev/null &", false, this.commandName, this.commandID);
        boolean success = false;
        while (!success && !this.isOverTime(timeout)) {
            this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + this.commandID + "] Waitting BIOS update complete...");
            sshRecords = this.sshReceiver.executeCMD(session, "cat /tmp/configPkg/configUtil/scripts/BIOSupdateInfo.log", true, this.commandName, this.commandID);
            if (sshRecords.getResults().contains("Update BIOS success")) {
                success = true;
            } else if (sshRecords.getResults().contains("Update BIOS fail")) {
                success = false;
                break;
            }
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException ie) {
                this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.WARN, this.commandID, "Interrupt the process of waitting BIOS update complete.");
                break;
            }
        }
        if (success) {
            this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.INFO, this.commandID, "Update BIOS Sucess!");
        } else {
            this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandID, "Update BIOS fail!");
        }
        this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.TRACE, this.commandID, "====== Content of BIOSUpdateInfo.log ======");
        this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.TRACE, this.commandID, sshRecords.getResults());
        this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.TRACE, this.commandID, "==========================================");
        this.sshReceiver.closeSession(session);
        return success;
    }

    public boolean restoreBMC(String bmcIP, String bmcUsername, String bmcPassword) {
        LoadDefaultCommand loaddf = ((LoadDefaultCommand.Builder)new LoadDefaultCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword).setCommandLineArgs(new String[]{"bmc"})).build();
        return loaddf.execute();
    }

    public boolean configRestore(String restoreItem, String configDeployScript, int timeout) {
        String scriptParameter = "";
        Session session = this.sshReceiver.openSession(this.dataLANIP, SSHACCOUNT, SSHPASSWORD, this.commandName, this.commandID);
        scriptParameter = !configDeployScript.equals("") ? "./configRestore " + configDeployScript : "./configRestore";
        SSHCmdRecords sshRecords = this.sshReceiver.executeCMD(session, "cd /tmp/configPkg/configUtil/scripts/ ; " + scriptParameter + " > foo.out 2> foo.err < /dev/null &", false, this.commandName, this.commandID);
        boolean success = false;
        while (!success && !this.isOverTime(timeout)) {
            this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + this.commandID + "] Waitting restore " + restoreItem + "complete...[" + this.getElapsedTimes() + "]");
            sshRecords = this.sshReceiver.executeCMD(session, "cat /tmp/output/result", true, this.commandName, this.commandID);
            this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + this.commandID + "]\n" + sshRecords.getResults());
            SSHCmdRecords sshRecords2 = this.sshReceiver.executeCMD(session, "cat /tmp/configPkg/configUtil/scripts/foo.err", true, this.commandName, this.commandID);
            if (sshRecords.getResults().contains("Restore complete")) {
                success = true;
                break;
            }
            if (sshRecords.getResults().contains("Restore fail")) {
                this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandID, "============= Restore config error ============");
                this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandID, sshRecords2.getResults());
                this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandID, "===============================================");
                success = false;
                break;
            }
            if (sshRecords2.getResults().toLowerCase().contains("error")) {
                this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandID, "============= Restore config error ============");
                this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandID, sshRecords2.getResults());
                this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandID, "===============================================");
                success = false;
                break;
            }
            sshRecords.clearMesg();
            sshRecords2.clearMesg();
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException ie) {
                this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.WARN, this.commandID, "Interrupt the process of waitting restore " + restoreItem + " complete.[" + this.getElapsedTimes() + "]");
                break;
            }
        }
        if (this.isOverTime(timeout)) {
            this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandID, "Restore " + restoreItem + " timeout. [" + this.getElapsedTimes() + "]");
        }
        this.sshReceiver.closeSession(session, this.commandName, this.commandID);
        return success;
    }

    public boolean configSave(String saveItem, String configSaveScript, int timeout) {
        String scriptParameter = "";
        Session session = this.sshReceiver.openSession(this.dataLANIP, SSHACCOUNT, SSHPASSWORD, this.commandName, this.commandID);
        scriptParameter = !configSaveScript.equals("") ? "./configBackup " + configSaveScript : "./configBackup";
        SSHCmdRecords sshRecords = this.sshReceiver.executeCMD(session, "cd /tmp/configPkg/configUtil/scripts/ ; " + scriptParameter + " > foo.out 2> foo.err < /dev/null &", false, this.commandName, this.commandID);
        boolean success = false;
        while (!success && !this.isOverTime(timeout)) {
            this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + this.commandID + "] Waitting Config save complete...");
            sshRecords = this.sshReceiver.executeCMD(session, "cat /tmp/output/result", true, this.commandName, this.commandID);
            SSHCmdRecords sshRecords2 = this.sshReceiver.executeCMD(session, "cat /tmp/configPkg/configUtil/scripts/foo.err", true, this.commandName, this.commandID);
            if (sshRecords.getResults().contains("Save complete")) {
                success = true;
                break;
            }
            if (sshRecords.getResults().contains("Save fail")) {
                this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandID, "============= Save config error ===============");
                this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandID, sshRecords2.getResults());
                this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandID, "===============================================");
                success = false;
                break;
            }
            if (sshRecords2.getResults().toLowerCase().contains("error")) {
                this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandID, "============= Save config error ============");
                this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandID, sshRecords2.getResults());
                this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandID, "============================================");
                sshRecords2.clearMesg();
                success = false;
                break;
            }
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException ie) {
                this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.WARN, this.commandID, "Interrupt the process of waitting save config complete.");
                break;
            }
        }
        if (this.isOverTime(timeout)) {
            this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandID, "Save " + saveItem + " timeout. [" + this.getElapsedTimes() + "]");
        }
        this.sshReceiver.closeSession(session, this.commandName, this.commandID);
        return success;
    }

    public boolean configPkgDownload() {
        boolean result = false;
        this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.INFO, this.commandID, "Download configPkg.zip by scp...");
        Session session = this.sshReceiver.openSession(this.dataLANIP, SSHACCOUNT, SSHPASSWORD, this.commandName, this.commandID);
        SSHCmdRecords sshRecords = this.sshReceiver.scpDownload(session, "/tmp/output/configPkg.zip", "./", "configPkg_new.zip");
        if (sshRecords.getStates().isFail()) {
            this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + this.commandID + "] Download configPkg fail!");
            this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandID, sshRecords.getResults());
            this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandID, sshRecords.getErrors());
            result = false;
        } else {
            this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + this.commandID + "] Download configPkg.zip success.");
            this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + this.commandID + "] Your result is stored in configPkg_new.zip.");
            result = true;
        }
        this.sshReceiver.closeSession(session);
        return result;
    }

    private boolean mountMiniOS(boolean isAMI, String bmcIP, String bmcUsername, String bmcPassword, String miniOSISOName, String serverIP) {
        if (isAMI) {
            return this.mountMiniOSAMI(bmcIP, bmcUsername, bmcPassword, miniOSISOName, serverIP);
        }
        return this.mountMiniOSVertive(bmcIP, bmcUsername, bmcPassword, miniOSISOName, serverIP);
    }

    private boolean unmountMiniOS(boolean isAMI, String bmcIP, String bmcUsername, String bmcPassword, String miniOSISOName, String serverIP) {
        if (isAMI) {
            return this.unmountMiniOSAMI(bmcIP, bmcUsername, bmcPassword, miniOSISOName, serverIP);
        }
        return this.unmountMiniOSVertive(bmcIP);
    }

    private boolean mountMiniOSAMI(String bmcIP, String bmcUsername, String bmcPassword, String miniOSISOName, String serverIP) {
        VmcliUtilService services = new VmcliUtilService(this.loggerWriter);
        String path = "./Rest_Json/vmcli_settings.json";
        File file = new File(path);
        ArrayList<File> files = new ArrayList<File>();
        files.add(file);
        services.readJsonFiles(files, VmcliServiceOptions.SET_GENERAL_CONFIG);
        services.getVmcliConfigUploadData().setCd_remote_user_name("smbuser");
        services.getVmcliConfigUploadData().setCd_remote_password(SSHPASSWORD);
        services.getVmcliConfigUploadData().setCd_remote_server_address(serverIP);
        services.getVmcliConfigUploadData().setCd_remote_source_path("/public");
        services.openSession(bmcIP, bmcUsername, bmcPassword, true);
        if (!services.execute(bmcIP, VmcliServiceOptions.SET_GENERAL_CONFIG)) {
            this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + bmcIP + "] Rest set config fail!");
            services.closeSession(bmcIP);
            return false;
        }
        this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + bmcIP + "] Rest set config success.");
        if (!services.execute(bmcIP, VmcliServiceOptions.LIST_IMAGE)) {
            this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + bmcIP + "] Rest list image fail!");
            services.closeSession(bmcIP);
            return false;
        }
        this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + bmcIP + "] Rest list image success.");
        for (AbstractJSONPOJO records : services.getJsonResults()) {
            if (!(records instanceof AMIRestVmcliImages)) continue;
            String isoName = ((AMIRestVmcliImages)records).getImage_name();
            BigInteger index = ((AMIRestVmcliImages)records).getImage_index();
            this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + bmcIP + "] Image index:" + index + " name:" + isoName);
            if (!isoName.equals(miniOSISOName)) continue;
            path = "./Rest_Json/vmclimount.json";
            file = new File(path);
            files.clear();
            files.add(file);
            services.readJsonFiles(files, VmcliServiceOptions.MOUNT);
            services.getVmcliImgUploadData().setImage_index(index);
            services.getVmcliImgUploadData().setImage_name(miniOSISOName);
            break;
        }
        if (!services.execute(bmcIP, VmcliServiceOptions.MOUNT)) {
            this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + bmcIP + "] Rest mount ISO fail!");
            services.closeSession(bmcIP);
            return false;
        }
        this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + bmcIP + "] Rest mount ISO success.");
        services.closeSession(bmcIP);
        return true;
    }

    private boolean unmountMiniOSAMI(String bmcIP, String bmcUsername, String bmcPassword, String miniOSISOName, String serverIP) {
        VmcliUtilService services = new VmcliUtilService(this.loggerWriter);
        File file = new File(ClassLoader.getSystemClassLoader().getResource("ami/vmclimount.json").getPath().replace("%20", " "));
        ArrayList<File> files = new ArrayList<File>();
        files.add(file);
        services.readJsonFiles(files, VmcliServiceOptions.MOUNT);
        services.getVmcliImgUploadData().setImage_name(miniOSISOName);
        services.openSession(bmcIP, bmcUsername, bmcPassword, true);
        services.execute(bmcIP, VmcliServiceOptions.UNMOUNT);
        services.closeSession(bmcIP);
        return true;
    }

    private boolean mountMiniOSVertive(String bmcIP, String bmcUsername, String bmcPassword, String miniOSISOName, String serverIP) {
        boolean result = false;
        this.localReceiver.changeFilePermission("tools/vmcliUtility/*", this.commandName, this.commandID);
        VmcliMountInfo vmcliMountInfo = new VmcliMountInfo();
        vmcliMountInfo.setBmcIP(bmcIP);
        vmcliMountInfo.setBmcUsername(bmcUsername);
        vmcliMountInfo.setBmcPassword(bmcPassword);
        vmcliMountInfo.setCdROM(miniOSISOName);
        result = this.localReceiver.vmcliMount(vmcliMountInfo, this.commandName, this.commandID);
        return result;
    }

    private boolean unmountMiniOSVertive(String bmcIP) {
        boolean unmount = false;
        int counter = 0;
        while (!(unmount = this.localReceiver.vmcliUnmount(bmcIP, this.commandName, this.commandID))) {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                break;
            }
            if (!unmount && ++counter < 10) continue;
        }
        return unmount;
    }

    private String waitBootComplete(Map<String, String> macs, String bmcIP, String username, String password, ConnectionHandle handle) {
        int count = 0;
        String dataLANIP = "0.0.0.0";
        Session session = null;
        do {
            ++count;
            if (Thread.currentThread().isInterrupted()) break;
            if (count % 50 == 0) {
                this.ipmiReceiver.chassisPowerCommand(handle, PowerCommand.PowerCycle, this.commandName, this.commandID);
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException ie) {
                break;
            }
            dataLANIP = this.debugFile != null ? this.findIPByDebugFile(bmcIP, this.debugFile.getAbsolutePath()) : this.localReceiver.getActivateDHCPIP(macs, this.commandName, this.commandID);
            if (dataLANIP.equals("0.0.0.0")) {
                this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + this.commandID + "] Wait for target node boot complete ...[" + this.getElapsedTimes() + "](" + count + ")");
                continue;
            }
            this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + this.commandID + "] Find data LAN IP:" + dataLANIP);
            if (!this.localReceiver.pingDataLAN(dataLANIP, this.commandName, this.commandID)) {
                this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + this.commandID + "] Wait for target node boot complete ... [" + this.getElapsedTimes() + "](" + count + ")");
                continue;
            }
            session = this.sshReceiver.openSession(dataLANIP, username, password, this.commandName, this.commandID);
            if (!session.isConnected()) {
                this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + this.commandID + "] Wait for target node boot complete ... [" + this.getElapsedTimes() + "](" + count + ")");
                if (count <= 200) continue;
                break;
            }
            this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + this.commandID + "] Target node boot complete ... [" + this.getElapsedTimes() + "](" + count + ")");
            this.sshReceiver.closeSession(session, this.commandName, this.commandID);
            break;
        } while (count <= 200);
        return dataLANIP;
    }

    private String findIPByDebugFile(String bmcIP, String debugFileAbsPath) {
        String dataLANIP = "0.0.0.0";
        List<String> srcList = CommonFunction.readFile(debugFileAbsPath);
        if (srcList.isEmpty()) {
            System.out.println("Debug file is empty, please check file content!\n");
            return "0.0.0.0";
        }
        for (String line : srcList) {
            String[] para = line.split(",");
            if (!para[0].equals(bmcIP)) continue;
            dataLANIP = para[1];
            this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + this.commandID + "] Get data lan IP from debug:" + dataLANIP);
            break;
        }
        return dataLANIP;
    }

    private boolean transportConfigPkg(String dataLANIP, String absConfigPkgPath) {
        Session session = this.sshReceiver.openSession(dataLANIP, SSHACCOUNT, SSHPASSWORD, this.commandName, this.commandID);
        this.sshReceiver.scp(session, new File(absConfigPkgPath), "/tmp/");
        String configPkgName = new File(absConfigPkgPath).getName();
        SSHCmdRecords sshRecords = this.sshReceiver.executeCMD(session, "cd /tmp/ ; unzip " + configPkgName + " ; chmod -R 755 *", false, this.commandName, this.commandID);
        if (sshRecords.getStates().isFail()) {
            this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + this.commandID + "] Extract configPkg fail.");
            this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandID, sshRecords.getResults());
            this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandID, sshRecords.getErrors());
            sshRecords.clearMesg();
            this.sshReceiver.closeSession(session, this.commandName, this.commandID);
            return false;
        }
        this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + this.commandID + "] Extract configPkg success.");
        sshRecords.clearMesg();
        this.sshReceiver.closeSession(session);
        return true;
    }

    private void forcePowerONorCycle(ConnectionHandle handle) {
        GetChassisStatusResponseData powerStates = this.ipmiReceiver.getChassisPowerStates(handle, this.commandName, this.commandID);
        if (!powerStates.isPowerOn()) {
            this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + this.commandID + "] Target node power off and start to turn on.");
            this.ipmiReceiver.chassisPowerCommand(handle, PowerCommand.PowerUp, this.commandName, this.commandID);
            do {
                this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + this.commandID + "] Wait for target node power on.");
                powerStates = this.ipmiReceiver.getChassisPowerStates(handle, this.commandName, this.commandID);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (!powerStates.isPowerOn());
        } else {
            this.ipmiReceiver.chassisPowerCommand(handle, PowerCommand.PowerCycle, this.commandName, this.commandID);
            this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + this.commandID + "] Reboot target node.");
        }
    }

    private Map<String, String> get3LANMACs(String bmcIP, String bmcUsername, String bmcPassword) {
        HashMap<String, String> macs = new HashMap<String, String>();
        GetMACListCommand command = new GetMACListCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword).setGroupID(0).build();
        CommandTaskRecords record = new CommandTaskRecords(command);
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            record.setStates(EngineRecordStates.Fail);
            return null;
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            record.setStates(EngineRecordStates.Fail);
            return null;
        }
        try {
            LANMacData lanList = command.getCommandResults().get(0).castConcreteJSON(LANMacData.class);
            macs.put("LAN1", lanList.getLan1());
            macs.put("LAN2", lanList.getLan2());
            macs.put("LAN3", lanList.getLan3());
            macs.put("LAN4", lanList.getLan4());
            this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + bmcIP + "] Data LAN 1 MAC address : " + (String)macs.get("LAN1"));
            this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + bmcIP + "] Data LAN 2 MAC address : " + (String)macs.get("LAN2"));
            this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + bmcIP + "] Data LAN 3 MAC address : " + (String)macs.get("LAN3"));
            this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + bmcIP + "] Data LAN 4 MAC address : " + (String)macs.get("LAN4"));
            command.close();
        }
        catch (Exception e) {
            this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + bmcIP + "] Get LAN MAC fail!");
            record.setStates(EngineRecordStates.Fail);
            return null;
        }
        return macs;
    }

    private String getElapsedTimes() {
        Period period = new Period((ReadableInstant)this.startTime, (ReadableInstant)new DateTime());
        this.totalElapsedTimes = ELAPSED_TIME_FORMATTER.print((ReadablePeriod)period);
        return this.totalElapsedTimes;
    }

    private boolean isOverTime(int timeout) {
        DateTime now = new DateTime();
        DateTime timeLimit = this.startTime.plusMinutes(timeout);
        return now.compareTo((ReadableInstant)timeLimit) > 0;
    }
}

