/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.FRU.record;

import Gbt.utility.FRU.record.MultiRecordInfo;
import Gbt.utility.SDR.record.EntityId;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.veraxsystems.vxipmi.common.TypeConverter;

public class BaseCompatibilityInfo
extends MultiRecordInfo {
    private int manufacturerId;
    private EntityId entityId;
    private int compatibilityBase;
    private int codeStart;
    private byte[] codeRangeMasks;

    public BaseCompatibilityInfo(byte[] fruData, int offset, int length) {
        byte[] buffer = new byte[4];
        System.arraycopy(fruData, offset, buffer, 0, 3);
        buffer[3] = 0;
        this.manufacturerId = TypeConverter.littleEndianByteArrayToInt(buffer);
        this.entityId = EntityId.parseInt(TypeConverter.byteToInt(fruData[offset + 3]));
        this.compatibilityBase = TypeConverter.byteToInt(fruData[offset + 4]);
        this.codeStart = TypeConverter.byteToInt(fruData[offset + 5]) & 0x7F;
        this.codeRangeMasks = new byte[length - 6];
        System.arraycopy(fruData, 6, this.codeRangeMasks, 0, length - 6);
    }

    @JsonProperty(value="ManufacturerId")
    public int getManufacturerId() {
        return this.manufacturerId;
    }

    public void setManufacturerId(int manufacturerId) {
        this.manufacturerId = manufacturerId;
    }

    @JsonProperty(value="EntityId")
    public EntityId getEntityId() {
        return this.entityId;
    }

    public void setEntityId(EntityId entityId) {
        this.entityId = entityId;
    }

    @JsonProperty(value="CompatibilityBase")
    public int getCompatibilityBase() {
        return this.compatibilityBase;
    }

    public void setCompatibilityBase(int compatibilityBase) {
        this.compatibilityBase = compatibilityBase;
    }

    @JsonProperty(value="CodeStart")
    public int getCodeStart() {
        return this.codeStart;
    }

    public void setCodeStart(int codeStart) {
        this.codeStart = codeStart;
    }

    @JsonProperty(value="CodeRangeMasks")
    public byte[] getCodeRangeMasks() {
        return this.codeRangeMasks;
    }

    public void setCodeRangeMasks(byte[] codeRangeMasks) {
        this.codeRangeMasks = codeRangeMasks;
    }
}

